#line 22 "process_frame.ipk"
from interscript.frames.site import site_frame
from interscript.frames.platform import platform_frame
from interscript.frames.masterf import master_frame
from interscript.drivers.sources.base import eoi
import sys
import traceback
import time

class process_frame:
  def __init__(self, global_frame, process_options, argument_frames):
    self.global_frame = global_frame
    self.process_options = process_options
    self.argument_frames = argument_frames

    self.break_on_error = 0
    self.debug_constructors = 0
    self.debug_destructors = 0
    self.verbosity = process_options.verbosity
    self.update_files = 1

    plat = platform_frame()
    self.site_frame = site_frame(plat)
    # self.site_frame.print_install()

  def run(self):
    oldstdout = sys.stdout
    oldstderr = sys.stderr
    f = self.process_options.logfile
    m = self.process_options.logfile_mode
    if self.process_options.logfile:
      try:
        sys.stderr = sys.stdout = open(f,m)
      except IOError:
        print 'Cannot open specified logfile',f
      except:
        print 'Weird error opening specified logfile',f
        traceback.print_exc()

    reference_date = time.time()
    local_time = time.localtime(reference_date)
    local_time_string = time.strftime("%a %d %b, %Y %H:%M:%S (%Z)",local_time)
    start_time = time.clock()
    if m: print '<CDATA>'
    print
    print '---------------------------------'
    print 'Interscript '+self.global_frame.version +\
      '['+str(self.global_frame.buildno)+'] Process',local_time_string

    try:
      for argument_frame in self.argument_frames:
        master_frame(self,argument_frame)
    finally:
      end_time = time.clock()
      elapsed_time = end_time - start_time
      print 'Elapsed Process Time',int(elapsed_time),'seconds'
      print '================================'
      print
      sys.stdout = oldstdout
      sys.stderr = oldstderr

  def get_process_frame(self): return self

#line 86 "process_frame.ipk"
  def py_exec(self,py,file,count,glb,user):
    # get a lock here, release it later
    try:
      if self.verbosity>4: print 'Executing',py
      exec py in glb,user
    except KeyboardInterrupt:
      self.update_files = 0
      raise KeyboardInterrupt
    except eoi:
      raise eoi
    except:
      print 'error executing python:',file,count,':',py
      traceback.print_exc()
      if self.break_on_error:
        self.update_files = 0
        sys.exit()

