#line 11 "felix_fincat.ipk"
# finite category
from interscript.felix.model.basecat import category
class fincat(category):
#line 16 "felix_fincat.ipk"
  def __init__(self):
    self.objects = {}
      # keyed by object, value is pair of lists
      # 0: arrows which go out of this object (except self)
      # 1: arrows which go into this object (except self)
    self.arrows = {}
      # keyed by arrow, value is pair (head, tail) of arrow
      # excludes objects
    self.rules = {}
      # keyed by pair, value is result
      # excludes keys for which one or both arguments are identities

#line 30 "felix_fincat.ipk"
  def get_nonobjects(self):
    """return a list of all non-identity arrows
    """
    return self.arrows.keys()

  def get_objects(self):
    'return a list of all identity arrows'
    return self.objects.keys()

  def get_arrows(self):
    """return a list of all arrows
    """
    return self.objects.keys() + self.arrows.keys()

  def domain(self, arrow):
    """get the domain/tail/source object of an arrow
    """
    if arrow in self.objects.keys(): return arrow
    else: return self.arrows[arrow][0]

  def codomain(self, arrow):
    """return the codomain/head/destination object of an arrow
    """
    if arrow in self.objects.keys(): return arrow
    else: return self.arrows[arrow][1]

  def get_arrows_outof(self, arrow):
    """return a list of all the arrows which can be appended to this arrow
    """
    return self.objects[self.codomain(arrow)][0]

  def get_arrows_into(self, object):
    """return a list of all the arrows which can be prepended to this arrow
    """
    return self.objects[self.domain(arrow)][1]

  def can_compose(self,a,b):
    """return 1 if arrows can be composed (left to right),
       else return 0
    """
    return self.codomain(a) == self.domain(b)

  def compose(self, a, b):
    """return the composition of two arrows,
       raise exception if not composable
    """
    if not self.can_compose(a,b):
      raise 'cannot compose arrows in "compose"'
    if a in self.get_objects(): return b
    elif b in self.get_objects(): return a
    else: return self.rules[(a,b)]

#line 84 "felix_fincat.ipk"
  def is_arrow(self, arrow):
    return arrow in self.get_arrows()

  def is_object(self, arrow):
    return arrow in self.get_objects()

#line 92 "felix_fincat.ipk"
  def add_arrow(self, arrow, src, dst):
    """add new arrow to pre-category,
       raise exception if duplicate or
       domain or codomain not extant objects
    """
    if arrow in self.get_arrows():
      raise 'duplicate arrow in "add arrow"'
    if src not in self.get_objects():
      raise 'src not defined in "add arrow"'
    if dst not in self.get_objects():
      raise 'dst not defined in "add arrow"'

    self.arrows[arrow] = (src, dst)
    self.objects[src][0].append(arrow)
    self.objects[dst][1].append(arrow)

  def add_object(self, object):
    """add new object to pre-category,
       raise exception iof duplicate
    """
    if object in self.get_arrows():
      raise 'duplicate arrow in "add object"'
    self.objects[object]=([],[])

  def add_rule(self, left, right, result):
    """add new rule to composition rules,
       raise exception if arrows not defined or
       cannot be composed or
       the rule is already known

    """
    msg = ' in add_rule('+str(left)+', '+str(right)+', '+str(result)+')'
    if left not in self.get_arrows():
      raise 'first argument not an arrow'+msg
    if right not in self.get_arrows():
      raise 'second argument not an arrow'+msg
    if result not in self.get_arrows():
      raise 'result not an arrow'+msg

    if self.codomain(left) != self.domain(right):
      raise 'arguments cannot be composed'+msg
    if self.domain(left) != self.domain(result):
      raise 'first argument and result require same domain'+msg
    if self.codomain(right) != self.codomain(result):
      raise 'second argument and result require same codomain'+msg

    if left in self.get_objects() or right in self.get_objects():
      raise 'attempted to add (duplicate or conflicting) identity rule'
    pair = (left, right)
    if self.rules.has_key(pair):
      raise 'duplicate composition rule'
    self.rules[pair] = result

  def copy(self):
    cat = precategory()
    cat.objects = self.objects.copy()
    cat.arrows = self.arrows.copy()
    cat.rules = self.rules.copy()
    return cat

  def extend(self, cat):
    # add all the arrows and rules from another category
    # it is OK to add an arrow that already exists, provided
    # it obeys the same rules

    for object in cat.objects:
      if object not in self.objects:
        self.add_object(object)
    for arrow in cat.arrows.keys():
      if arrow not in self.arrows:
        self.add_arrow(arrow)
      elif self.arrows[arrow] != cat.arrow[arrow]:
        raise 'incompatible domain or codomain for arrow in "extend category"'
    for rule in cat.rules.keys():
      if not self.rules.has_key(rule):
        self.rules[rule] = cat.rules[rule]
      elif self.rules[rule] != cat.rules[rule]:
        raise 'incompatible composition rules in "extend category"'

  def check_complete(self):
    # check that every composible pair has a composition rule
    # skip identities because they're always correct implicitly
    nonobjects = self.get_nonobjects()
    for arrow in nonobjects:
      dom = self.arrows[arrow][0]
      cod = self.arrows[arrow][1]
      for left in self.objects[dom][1]: # arrows into the domain
        if not self.rules.has_key((left, arrow)):
          raise 'incomplete composition set ('+str(left)+', '+str(arrow)+')'
      for right in self.objects[cod][0]: # arrows out of the codomain
        if not self.rules.has_key((arrow, right)):
          raise 'incomplete composition set ('+str(arrow)+', '+str(right)+')'


  def check_associative(self):
    for a in self.get_nonobjects():
      for b in self.get_nonobjects():
        for c in self.get_nonobjects():
          if self.can_compose(a,b) and self.can_compose(b,c):
            ab = self.compose(a,b)
            bc = self.compose(b,c)
            if self.compose(ab,c) != self.compose(a,bc):
              raise 'Nonassociative precategory'

  def print_everything(self, offset=0, compose_sym = '.'):
    p = ' ' * offset
    print p + 'objects:',self.objects.keys()
    print p + 'arrows:'
    for arrow in self.get_nonobjects():
      dom = self.domain(arrow)
      cod = self.codomain(arrow)
      print p + '  '+str(arrow)+':'+str(dom)+'-->'+str(cod)
    print p+'rules:'
    for pair in self.rules.keys():
      result = self.rules[pair]
      print (p + '  '+str(pair[0])+' '+compose_sym+' '+str(pair[1])+
        ' = '+str(result))

