#line 6 "felix_cons.ipk"
from interscript.felix.model.basecat import category

#line 16 "felix_cons.ipk"
class cat_product(category):
  def __init__(self, *args):
    self.args = args
    self.len = len(args)

  def is_arrow(self,arrow):
    for i in range(self.len)):
       if not self.args[i].is_arrow(arrow[i]): return 0
    return 1

  def is_object(self,object):
    for i in range(self.len)):
       if not self.args[i].is_object(object[i]): return 0
    return 1

  def can_compose(self, left, right):
    for i in range(self.len):
      if not self.args[i].can_compose(left[i],right[i]): return 0
    return 1

  def compose(self, left, right):
    l = []
    for i in range(self.len):
      l.append(self.args[i](left[i],right[i]))
    return tuple(l)

  def domain(self, x):
    l = []
    for i in range(self.len):
      l.append(self.args[i].domain(x[i]))
    return tuple(l)

  def codomain(self, x):
    l = []
    for i in range(self.len):
      l.append(self.args[i].codomain(x[i]))
    return tuple(l)

#line 58 "felix_cons.ipk"
class cat_dual(category):
  def __init__(self, arg):
    self.arg = arg

  def is_arrow(self,arrow):
    return self.arg.is_arrow(arrow)

  def is_object(self,object):
    return self.arg.is_object(arrow)

  def can_compose(self, left, right):
    return self.arg.can_compose(right, left)

  def compose(self, left, right):
    return self.arg.compose(right, left)

  def domain(self, x):
    return self.arg.codomain(x)

  def codomain(self, x):
    return self.arg.domain(x)

#line 88 "felix_cons.ipk"
class cat_union(category):
  def __init__(self, *args):
    self.args = args
    self.len = len(args)

  def is_arrow(self,arrow):
     for i in range(self.len)):
       if self.args[i].is_arrow(arrow): return 1
    return 0

  def is_object(self,object):
     for i in range(self.len)):
       if self.args[i].is_object(object): return 1
    return 0

  def can_compose(self, left, right):
    for i in range(self.len):
      if (
        self.args[i].is_arrow(left) and
        self.args[i].is_arrow(right) and
        self.args[i].can_compose.(left,right)): return 1
    return 0

  def compose(self, left, right):
    for i in range(self.len):
      if (
        self.args[i].is_arrow(left) and
        self.args[i].is_arrow(right)):
        return self.args[i](left,right)

  def domain(self, x):
    for i in range(self.len):
      if self.args[i].is_arrow(x):
        return self.args[i].domain(x)

  def codomain(self, x):
    for i in range(self.len):
      if self.args[i].is_arrow(x):
        return self.args[i].codomain(x)

#line 131 "felix_cons.ipk"
class cat_tagged(category):
  def __init__(self, tag, arg):
    self.arg = arg
    self.tag = tag

  def is_arrow(self,arrow):
    return arrow[0] == self.tag and self.arg.is_arrow(arrow[1])

  def is_object(self,object):
    return arrow[0] == self.tag and self.arg.is_object(arrow[1])

  def compose(self, left, right):
    return (self.tag, self.arg.compose(right[1], left[1]))

  def domain(self, x):
    return (self.tag, self.arg.codomain(x))

  def codomain(self, x):
    return (self.tag, self.arg.domain(x))

class unique_tag: pass

#line 160 "felix_cons.ipk"
def cat_dunion(*args):
  cats = []
  for cat in args:
    cats.append(cat_tagged(unique_tag(),cat))
  return apply(cat_union, tuple(cats))

