#line 317 "source_drivers.ipk"
#---------------------------------------------------------
# gets input by FTP
import ftplib
import time
import os
from interscript.drivers.sources.base import file_source
from interscript.drivers.sources.base import eof
import string

class ftp_file_source(file_source):
  def __init__(self,host,remote_filename,**kwds):
    apply(file_source.__init__, (self,), kwds)
    self.name = remote_filename
    self.remote_filename = remote_filename
    self.host = host
    self.g = g
    for k in kwds.keys():
      self.__dict__[k]=kwds[k]
    if not hasattr(self,'local_filename'):
      self.local_filename = self.remote_filename
    self.os = os
    self.fetch()
    self.file = open(self.local_filename,'r')
    self.closed = 0

  def transfer(self,data):
    self.file.write(data+'\n')

  def fetch(self):
    if not hasattr(self,'refresh_interval'):
      self.refresh_interval = 28
    if self.refresh_interval < 0: self.refresh_interval = 100000
    self.local_file_exists = 1
    try:
      f = open(self.local_filename)
      f.close()
      if verbosity>=4: print 'local file',self.local_filename,'exists'
    except:
      if verbosity>=4: print 'local file',self.local_filename,'does NOT exist'
      self.local_file_exists = 0

    if self.local_file_exists:
      self.local_file_modify_time = os.stat(self.local_filename)[stat.ST_MTIME]
      now = time.time()
      age = (now - self.local_file_modify_time)/ (24 * 60 * 60)
      download = age > self.refresh_interval
    else:
      download = 1

    if hasattr(self.g,'download'):
      if self.g.download == 'always': download = 1
      if self.g.download == 'never': download = 0

    if download:
      try:
        if verbosity>=2: print 'downloading',self.remote_filename
        # create FTP object
        ftp = ftplib.FTP()

        # connect to server
        if hasattr(self,'port'):
          ftp.connect(self.host,self.port)
        else:
          ftp.connect(self.host)
        print 'connected to',self.host

        # login to server
        if hasattr(self,'user'):
          if hasattr(self,'password'):
            if hasattr(self,'account'):
              ftp.login(self.user,self.password,self.account)
            else: ftp.login(self.user,self.password)
          else: ftp.login(self.user)
        else: ftp.login()
        if verbosity>=4: print 'logged in'

        # set remote directory
        if hasattr(self,'remote_directory'):
          ftp.cwd(self.remote_directory)
          print 'changed to remote directory',self.remote_directory

        # get file to a temporary
        try:
          tmp_filename = tempfile.mktemp()
          self.file= open(tmp_filename,'w')
          print 'opened',tmp_filename,'for download'
          ftp.retrlines('RETR '+self.remote_filename, self.transfer)
          self.file.close()
          ftp.quit()
          if verbosity>=2: print 'download complete'

          file = open(tmp_filename,'r')
          newlines = file.readlines()
          file.close()

          if self.local_file_exists:
            file = open(self.local_filename,'r')
            oldlines = file.readlines()
            file.close()

            if newlines != oldlines:
              if verbosity>=4: print 'Local file',self.local_filename,'UPDATED from',self.remote_filename
            else:
              if verbosity>=4: print 'Local file',self.local_filename,'unchanged'
          else:
            if verbosity>=4: print 'Writing new local file',self.local_filename

          # note that the local file is written even if it isn't changed
          # to update the time stamp
          file = open(self.local_filename,'w')
          file.writelines(newlines)
          file.close()
          self.os.remove(self.tmp_filename)

        except:
          print 'Cannot download',self.remote_filename,
          if hasattr(self,'remote_directory'):
            print 'from directory',self.remote_directory
          else: print 'of',self.host
          file.close()
          self.os.remove(tmp_filename)
          ftp.quit()

      except:
        pass # ignore errors from ftp attempt
    else:
      print 'Skipping ftp download'

