#line 102 "sink_drivers.ipk"
import os
posixpath = os.path
import errno

# OS dependent routines.
# Note: we use some posixpath functions, but don't trust them

# make the given directory, no error if it exists
# this is posix specific, and should be moved to a platform
# dependent place in the code

def create_directory(dir):
  if not posixpath.isdir(dir):
    try: os.mkdir(dir)
    except os.error, data:
      if data[0]!=errno.EEXIST: # File Exists is OK, everything else is fatal
        raise os.error, (data[0],data+': directory "'+dir+'"')
  if not posixpath.isdir(dir):
    raise os.error, (errno.ENOENT, 'Created a directory '+dir+', but it is not there!')

# given an os specific prefix and a list of component names,
# make the directory structure in which the last component is contained
# and synthesise and return its full os specific pathname

def mk_dir(prefix, pathlist):
  if len(pathlist)>1:
    # there's more than one component in the list
    # so create directories for all but the last component

    pathname = prefix+pathlist[0]
    create_directory(pathname)
    for component in pathlist[1:-1]:
      pathname = pathname + os.sep + component
      create_directory(pathname)
    pathname = pathname + os.sep + pathlist[-1]

  else:
    # only one component on the list
    pathname = prefix+pathlist[0]

  if pathname[0]!=os.sep:
    # the pathname isn't absolute, so make it so
    # get current directory
    curdir = os.getcwd()

    # strip trailing separator
    # note this should fix cases like '/' (unix) or 'd:\' (nt)
    # as well as cope with systems that return a trailing separator
    if curdir[-1] == os.sep: curdir = curdir[:-1]

    # append a separator and the pathname: there will only be one
    # separator at the join point unless the current directory
    # ends with two separators (like the URL: http://)
    pathname = curdir + os.sep + pathname
  return pathname

# this routine checks is a file exists and is readable
# (in the sense that it can be opened for read)
# it returns 1 if the file exist and can be read, 0 if the file
# doesn't exist, and throws an exception if anything else goes wrong

def file_exists(pathname):
  try:
    # note this leaks a file if it is opened but not closed :-))
    open(pathname,'r').close()
    return 1
  except IOError, data:
    if data[0] == errno.ENOENT:
      return 0
    raise IOError, data

# Note: the intention is to apply mk_dir to ensure the file has a
# parent directory, creating it if necessary, then test if the file
# already exists or has to be created. Even if it exists, it may have
# to be replaced.

