#line 311 "sink_drivers.ipk"
import string
from interscript.drivers.sinks.base import sink_base
from interscript.drivers.sinks import sink_open_error
from interscript.drivers.sinks.util import mk_dir, file_exists
import tempfile
import os

class named_file_sink(sink_base):
  def __init__(self,pass_frame,input_filename, prefix='', eol='\n'):
    self.pass_frame = pass_frame
    self.process = pass_frame.process
    self.verbosity = self.pass_frame.verbosity
    self.eol = eol

    # compute absolute pathname, and create directories if necessary
    # we don't use posixpath because we're enforcing an _interscript_
    # pathname convention here
    pathlist = string.split(input_filename,'/')
    self.basename = pathlist[-1]
    pathname = mk_dir(prefix, pathlist)

    if file_exists(pathname):
      self.tmp_filename = tempfile.mktemp()
      if self.verbosity>=4:
        print 'Generating temporary',self.tmp_filename,'for',input_filename
      try:
        file =open(self.tmp_filename,'w')
        self.pass_frame.fdict[input_filename]='temporary'
      except:
        raise sink_open_error, self.tmp_filename
      sink_base.__init__(self, filename = pathname, name = input_filename, file = file )
      self.os = os
      self.pass_frame.flist.append(input_filename)
    else:
      if self.verbosity>=3:
        print 'Generating original',input_filename
      try:
        file = open(pathname,'w')
        self.pass_frame.fdict[input_filename]='original'
      except:
        raise sink_open_error,pathname
      sink_base.__init__(self, filename = pathname, name = input_filename, file = file)
      self.pass_frame.flist.append(input_filename)

  def __del__(self):
    if self.verbosity>=5: print 'closing', self.name
    self.file.close()
    if hasattr(self,'tmp_filename'):
      if self.process.update_files:
        original_file = open(self.filename,'r')
        original_lines = original_file.readlines()
        original_file.close()

        new_file = open(self.tmp_filename,'r')
        new_lines = new_file.readlines()
        new_file.close()

        if not original_lines == new_lines:
          if self.verbosity>=1: print 'File',self.filename,'is CHANGED'
          self.pass_frame.fdict[self.name]='changed'
          file = open(self.filename,'w')
          file.writelines(new_lines)
          file.close()
        else:
          if self.verbosity>=4: print 'File',self.filename,'is unchanged'
          self.pass_frame.fdict[self.name]='unchanged'
      else:
        if self.verbosity>=1: print '*** System error inhibiting file update for',self.filename,'***'
        self.pass_frame.fdict[self.name]='cancelled'
      self.os.remove(self.tmp_filename)

  def raw_write(self,line): self.file.write(line)
  def raw_eol(self): self.raw_write(self.eol)

