#line 89 "tanglers.ipk"
#---------------------------------------------------------
# tangler base
#---------------------------------------------------------
class tangler_base:
  __class_protocols__ = 'tangler'
  def __init__(self,sink,weaver):
    self.sink = sink
    self.weaver = weaver
    self.inhibit_sref = 0
    self.pass_frame = weaver.pass_frame
    self.master = self.pass_frame.master
    self.process = self.master.process
    self.language = 'data'

  def get_language(self): return self.language

  def write_comment(self,line):
    pass

  def _writeline(self,data):
    self.sink.writeline(data)

  def _write_and_echo(self,data):
    self._writeline(data)
    if self.weaver:
      self.weaver.echotangle(self.sink.lines_written,data)

  def writeline(self,data,file,count, inhibit_sref=0):
    if not inhibit_sref and not self.inhibit_sref:
      if (file != self.sink.last_source_file or
        count != self.sink.last_source_count+1):
        self.start_section(file,count)
    self.sink.last_source_file = file
    self.sink.last_source_count = count
    self._write_and_echo(data)

  def start_section(self,file,count): pass

#---------------------------------------------------------
# builtin tanglers: null, data, c, script
#---------------------------------------------------------

