#line 16 "interscript_options.ipk"
import sys
import traceback

from interscript.getoptions import getopt

#line 23 "interscript_options.ipk"
#option help dictionary
shortoptdict = { 'v':'verbose (verbosity=6)' }

longoptdict = {
  'echo_input=':{0:"Don't echo input (default)",1:'Echo input'},
  'verbosity=': {
    0:'no messages', # none _at all_, not even serious errors
    1:'fatal messages', # _only_ serious errors
    2:'warnings',       # all errors
    3:'brief progress', # open and close weavers, tanglers, files
    4:'progress and information', # headings, 'watch it run'
    5:'full progress and information', # full user information
    6:'user source debugging', # full debugging of _user_ script
    7:'interscript debugging', # basic control flow debugging
    8:'full interscript debugging', # enough to debug interscript itself
    9:'eveything' # for unintelligible output :-)
  },
  'weaver=': {
    'html': 'flat html',
    'tex': 'plain tex (not implemented)',
    'latex': 'latex2e',
    'text':'plain text',
    'ps': 'postscript (not implemented)',
    'eps': 'encapsulated postscript (not implemented)',
    'rtf': 'Rich Text (not implemented)',
    'word': 'microsoft word (not implemented)',
    'none': 'disable built-in weaving'
  },
  'tangler-prefix=':'absolute native os prefix prepended to tangled code filenames',
  'weaver-prefix=':'absolute native os prefix prepended to woven documentation filenames',
  'tangler-directory=':'interscript filename prefix prepended to tangled code filenames',
  'weaver-directory=':'interscript filename prefix prepended to woven documentation filenames',
  'source-prefix=':'absolute native prefix prepended to input filename',
  'python=':'execute python script',
  'update=':{
    0:'Allow buffered file write (default)',
    1:'Inhibit buffered file write'},
  'download=':{
    0:'only download by ftp or http when necessary',
    1:'force download by ftp or http'},
  'refresh_interval=':
    'download when local file is older than this number of days (default 28)',
  'tabwidth=':'column width for tab expansion (default 8)',
  'passes=':'passs on each file (default 1)',
  'logfile=':'<filename> for messages',
  'help':'this help',
  'usage':'this help' }


def print_help():
  print 'Usage: python iscr.py [options] <filename>'
  print '  options:'
  for k in shortoptdict.keys(): print_help1(k)
  for k in longoptdict.keys(): print_help1(k)

def print_help1(k):
  if longoptdict.has_key(k):
    k = '--'+ k + '='
    values = longoptdict[k]
  elif shortoptdict.has_key(k+'='):
    k = '-' + k + '='
    values = shortoptdict[k]
  else:
    values = 'Unknown option'

  print '  '+k,
  if values is None:
    print
  elif type(values) is type({}):
    print
    for value in values.keys():
      print '   '+str(value)+':',values[value]
  else:
    print values

#line 101 "interscript_options.ipk"
class argument_frame:
  def copy(self):
     other = argument_frame()
     other.__dict__ = self.__dict__.copy()
     return other

def getoption_frames(args): # note: has side effects!
  parsed =  getopt(args)
  process_options = argument_frame()
  process_options.verbosity = 2
  master_frames = []

  frame = argument_frame()
  frame.echo_input = 0
  frame.update_files = 1
  frame.tabwidth = 8
  frame.verbosity = 2
  frame.download = 'regularly'
  frame.refresh_interval = 28
  frame.passes = 1
  frame.weaver_prefix = ''
  frame.tangler_prefix = ''
  frame.weaver_directory= ''
  frame.tangler_directory = ''
  frame.source_prefix = ''
  frame.autoweave = []
  frame.useropt = {}

  for opts,filename in parsed:
    for opt,value in opts:
      try:
        if opt == 'verbosity': process_options.verbosity = frame.verbosity = int(value)
        elif opt == 'echo_input': frame.echo_input = int(value)
        elif opt == 'v': process_options.verbosity = frame.verbosity = 6
        elif opt == 'noupdate': frame.update_files = 0
        elif opt == 'nodownload': frame.download = 'never'
        elif opt == 'download': frame.download = 'always'
        elif opt == 'tabwidth': frame.tabwidth = int(value)
        elif opt == 'passes': frame.passes = int(value)
        elif opt == 'weaver': frame.autoweave.append(value)
        elif opt == 'weaver-prefix': frame.weaver_prefix = value
        elif opt == 'tangler-prefix': frame.tangler_prefix = value
        elif opt == 'weaver-directory': frame.weaver_directory = value
        elif opt == 'tangler-directory': frame.tangler_directory = value
        elif opt == 'source-prefix': frame.source_prefix = value
        elif opt == 'python':
          try:
            if process_options.verbosity>=3:
              print 'Executing python:'
              print value
            exec value
          except:
            print 'Error in python option'
            traceback.print_exc()
        elif opt == 'logfile':
          oldsysout = sys.stdout
          sys.stdout = open(value,'a')
        elif opt in ['help', 'usage']:
          print_help()
          print
        else:
          # FIX: all options should be OK (user options?)
          print 'Nonstandard option',opt,'value',value,'accepted as user option'
          frame.useropt[opt]=value
        if process_options.verbosity>=4: print 'Option:',opt,value
      except:
        print 'Warning: Option',opt,'has bad value',value
        prefix = ''
        while opt[0]=='-': prefix = prefix + '-'; opt=opt[1:]
        print_help1(opt)

    frame.filename = filename
    master_frames.append(frame.copy())
  return process_options, master_frames


