#line 22 "process_frame.ipk"
from interscript.frames.site import site_frame
from interscript.frames.platform import platform_frame
from interscript.frames.masterf import master_frame
from interscript.drivers.sources.base import eoi

import traceback

class process_frame:
  def __init__(self, global_frame, process_options, argument_frames):
    self.global_frame = global_frame
    self.process_options = process_options
    self.argument_frames = argument_frames

    self.break_on_error = 0
    self.debug_constructors = 0
    self.debug_destructors = 0
    self.verbosity = process_options.verbosity
    self.update_files = 1

    plat = platform_frame()
    self.site_frame = site_frame(plat)
    # self.site_frame.print_install()

  def run(self):
    for argument_frame in self.argument_frames:
      master_frame(self,argument_frame)

  def get_process_frame(self): return self

#line 53 "process_frame.ipk"
  def py_exec(self,py,file,count,glb,user):
    # get a lock here, release it later
    try:
      if self.verbosity>4: print 'Executing',py
      exec py in glb,user
    except KeyboardInterrupt:
      self.update_files = 0
      raise KeyboardInterrupt
    except eoi:
      raise eoi
    except:
      print 'error executing python:',file,count,':',py
      traceback.print_exc()
      if self.break_on_error:
        self.update_files = 0
        sys.exit()

