#line 26 "pass_frame.ipk"
import string
import traceback
import sys

from interscript.drivers.sources import source_open_error
from interscript.drivers.sources.disk import named_file_source
from interscript.drivers.sources.base import eoi
from interscript.frames.inputf import input_frame
from interscript.weavers.auto import auto_weaver
from interscript.drivers.sources.base import eoi
from interscript.parsers.html import sgml_wrapper, html_filter

class pass_frame:
  def __init__(self,master, passno):
    # the display
    self.master = master
    self.process = master.process

    self.passno = passno

    self.verbosity = master.verbosity
    self.echo_input = master.echo_input
    self.autoweave = master.autoweave

    self.ids = {}
    self.flist = []
    self.fdict = {}
    self.iflist = []
    self.toc = []
    self.include_files = []
    self.classes = {}
    self.functions = {}
    self.testno = 0
    self.sequence = 0
    self.tests = {}
    self.section_index = {}

    if self.verbosity>=3:
      print 'Autoweave',self.autoweave

    file = self.master.filename
    if self.verbosity>=2:
      print 'Processing',file,'Pass',passno

#line 76 "pass_frame.ipk"

    basename = file
    if string.find(file,'.') != -1:
      basename = string.join(string.split(file,'.')[:-1],'.')

    weaver = auto_weaver(self, basename, self.autoweave)
    userdict = {
      'echo_input':self.echo_input,
      'verbosity':self.verbosity
      }

    try:
      input_file =named_file_source(self,file, self.master.source_prefix)

    except source_open_error, filename:
      if self.verbosity>1:
        print 'Cannot Open File',filename,'for input (ignored)'
      raise
    except KeyboardError:
      raise
    except:
      print "Program error opening",file
      traceback.print_exc()
      raise

    self.include_files.append((1,'interscript',file))
    inpt = input_frame(
      self,
      input_file,
      [],
      weaver,
      userdict,
      1)
    inpt.set_warning_character(python='@')
    if self.verbosity>=3:
      print 'input from',inpt.source.get_source_name()

    inpt.file_pass()
    # at this point, inpt, weaver, userdict, input_file
    # should all be released (even if 'pass_frame' is held onto,
    # these symbols are defined in the __init__ function frame)

  def get_pass_frame(self):
    return self

  def get_new_test_number(self):
    self.testno = self.testno + 1
    return self.testno

  def get_new_sequence_number(self):
    self.sequence = self.sequence + 1
    return self.sequence

