#line 14 "storage_drivers.ipk"
from interscript.drivers.sources.base import source
from interscript.drivers.sources.base import eof
from interscript.drivers.sinks.base import sink

class memory(source,sink):
  def __init__(self,name,**kwds):
    source.__init__(self)
    self.name = name
    self.saved = ''
    self.list = []
    for k in kwds.keys():
      self.k = kwds[k]


  def readline(self):
    print 'reading memory object',self.name,'line',self.lines_read
    if len(self.list)>self.lines_read:
      line = self.list[self.lines_read]
    else:
      raise eof
    if len(line) and line[-1]=='\n':
      line = line[:-1]
    self.lines_read = self.lines_read + 1
    return line

  def writeline(self,line=''):
    self.list.append(self.saved+line)
    self.saved = ''

  def rewind(self):
    self.lines_read = 0

  def write(self,data):
    self.saved = self.saved + data

