#!/usr/local/bin/python
#line 89 "iscr.pak"

#line 8 "iscrsrcd.pak"
class eof:
  pass

class eoi:
  pass
#line 15 "iscrsrcd.pak"
#---------------------------------------------------------
# source base
class source:
  def __init__(self, **kwds):
    self.lines_read = 0
    for k in kwds.keys():
      self.__dict__[k]=kwds[k]

  def get_source_name(self):
    return self.name

  def get_lines_read(self):
    return self.lines_read

  def readlines():
    lines = []
    try:
      while 1:
        lines.append(self.readline())
    except:
      pass
    return lines

#line 43 "iscrsrcd.pak"
#---------------------------------------------------------
# gets input from a named file

class named_file_source(source):
  def __init__(self,filename):
    source.__init__(self)
    self.name = filename
    self.file = open(filename,'r')

  def __del__(self):
    if getattr(self,'file'): self.file.close()

  def readline(self):
    line = self.file.readline()
    if len(line)==0: raise eof
    self.lines_read = self.lines_read + 1
    return line

  def get_filename(self):
    return self.name

#line 108 "iscrsrcd.pak"
# gets input from a URL

class url_source(source):
  def __init__(self,filename):
    source.__init__(self)
    self.name = filename
    self.file = urllib.urlopen(filename)

  def __del__(self):
    self.file.close()

  def readline(self):
    line = self.file.readline()
    if len(line)==0: raise eof
    self.lines_read = self.lines_read + 1
    return line

  def get_filename(self):
    return self.name

#line 171 "iscrsrcd.pak"
#---------------------------------------------------------
# gets input by FTP

class ftp_file_source(source):
  def __init__(self,host,remote_filename,**kwds):
    source.__init__(self)
    self.name = remote_filename
    self.remote_filename = remote_filename
    self.host = host
    self.g = g
    for k in kwds.keys():
      self.__dict__[k]=kwds[k]
    if not hasattr(self,'local_filename'):
      self.local_filename = self.remote_filename
    self.os = os
    self.fetch()
    self.file = open(self.local_filename,'r')

  def transfer(self,data):
    self.file.write(data+'\n')

  def fetch(self):
    if not hasattr(self,'refresh_interval'):
      self.refresh_interval = 28
    if self.refresh_interval < 0: self.refresh_interval = 100000
    self.local_file_exists = 1
    try:
      f = open(self.local_filename)
      f.close()
      if verbosity>=4: print 'local file',self.local_filename,'exists'
    except:
      if verbosity>=4: print 'local file',self.local_filename,'does NOT exist'
      self.local_file_exists = 0

    if self.local_file_exists:
      self.local_file_modify_time = os.stat(self.local_filename)[stat.ST_MTIME]
      now = time.time()
      age = (now - self.local_file_modify_time)/ (24 * 60 * 60)
      download = age > self.refresh_interval
    else:
      download = 1

    if hasattr(self.g,'download'):
      if self.g.download == 'always': download = 1
      if self.g.download == 'never': download = 0

    if download:
      try:
        if verbosity>=2: print 'downloading',self.remote_filename
        # create FTP object
        ftp = ftplib.FTP()

        # connect to server
        if hasattr(self,'port'):
          ftp.connect(self.host,self.port)
        else:
          ftp.connect(self.host)
        print 'connected to',self.host

        # login to server
        if hasattr(self,'user'):
          if hasattr(self,'password'):
            if hasattr(self,'account'):
              ftp.login(self.user,self.password,self.account)
            else: ftp.login(self.user,self.password)
          else: ftp.login(self.user)
        else: ftp.login()
        if verbosity>=4: print 'logged in'

        # set remote directory
        if hasattr(self,'remote_directory'):
          ftp.cwd(self.remote_directory)
          print 'changed to remote directory',self.remote_directory

        # get file to a temporary
        try:
          tmp_filename = tempfile.mktemp()
          self.file= open(tmp_filename,'w')
          print 'opened',tmp_filename,'for download'
          ftp.retrlines('RETR '+self.remote_filename, self.transfer)
          self.file.close()
          ftp.quit()
          if verbosity>=2: print 'download complete'

          file = open(tmp_filename,'r')
          newlines = file.readlines()
          file.close()

          if self.local_file_exists:
            file = open(self.local_filename,'r')
            oldlines = file.readlines()
            file.close()

            if newlines != oldlines:
              if verbosity>=4: print 'Local file',self.local_filename,'UPDATED from',self.remote_filename
            else:
              if verbosity>=4: print 'Local file',self.local_filename,'unchanged'
          else:
            if verbosity>=4: print 'Writing new local file',self.local_filename

          # note that the local file is written even if it isn't changed
          # to update the time stamp
          file = open(self.local_filename,'w')
          file.writelines(newlines)
          file.close()
          self.os.remove(self.tmp_filename)

        except:
          print 'Cannot download',self.remote_filename,
          if hasattr(self,'remote_directory'):
            print 'from directory',self.remote_directory
          else: print 'of',self.host
          file.close()
          self.os.remove(tmp_filename)
          ftp.quit()

      except:
        pass # ignore errors from ftp attempt
    else:
      print 'Skipping ftp download'

  def __del__(self):
    self.file.close()

  def readline(self):
    line = self.file.readline()
    if len(line)==0: raise eof
    self.lines_read = self.lines_read + 1
    return line

  def get_filename(self):
    return self.name

#line 330 "iscrsrcd.pak"
#---------------------------------------------------------
# gets input by HTTP

class http_file_source(source):
  def __init__(self,host,remote_filename,**kwds):
    source.__init__(self)
    self.name = remote_filename
    self.remote_filename = remote_filename
    self.host = host
    self.g = g
    for k in kwds.keys():
      self.__dict__[k]=kwds[k]
    if not hasattr(self,'local_filename'):
      self.local_filename = self.remote_filename
    self.os = os
    self.fetch()
    self.file = open(self.local_filename,'r')

  def fetch(self):
    if not hasattr(self,'refresh_interval'):
      self.refresh_interval = 28
    if self.refresh_interval < 0: self.refresh_interval = 100000
    self.local_file_exists = 1
    try:
      f = open(self.local_filename)
      f.close()
      print 'local file',self.local_filename,'exists'
    except:
      print 'local file',self.local_filename,'does NOT exist'
      self.local_file_exists = 0

    if self.local_file_exists:
      self.local_file_modify_time = os.stat(self.local_filename)[stat.ST_MTIME]
      now = time.time()
      age = (now - self.local_file_modify_time)/ (24 * 60 * 60)
      download = age > self.refresh_interval
    else:
      download = 1

    if hasattr(self.g,'download'):
      if self.g.download == 'always': download = 1
      if self.g.download == 'never': download = 0

    if download:
      try:
        print 'downloading',self.remote_filename
        # create HTTP object
        http = httplib.HTTP()

        # connect to server
        if hasattr(self,'port'):
          http.connect(self.host+':'+str(self.port))
        else:
          ftp.connect(self.host)
        print 'connected to',self.host

        # set remote directory
        to_download = self.remote_filename
        if hasattr(self,'remote_directory'):
          to_download = to_download + '/' + self.remote_directory

        # get file to a temporary
        try:
          http.putrequest('GET',to_download)
          http.putheader('Accept','text/html')
          http.putheader('Accept','text/plain')
          http.endheaders()
          errcode, errmsg, headers = http.getreply()
          if errcode != 200: raise 'http error '+str(errcode)+'; '+errmsg
          file = http.getfile()
          newlines = file.readlines()
          file.close()
          print 'download complete'

          if self.local_file_exists:
            file = open(self.local_filename,'r')
            oldlines = file.readlines()
            file.close()

            if newlines != oldlines:
              print 'Local file',self.local_filename,'UPDATED from',self.remote_filename
            else:
              print 'Local file',self.local_filename,'unchanged'
          else:
            print 'Writing new local file',self.local_filename

          # note that the local file is written even if it isn't changed
          # to update the time stamp
          file = open(self.local_filename,'w')
          file.writelines(newlines)
          file.close()

        except:
          print 'Cannot download',self.remote_filename,
          if hasattr(self,'remote_directory'):
            print 'from directory',self.remote_directory
          else: print 'of',self.host
          try:
            print 'code',errcode,'msg',errmsg
          except:
            pass
      except:
        pass # ignore errors from ftp attempt
    else:
      print 'Skipping http download'

    self.file = open(self.local_filename,'r')

  def __del__(self):
    self.file.close()

  def readline(self):
    line = self.file.readline()
    if len(line)==0: raise eof
    self.lines_read = self.lines_read + 1
    return line

  def get_filename(self):
    return self.name

#line 452 "iscrsrcd.pak"
#---------------------------------------------------------
# gets input from _python_ sys.stdin object
# same as named_file_source, except named 'standard input'
# and doesn't close file on destruction

class stdin_source(source):
  def __init__(self):
    source.__init__(self)
    self.name = 'standard output'

  def readline(self):
    line = sys.stdin.readline()
    if len(line)==0: raise eof
    self.lines_read = self.lines_read + 1
    return line

#line 4 "iscrsnkd.pak"
#---------------------------------------------------------
# base sink class
class sink:
  def __init__(self, **kwds):
    self.lines_written = 0
    self.last_source_file = ''
    self.last_source_line = -1
    for k in kwds.keys():
      self.__dict__[k]=kwds[k]

  def writeline(self,line):
    self.write(line+'\n')
    self.lines_written = self.lines_written  + 1

  def get_sink_name(self):
    return self.name

#line 23 "iscrsnkd.pak"
#---------------------------------------------------------
class null_sink(sink):
  def __init__(self):
    sink.__init__(self,name='null sink')

  def write(self,line):
    pass

#line 33 "iscrsnkd.pak"
#---------------------------------------------------------
# named file writer

class simple_named_file_sink(sink):
  def __init__(self,filename):
    filename = string.join(string.split(filename,'/'),os.sep)
    sink.__init__(self, name = filename, file = open(filename,'w'))
    g.flist.append(filename)

  def __del__(self):
    self.file.close()

  def write(self,line):
    self.file.write(line)

#line 77 "iscrsnkd.pak"
#---------------------------------------------------------
# buffered named file writer

class named_file_sink(sink):
  def __init__(self,filename):
    self.g = g
    try:
      open(filename,'r').close()
      self.tmp_filename = tempfile.mktemp()
      if verbosity>=4: print 'Generating temporary',self.tmp_filename,'for',filename
      sink.__init__(self, filename = filename, wd = os.getcwd(), name = filename, file = open(self.tmp_filename,'w'))
      self.os = os
    except:
      if verbosity>=3: print 'Generating original',filename
      sink.__init__(self, filename = filename, name = filename, file = open(filename,'w'))
    g.flist.append(filename)

  def __del__(self):
    if verbosity>=5: print 'closing', self.name
    self.file.close()
    if hasattr(self,'tmp_filename'):
      if self.g.update_files:
        wd = self.os.getcwd()
        os.chdir(self.wd)
        original_file = open(self.filename,'r')
        original_lines = original_file.readlines()
        original_file.close()

        os.chdir(wd)
        new_file = open(self.tmp_filename,'r')
        new_lines = new_file.readlines()
        new_file.close()

        if not original_lines == new_lines:
          if verbosity>=4: print 'File',self.filename,'is CHANGED'
          os.chdir(self.wd)
          file = open(self.filename,'w')
          file.writelines(new_lines)
          file.close()
          os.chdir(wd)
        else:
          if verbosity>=5: print 'File',self.filename,'is unchanged'
      else:
        if verbosity>=1: print 'System error inhibiting file update',self.filename
      self.os.remove(self.tmp_filename)

  def write(self,line):
    self.file.write(line)

#line 128 "iscrsnkd.pak"
#---------------------------------------------------------
# window output

class gui_output(sink):
  def __init__(self,tk, window_name):
    sink.__init__(self,name = window_name, tk = tk)
    self.tk.pytcl_eval(
      'toplevel '+window_name+'\n'+
      'tixScrolledText '+window_name+'.t\n'+
      'pack '+window_name+'.t')

  def __del__(self):
    self.tk.pytcl_eval('destroy '+self.name)

  def write(self,line):
    self.tk.pytcl_eval(
      '['+self.name+'.t subwidget text] insert end '+str(_pytcl.new_string(line).enquote())+'\n'+
      'update'
    )

#line 150 "iscrsnkd.pak"
#---------------------------------------------------------
# stdout writer

class stdout_sink(sink):
  def __init__(self):
    sink.__init__(self,name='standard output')

  def write(self,line):
    sys.stdout.write(line)

#line 12 "iscrstor.pak"
#---------------------------------------------------------
# This object is both a reader and a writer!

class memory(source,sink):
  def __init__(self,name,**kwds):
    source.__init__(self)
    self.name = name
    self.saved = ''
    self.list = []
    for k in kwds.keys():
      self.k = kwds[k]


  def readline(self):
    print 'reading memory object',self.name,'line',self.lines_read
    if len(self.list)>self.lines_read:
      line = self.list[self.lines_read]
    else:
      raise eof
    if len(line) and line[-1]=='\n':
      line = line[:-1]
    self.lines_read = self.lines_read + 1
    return line

  def writeline(self,line=''):
    self.list.append(self.saved+line)
    self.saved = ''

  def rewind(self):
    self.lines_read = 0

  def write(self,data):
    self.saved = self.saved + data

#line 56 "iscrstor.pak"
#---------------------------------------------------------
# This object is both a reader and a writer!

class disk(source,sink):
  pass
  # not implemented yet :-(

#line 34 "iscrweav.pak"
class weaver_base:
  def __init__(self):
    self.hcount = []
    self.enabled = 1
    self.translating = 1
    self.tags = []

  def new_heading(self,level):
    while level>len(self.hcount): self.hcount.append(0)
    while level<len(self.hcount): del self.hcount[-1]
    counter = self.hcount[level-1]+1
    self.hcount[level-1] = counter
    return counter

  def get_formatted_heading_number(self):
    hnumber = ''
    for i in range(0,len(self.hcount)-1):
      hnumber = hnumber + str(self.hcount[i])+'.'
    hnumber = hnumber + str(self.hcount[-1])
    return hnumber

  def enable(self): self.enabled = 1
  def disable(self): self.enabled = 0
  def translate(self): self.translating = 1
  def raw(self): self.translating = 0
  def add_tag(self,tag): self.tags.append(tag)
  def rawif(self,tag):
    if tag in self.tags: self.raw()
    else: self.disable()

  def writeline(self,line=''):
    self.write(line + '\n')

  def write(self,line):
    self.sink.write(line)

#line 90 "iscrweav.pak"
class raw_weaver:
  def __init__(self, writer ,**kwds):
    if verbosity>=3: print 'initialising raw weaver, writer',writer.get_sink_name()
    self.protocol = 'raw'
    self.tags = ['raw']
    self.sink = writer
    self.name = 'raw weaver v1 for '+self.sink.name


#line 112 "iscrweav.pak"
class multiplexor:
  def __init__(self,base):
    self.base=base
    self.name = 'multiplexor v1'
    self.debug_missing_methods = 0

  def __nonzero__(self):
    return 1

  def callit(self,*args, **kwds):
    for b in self.base:
      if hasattr(b,self.temp):
        try:
          apply(getattr(b,self.temp),args,kwds)
        except KeyboardInterrupt:
          raise KeyboardInterrupt
        except:
          protocol = 'No protocol attribute'
          name = 'No name attribute'
          if hasattr(b,'protocol'): protocol = b.protocol
          if hasattr(b,'name'): name = b.name
          print 'Error in call!'
          print '  Method',self.temp
          print '  Args  ',args
          print '  Kwds  ',kwds
          print '  of    ',b.protocol,'weaver',b.name,'ignored'
          traceback.print_exc()
      elif self.debug_missing_methods:
        protocol = 'No protocol attribute'
        sinkname = 'No sink attribute'
        if hasattr(b,'protocol'): protocol = b.protocol
        if hasattr(b,'sink'):
          sinkname = 'no sink name'
          sink = b.sink
          if hasattr(sink,'name'):
            sinkname = sink.name
        print 'Warning: missing method',self.temp,'of weaver type',protocol,'for',sinkname,'ignored'

  def __getattr__(self,x):
    self.temp = x
    return self.callit


#line 9 "iscrwtxt.pak"
class plain_text_weaver(weaver_base):
  def __init__(self, writer ,**kwds):
    weaver_base.__init__(self)
    if verbosity>=3: print 'initialising plain text weaver, writer',writer.get_sink_name()
    self.protocol = ('text/plain',1)
    self.width = 55
    self.c = 0
    self.buffer = ''
    self.strong = 0
    self.string = string
    self.code = 0
    self.sink = writer
    self.name = 'plain text weaver v1 for '+self.sink.name
    self.tags = ['text']
    self.margin = 0
    self.numbered_list_stack = []
    self.sop = 1

  def _write(self,line):
    if self.enabled:
      self.sink.write(line)
      self.c = self.c + len(line)

  def _writeline(self,line=''):
    if self.enabled:
      self._write(line+'\n')
      self.c = 0

#line 39 "iscrwtxt.pak"
  def writecode(self,line):
    self._flush()
    self._writeline(line)

  def echotangle(self,count,data):
    self.writecode("%6d: %s" % (count,data))

  def _write_word(self,word):
    if self.c == 0:
      self._write((' '*self.margin)+word)
    elif self.c + len(word) < self.width:
      self._write(' '+word)
    else:
      self._writeline()
      self._write((' '*self.margin)+word)
    self.sop = 0

  def _flush(self):
    words = self.string.split(self.buffer)
    for w in words:
      self._write_word(w)
    self.buffer = ''

  def write(self,line):
    if self.translating:
      if self.strong: line = string.upper(line)
      self.buffer = self.buffer + line
    else:
      self._write(line)

  def writeline(self,line = ''):
    if self.translating:
      self.write(line)
      if self.code:
        self._writeline(self.buffer)
        self.buffer = ''
      else:
        self._flush()
    else:
      self._writeline(line)

  def par(self):
    self._flush()
    if self.c != 0: self._writeline()
    if not self.sop:
      self._writeline()
      self.sop = 1

  def line_break(self):
    self._flush()
    if self.c != 0: self._writeline()

  def page_break(self):
    self._flush()
    if self.c != 0: self._writeline()
    self._writeline()
    self._writeline('-' * self.width)
    self._writeline()

  def begin_emphasize(self):
    self.write('_')

  def end_emphasize(self):
    self.write('_')

  def begin_strong(self):
    self.strong = 1

  def end_strong(self):
    self.strong = 0

  def begin_displayed_code(self):
    self.par()
    self.code = 1

  def end_displayed_code(self):
    self.par()
    self.code = 0

  def begin_displayed_text(self):
    self.par()
    self.margin = self.margin + 4

  def end_displayed_text(self):
    self.par()
    self.margin = self.margin - 4

  def head(self,level, text, atext='', anchor=''):
    self.par()
    self.strong = 0
    self.new_heading(level)
    h = self.get_formatted_heading_number()+'. '+text
    self._writeline(h)
    self._writeline('-'*len(h))
    self._writeline()

  def code_head(self,tangler):
    if tangler:
      self.par()
      self._writeline( 'Start section to '+tangler.sink.get_sink_name())
      self._writeline()

  def code_foot(self,tangler):
    if tangler:
      self.par()
      self._writeline( 'End section to '+tangler.sink.get_sink_name())

  def __del__(self):
    self._flush()
    if self.c != 0:
      self._writeline()

  def begin_keyed_list(self):
    self.margin = self.margin + 4

  def begin_numbered_list(self,start=1):
    self.margin = self.margin + 4
    self.numbered_list_stack.append(start)

  def begin_bullet_list(self):
    self.margin = self.margin + 4

  def end_keyed_list(self):
    self.margin = self.margin - 4

  def end_numbered_list(self):
    self.par()
    self.margin = self.margin - 4
    del self.numbered_list_stack[-1]

  def end_bullet_list(self):
    self.margin = self.margin - 4

  def begin_keyed_list_item(self,key):
    self._flush()
    self._write(' '*(self.margin-4) + key)

  def begin_numbered_list_item(self):
    self.par()
    key = "%2d. " % self.numbered_list_stack[-1]
    self.numbered_list_stack[-1] = self.numbered_list_stack[-1] + 1
    self._write(' '*(self.margin-4) + key)

  def begin_bullet_list_item(self):
    self.par()
    key = '*   '
    self._write(' '*(self.margin-4) + key)

#line 189 "iscrwtxt.pak"
  def cite_url(self,url):
    self.write(url)


#line 11 "iscrht.pak"
class html_weaver(weaver_base):
#line 14 "iscrht.pak"
  def __init__(self, writer ,**kwds):
    weaver_base.__init__(self)
    if verbosity>3: print 'initialising html weaver, writer',writer.get_sink_name()
    self.protocol = 'text/html'
    self.sink = writer
    self.acount = 1
    self.tag_stack = []
    self.mode = None
    self.comments = 0
    self.new_flist = g.flist
    self.g = g
    self.list = []
    self.name = 'html weaver v1 for '+self.sink.name
    self.heading_level_offset = 0
    self.keywords = kwds
    self.tags = ['html'] # this 'tags' has nothing to do with html tags!

    if 0:
      # load table of contents from previous run
      try:
        self.toc = open('contents.tmp','r').readlines()
      except:
        self.toc = []

      for i in range(0,len(self.toc)):
        if len(self.toc[i]):
          self.toc[i] = self.toc[i][:-1]

      # reopen table of contents for writing on this run
      self.contents = open('contents.tmp','w')

      # load file list from previous run
      try:
        self.old_flist= open('files.tmp','r').readlines()
      except:
        self.old_flist = []

    self.prolog()

#line 55 "iscrht.pak"
  def __del__(self):
    if 0:
      f = open('files.tmp','w')
      for fn in self.new_flist:
          f.write(fn+'\n')
      f.close()
    self.epilog()

#line 65 "iscrht.pak"
  def idxref(self):
    ids = self.g.ids
    keys = ids.keys()
    keys.sort()
    self.head(2,'Index of Identifiers')
    self._writeline('<TABLE COLS="2" BORDER="1" CELLPADDING="2">')
    for k in keys:
      refs = ids[k]
      self._write('<TR><TD VALIGN="Top"><CODE> '+k+' </CODE></TD><TD> ')
      old_df = ''
      for sf,sc,df,dc in refs:
        if old_df != '': self._write(', ')
        if old_df != df:
          self._write(df+': <A HREF=#'+sf+':'+str(sc)+'>'+str(dc)+'</A>')
          old_df = df
        else:
          self._write('<A HREF=#'+sf+':'+str(sc)+'>'+str(dc)+'</A>')
      self._write('</TD></TR>')
    self._writeline('</TABLE>')

  # create an HTML anchor
  def set_fc_anchor(self,file,count):
    self._write('<A NAME="'+file+':'+str(count)+'"></A>')

#line 91 "iscrht.pak"
  def print_contents(self):
    self.writeline('Temporarily disabled')
    if 0:
      self._write('<PRE>')
      for line in self.toc:
        self._writeline(line)
      self._write('</PRE>')

#line 101 "iscrht.pak"
  def print_file_list(self):
    self.head(2,'File List')
    self.writeline('Temporarily disabled')
    if 0:
      for line in self.old_flist:
        self._writeline(line)

#line 110 "iscrht.pak"
  def prolog(self):
    kwds = self.keywords
    self._writeline('<DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2//EN">')
    self._write( '<HTML>')
    self._write( '<HEAD>')

    if kwds.has_key('title'):
      title=kwds['title']
    else:
      title = 'Untitled Interscript document'

    self.write_tagged('TITLE', title)

    self._writeline( '<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">')
    if kwds.has_key('author'):
      author =kwds['author']
      self._writeline( '<META NAME="Author" CONTENT="'+author+'">')
    self._writeline( '<META NAME="Generator" CONTENT="Interscript">')
    self._write( '</HEAD>')
    self._write( '<BODY>')
    if kwds.has_key('pagehead'):
      self._write(kwds['pagehead'])
    if kwds.has_key('title'):
      self._write('<H1 ALIGN="CENTER">'+title+'</H1>')
    if kwds.has_key('heading_level_offset'):
      self.heading_level_offset = kwds['heading_level_offset']

  def epilog(self):
    kwds = self.keywords
    self._endmode()
    if kwds.has_key('pagefoot'):
      self._write(kwds['pagefoot'])
    self._write('</BODY>')
    self._write('</HTML>\n')

#line 147 "iscrht.pak"
  def _endmode(self):
    if self.mode:
      self._write('</'+self.mode+'>\n')
      self.mode = None

  def _startmode(self,mode):
    self._endmode()
    self._write('\n<'+mode+'>')
    self.mode = mode

  def _ensuremode(self,mode):
    if self.mode != mode : self._startmode(mode)

  def _writeline(self,line):
    if self.enabled: self.sink.writeline(line)

  def _write(self,line):
    if self.enabled: self.sink.write(line)

  def writeline(self,line=''):
    self.write(line + '\n')

  def write(self,line):
    if self.translating:
      self._ensuremode('P')
      l = ''
      for ch in line:
        try:
          l = l + {'<':'&lt;','>':'&gt;','&':'&amp;'}[ch]
        except:
          l = l + ch
      self._write(l)
    else:
      self._write(line)

  def writecode(self,line):
    self._ensuremode('PRE')
    l = ''
    for ch in line:
      try:
        l = l + {'<':'&lt;','>':'&gt;'}[ch]
      except:
        l = l + ch
    self._writeline(l)

  def begin_displayed_text(self):
    self._ensuremode('P')
    # note this is HTML 2, HTML 3 uses BQ instead
    self.write('<BLOCKQUOTE>')

  def end_displayed_text(self):
    self.write('</BLOCKQUOTE>')

  def begin_displayed_code(self):
    self._write('<PRE>\n')

  def end_displayed_code(self):
    self._write('</PRE>')

  def line_break(self):
    self._writeline('<BR>')

  def page_break(self):
    self.writeline('<BR><HR>')

  def write_tagged(self,tag, data):
    self._write('<'+tag+'>')
    self._writeline(data)
    self._write('</'+tag+'>')


  def code_head(self,tangler):
    if tangler:
      self._endmode()
      self._write( '<P><SMALL>Start section to '+tangler.sink.get_sink_name()+'</SMALL></P>')

  def code_foot(self,tangler):
    if tangler:
      self._endmode()
      self._write( '<P><SMALL>End section to '+tangler.sink.get_sink_name()+'</SMALL></P>')

#line 230 "iscrht.pak"
  def head(self,level, text, atext='', anchor=''):
    self._endmode()
    if anchor == '': anchor = atext
    if anchor == '':
      anchor = 'h'+str(self.acount)
      self.acount = self.acount + 1

    self.new_heading(level)
    aname = '<A NAME='+anchor+'></A>'
    ahref = '<A HREF=#'+anchor+'>'+text+'</A>'

    hnumber = self.get_formatted_heading_number()+'. '
    hprefix = ''
    if self.keywords.has_key('heading_prefix'):
      hprefix = self.keywords['heading_prefix']
    html_level = level + self.heading_level_offset
    if html_level > 6: html_level = 6
    self._writeline( '<H'+str(html_level)+'>'+aname+hprefix+hnumber+str(text)+'</H'+str(level)+'>')

    # this should be user configurable (in latex too!)
    if level <=2 :
      counter = self.hcount[level-1]
      # temporarily disabled
      if 0:
        self.contents.write('  '*level+str(counter)+'. '+ahref+'\n')

#line 259 "iscrht.pak"
  def begin_numbered_list(self,start=1, type='1'):
    self._endmode()
    self._write('<OL SEQNUM="'+str(start)+'" TYPE="'+type+'">')

  def end_numbered_list(self):
    self._write('</OL>')

  def begin_numbered_list_item(self):
    self._write('<LI>')

  def end_numbered_list_item(self):
    self._write('</LI>')

#line 274 "iscrht.pak"
  def begin_bullet_list(self):
    self._endmode()
    self._write('<UL>')

  def end_bullet_list(self):
    self._write('</UL>')

  def begin_bullet_list_item(self):
    self._write('<LI>')

  def end_bullet_list_item(self):
    self._write('</LI>')

#line 289 "iscrht.pak"
  def begin_keyed_list(self):
    self._endmode()
    self._write('<DL>')

  def end_keyed_list(self):
    self._write('</DL>')

  def begin_keyed_list_item(self,key):
    self._write('<DT><B>'+key+'</B></DT><DD>')

  def end_keyed_list_item(self):
    self._write('</DD>')

#line 304 "iscrht.pak"
  # default code line formatting
  def echotangle(self,count,data):
    if self.comments:
      self._writeline(data)
    else:
      self.writecode("%6d: %s" % (count,data))

#line 313 "iscrht.pak"
  def cite_url(self,url):
    self._write('<A HREF="'+url+'">'+url+'</A>')

#line 318 "iscrht.pak"
  def prose(self): # start of paragraph
    self._ensuremode('P')

  def par(self): # paragraph separator
    self._endmode()
    self._ensuremode('P')

  def eop(self): # end of paragraph
    self._endmode()

  def write_comment(self,v):
    saved_mode = self.mode
    self.write_tagged('SMALL',v)
    self._ensuremode(saved_mode)

#line 335 "iscrht.pak"
  def begin_code(self):
    self._write('<CODE>')

  def end_code(self):
    self._write('</CODE>')

  def begin_emphasize(self):
    self._write('<EM>')

  def end_emphasize(self):
    self._write('</EM>')

  def begin_strong(self):
    self._write('<STRONG>')

  def end_strong(self):
    self._write('</STRONG>')

  def begin_italic(self):
    self._write('<I>')

  def end_italic(self):
    self._write('</I>')

  def begin_bold(self):
    self._write('<B>')

  def end_bold(self):
    self._write('</B>')

  def begin_big(self):
    self._write('<BIG>')

  def end_big(self):
    self._write('</BIG>')

  def begin_small(self):
    self._write('<SMALL>')

  def end_small(self):
    self._write('</SMALL>')

#line 86 "iscrsht.pak"
class stacking_weaver(multiplexor):
  def __init__(self,parent_weaver, prefix, break_list, **kwds):
    self.debug_missing_methods = 0
    self.keywords = kwds
    self.toc_depth = lookup_dict(self.keywords,'toc_depth',99)
    self.base = [parent_weaver]
    self.break_list = [-1,0]
    for b in break_list: self.break_list.append(b)
    self.stack = [parent_weaver]
    self.prefix = prefix
    self.childcount = 0
    self.debug = 0
    self.protocol = 'stacking weaver'
    self.hcount = []
    self.acount = 0
    self.anchor_file = {}
    self.g = g
    self.name = 'stacking weaver'
    toc_filename = self.prefix+str(self.childcount)+'.html'
    sink = named_file_sink(toc_filename)
    self.toc_anchor = '<A HREF="'+toc_filename+'">Contents</A>'
    try:
      self.home_file = parent_weaver.sink.name
      self.home_anchor = '<A HREF="'+self.home_file+'">Home</A>'
      nav = '<DIV CLASS="NAVIGATION">'+self.home_anchor+'<BR><HR></DIV>'
      self.toc_weaver = html_weaver(sink,title = 'Table of Contents', pagehead = nav)
    except:
      self.home_file = 'Unknown'
      self.home_anchor = None
      self.toc_weaver = html_weaver(sink,title = 'Table of Contents')

  def new_heading(self,level):
    while level>len(self.hcount): self.hcount.append(0)
    while level<len(self.hcount): del self.hcount[-1]
    counter = self.hcount[level-1]+1
    self.hcount[level-1] = counter
    return counter

  def get_formatted_heading_number(self):
    hnumber = ''
    for i in range(0,len(self.hcount)-1):
      hnumber = hnumber + str(self.hcount[i])+'.'
    hnumber = hnumber + str(self.hcount[-1])
    return hnumber

  def _popw(self):
    if self.debug or verbosity>=6 :
      print 'Terminating weaver',self.stack[-1].name
    del self.stack[-1]
    self.base = [self.stack[-1]]

  def _pushw(self,level,text,atext,anchor):
    # fix mode here
    self.childcount = self.childcount + 1
    filename = self.prefix+str(self.childcount)+'.html'
    if self.debug: print 'Spawning Weaver',filename,'for',text
    self.base = [self.stack[-1]]
    hn = self.get_formatted_heading_number()+'.'
    h = hn + ' '+text
    self._ensuremode('P')
    self._writeline( '<BR><A HREF="'+filename+'">'+h+'</A>')

    if level <= self.toc_depth:
      tocline = '<BR>'+'&nbsp;'*(2*level)+'<A HREF="'+filename+'">'+h+'</A>'
      self.toc_weaver._writeline(tocline)

    # create navigation links (kludge!)
    home = self.home_anchor
    up = None
    try:
      up = self.base[0].sink.name
      up = '<A HREF="'+up+'">Up</A>'
    except: pass

    if self.childcount > 1:
      prev = self.prefix+str(self.childcount-1)+'.html'
      prev= '<A HREF="'+prev+'">Prev</A>'
    else: prev = None

    # cheat here, guess next exists :-)
    next = self.prefix+str(self.childcount+1)+'.html'
    next = '<A HREF="'+next+'">Next</A>'

    nav = ''
    if next : nav = nav + next+' '
    if up : nav = nav + up+' '
    if prev : nav = nav + prev+' '
    if home: nav = nav + home+' '
    nav = nav + self.toc_anchor

    hnav = '<DIV CLASS="NAVIGATION">'+nav+'<BR><HR></DIV>'
    fnav = '<DIV CLASS="NAVIGATION"><BR><HR>'+nav+'</DIV>'

    sink = named_file_sink(filename)
    child = html_weaver(sink,title = h, pagehead = hnav, pagefoot=fnav, heading_prefix=hn)
    self.base = [child]
    self.stack.append(child)

  def _trig(self,offset=0):
    return self.break_list[len(self.stack)+offset]

  def _ins_head(self,level,text,atext,anchor):
    adjusted_level = level - self._trig()
    if level <= self.toc_depth:
      if anchor == '':
        anchor = 'a'+str(self.acount)
        self.acount = self.acount + 1
      hn = self.get_formatted_heading_number()+'.'
      h = hn + ' '+text
      filename = self.base[0].sink.filename
      tocline = '<BR>'+'&nbsp;'*(2*level)+'<A HREF="'+filename+'#'+anchor+'">'+h+'</A>'
      self.toc_weaver._writeline(tocline)
    for weaver in self.base:
      weaver.head(adjusted_level,text,atext,anchor)

#line 203 "iscrsht.pak"
  def head(self,level, text, atext='', anchor=''):
    self.new_heading(level)

    # pop
    while not self._trig(0) < level: self._popw()

    # push
    while not level < self._trig(1): self._pushw(level,text,atext,anchor)
    assert self._trig(0) <= level < self._trig(1)

    # interior heading
    if self._trig(0) < level: self._ins_head(level,text,atext,anchor)

#line 264 "iscrsht.pak"
  def set_fc_anchor(self,file,count):
    self.anchor_file[(file,count)]=self.base[0].sink.filename
    for weaver in self.base:
      weaver.set_fc_anchor(file,count)

  def idxref(self):
    ids = self.g.ids
    keys = ids.keys()
    keys.sort()
    self.head(2,'Index of Identifiers')
    self._writeline('<TABLE COLS="2" BORDER="1" CELLPADDING="2">')
    for k in keys:
      refs = ids[k]
      self._write('<TR><TD VALIGN="Top"><CODE> '+k+' </CODE></TD><TD> ')
      old_df = ''
      for sf,sc,df,dc in refs:
        key = (sf, sc)
        if self.anchor_file.has_key(key):
          child = self.anchor_file[key]
        else:
          child = ''
        anchor = '<A HREF='+child+'#'+sf+':'+str(sc)+'>'+str(dc)+'</A>'

        if old_df != '': self._write(', ')
        if old_df != df:
          self._write(df+': '+ anchor )
          old_df = df
        else:
          self._write(anchor)
      self._write('</TD></TR>')
    self._writeline('</TABLE>')

#line 6 "iscrla.pak"

class latex_weaver(weaver_base):
#line 10 "iscrla.pak"
  def __init__(self, writer ,**kwds):
    weaver_base.__init__(self)
    self.sink = writer
    if verbosity>=3: print 'initialising latex weaver, writer',writer.get_sink_name()
    self.protocol = ('LaTeX2e')
    self.acount = 1
    self.tag_stack = []
    self.comments = 0
    self.new_flist = g.flist
    self.g = g
    self.list = []
    self.heading_level_offset = 0
    self.name = 'latex2e weaver v1 for '+self.sink.name

    # load file list from previous run
    try:
      self.old_flist= open('files.tmp','r').readlines()
    except:
      self.old_flist = []

    self.prolog(kwds)

#line 34 "iscrla.pak"
  def __del__(self):
    f = open('files.tmp','w')
    for fn in self.new_flist:
        f.write(fn+'\n')
    f.close()
    self.epilog()

#line 43 "iscrla.pak"
  def idxref(self):
    ids = self.g.ids
    keys = ids.keys()
    keys.sort()
    self.head(2,'Index of Identifiers')
    self._writeline('\\begin{tabular}{ll}')
    for k in keys:
      refs = ids[k]
      self._write('\\verb+'+k+'+&')
      old_df = ''
      for sf,sc,df,dc in refs:
        if old_df != '': self._write(', ')
        if old_df != df:
          self._write(df+': '+str(dc)+'\\ref{'+sf+':'+str(sc)+'}')
          old_df = df
        else:
          self._write(': '+str(dc)+'\\ref{'+sf+':'+str(sc)+'}')
      self._write('\\\\\n')
    self._writeline('\\end{tabular}\n')

  # create a Latex anchor
  def set_fc_anchor(self,file,count):
    self._write('\\label{'+file+':'+str(count)+'}')

#line 69 "iscrla.pak"
  def print_contents(self):
    self._writeline('\\tableofcontents')

#line 74 "iscrla.pak"
  def print_file_list(self):
    self.head(2,'File List')
    for line in self.old_flist:
      self._writeline(line)

#line 86 "iscrla.pak"
  def prolog(self,kwds):

    # see Kopka pp25-27
    # the default document class is for a book
    # other standard classes include:
    #   article report letter

    documentclass = 'book'
    if kwds.has_key('documentclass'):
      documentclass=kwds['documentclass']

    # the options are a python list of words
    # for the standard book class they're from the set:
    #   10pt 11pt 12pt
    #   letterpaper legalpaper executivepaper
    #   a4paper a5paper b5paper
    #   landscape
    #   onecolumn twocolumn
    #   oneside twoside
    #   openright openany
    #   notitlepage titlepage

    # note: the default paper size Latex uses is
    # american letterpaper. Don't count on this,
    # I intend to make the ISO Standard A4 that everyone
    # else uses the default!

    docopts = []
    if kwds.has_key('documentclass_options'):
      docopts =kwds['documentclass']
    docoptstr=''
    if docopts: docoptstr = docopts[0]
    for opt in range(1,len(docopts)):
     docoptstr = dosoptstr + ', ' + opt
    self._writeline('\\documentclass['+docoptstr+']{'+documentclass+'}')

    if kwds.has_key('heading_level_offset'):
      self.heading_level_offset = kwds['heading_level_offset']

    # page heading control
    pagestyle = 'headings'
    if kwds.has_key('pagestyle'):
      pagestyle=kwds['pagestyle']
    self._writeline('\\pagestyle{'+pagestyle+'}')

    pagenumbering= 'arabic'
    if kwds.has_key('pagenumbering'):
      pagenumbering=kwds['pagenumbering']
    self._writeline('\\pagenumbering{'+pagenumbering+'}')

    # page layout
    page_format_params = [
      'topmargin','headheight','headsep','topskip','textheight','footskip',
      'oddsidemargin','evensidemargin',
      'textwidth']
    for p in page_format_params:
      if kwds.has_key(p):
        param=kwds[p]
        self._writeline('\\setlength{\\'+p+'}{'+param+'}')

    # lines and paragraphs

    # Note: we do _not_ permit indented paragraphs AT ALL.
    # Don't even try it. FAR FAR too many things are broken
    # by indentation.

    baselinestretch= 1
    if kwds.has_key('baselinestretch'):
      baselinestretch=kwds['baselinestretch']
    self._writeline('\\renewcommand{\\baselinestretch}{'+str(baselinestretch)+'}')

    self._writeline('\\setlength{\\parskip 2mm plus 0.5mm minus 1mm}')
    self._writeline('\\setlength{\\parindent 0mm}')

    self._writeline( '\\begin{document}')
    if kwds.has_key('title'):
      title=kwds['title']
      self._writeline('\\title{'+title+'}')

    if kwds.has_key('author'):
      author =kwds['author']
      self._writeline('\\author{'+author+'}')

    self._writeline( '\\maketitle')

  def epilog(self):
    self._writeline('\\end{document}')

#line 176 "iscrla.pak"
  def _writeline(self,line=''):
    if self.enabled: self.sink.writeline(line)

  def _write(self,line):
    if self.enabled: self.sink.write(line)

  def write(self,line):
    if self.translating:
      line = string.rstrip(line)
      if line == '': return # don't print any blank lines
      # this is ssssslowwwwww!!
      l = ''
      for i in range(0,len(line)):
        ch = line[i]
        if ch in '$&%#_^{}': l = l + '\\'
        l = l + ch
      self._write(l)
    else:
      self._write(line)

  def writeline(self,line=''):
    self.write(line);
    self._writeline()

  def writecode(self,line):
    d = ''
    for c in '@%!`~^$?':
      if c not in line:
        d = c
        break
    if d == '':
      print 'UNFORMATTABLE CODE: Fix weaver to cope!'
      self._writeline('\\verb@Unformattable line@\\\\')
    else:
      self._writeline('\\hbox to 0pt{\\verb'+d+line+d+'\\hss}\\\\')

  def begin_displayed_text(self):
    self._write('\\begin{quote}\n')

  def end_displayed_text(self):
    self._write('\\end{quote}\n')


  def begin_displayed_code(self):
    self._writeline('\\begin{verbatim}')

  def end_displayed_code(self):
    self._writeline('\\end{verbatim}')

  def line_break(self):
    self._writeline('\\newline')

  def page_break(self):
    self._writeline('\\newpage')

  def write_tagged(self,tag, data):
    self._write('{\\'+tag)
    self._write(data)
    self._write('}')


  def code_head(self,tangler):
    if tangler:
      self._write( '{\\par\\noindent\\small Start section to '+tangler.sink.get_sink_name()+'}\\\\')

  def code_foot(self,tangler):
    if tangler:
      self._write( '{\\small End section to '+tangler.sink.get_sink_name()+'}')

#line 247 "iscrla.pak"
  def head(self,level, text, atext='', anchor=''):
    cmds = {
      1:'\\part',
      2:'\\chapter',
      3:'\\section',
      4:'\\subsection',
      5:'\\subsubsection',
      6:'\\paragraph',
      7:'\\subparagraph'}
    cmd = cmds[level+self.heading_level_offset]
    if anchor == '': anchor = atext
    if anchor == '':
      anchor = 'h'+str(self.acount)
      self.acount = self.acount + 1

    if atext:
      self._writeline(cmd+'['+atext+']{'+text+'}\\label{'+anchor+'}')
    else:
      self._writeline(cmd+'{'+text+'}\\label{'+anchor+'}')
    self.new_heading(level)

#line 271 "iscrla.pak"
  def begin_numbered_list(self,start=1, type='1'):
    self._writeline('\\begin{enumerate}')

  def end_numbered_list(self):
    self._writeline('\\end{enumerate}')

  def begin_numbered_list_item(self):
    self._writeline('\\item ')

  def end_numbered_list_item(self):
    pass

#line 285 "iscrla.pak"
  def begin_bullet_list(self):
    self._writeline('\\begin{itemize}')

  def end_bullet_list(self):
    self._writeline('\\end{itemize}')

  def begin_bullet_list_item(self):
    self._write('\\item ')

  def end_bullet_list_item(self):
    pass

#line 299 "iscrla.pak"
  def begin_keyed_list(self):
    self._writeline('\\begin{description}')

  def end_keyed_list(self):
    self._writeline('\\end{description}')

  def begin_keyed_list_item(self,key):
    self._write('\\item[')
    self.write(key)
    self._write(']')

  def end_keyed_list_item(self):
    pass

#line 315 "iscrla.pak"
  # default code line formatting
  def echotangle(self,count,data):
    if self.comments:
      self._writeline(data)
    else:
      self.writecode("%6d: %s" % (count,data))

#line 324 "iscrla.pak"
  def prose(self): # start of paragraph
    self._write('\\noindent ')

  def par(self): # paragraph separator
    self._write('\\par\n\\noindent ')

  def eop(self): # end of paragraph
    self._write('\\par\n')

  def write_comment(self,v):
    self.write_tagged('small',v)

#line 338 "iscrla.pak"
  def begin_code(self):
    self._write('{\\tt ')

  def end_code(self):
    self._write('}')

  def begin_emphasize(self):
    self._write('{\\em ')

  def end_emphasize(self):
    self._write('}')

  def begin_strong(self):
    self._write('{\\bfseries ')

  def end_strong(self):
    self._write('}')

  def begin_italic(self):
    self._write('{\\itshape ')

  def end_italic(self):
    self._write('}')

  def begin_bold(self):
    self._write('{\\bfseries ')

  def end_bold(self):
    self._write('}')

  def begin_big(self):
    self._write('{\\big ')

  def end_big(self):
    self._write('}')

  def begin_small(self):
    self._write('{\\small')

  def end_small(self):
    self._write('}')

#line 382 "iscrla.pak"
  def cite_url(self,url):
    self._write('{\bfseries ')
    self.write(url)
    self._write('}')
#line 16 "iscrwflt.pak"
class markup_filter(multiplexor):
  def __init__(self,regexp,startmethod,endmethod,base=[]):
    multiplexor.__init__(self,base)
    self.regexp = re.compile(regexp)
    self.startmethod = startmethod
    self.endmethod = endmethod
    self.protocol = ('regexp filter',regexp)
    self.name = 'markup filter v1'
    self.translating = 1

  def translate(self):
    self.translating = 1
    for weaver in base: weaver.translate()

  def raw(self):
    self.translating = 0
    for weaver in base: weaver.raw()

  def rawif(self, tag):
    self.translating = 0
    for weaver in base: weaver.rawif(tag)

  def write(self,data):
     if not self.enabled: return
     if not self.translating:
       for weaver in self.base:
         weaver.write(data)
     else:
       match = self.regexp.search(data)
       startpos = 0
       while match:
         midpos = match.start(0)
         endpos = match.end(0)
         if midpos == endpos:
           raise 'nullable regexp '+self.regexp.pattern
         if startpos != midpos:
           for weaver in self.base:
             weaver.write(data[startpos:midpos])
         for weaver in self.base:
           exec 'weaver.'+self.startmethod+'()'
           weaver.write(match.group(1))
           exec 'weaver.'+self.endmethod+'()'
         startpos = endpos
         match = self.regexp.search(data,startpos)
       if startpos != len(data):
         for weaver in self.base:
           weaver.write(data[startpos:])

  def writeline(self,data=''):
    if not self.enabled: return
    if data != '': self.write(data)
    for weaver in self.base:
      weaver.writeline()

#line 85 "iscrwflt.pak"
def chain_filters(filters):
  for i in range(0,len(filters)-1):
    filters[i].base = [filters[i+1]]

def create_filters(triples):
  filters = []
  for regexp,startmethod,endmethod in triples:
    filters.append(markup_filter(regexp,startmethod,endmethod))
  return filters

def create_filter_chain(triples):
  return chain_filters(create_filters(triples))

#line 85 "iscrtan.pak"
#---------------------------------------------------------
# tangler base
#---------------------------------------------------------
class tangler_base:
  def __init__(self,sink,weaver):
    self.sink = sink
    self.weaver = weaver
    self.inhibit_sref = 0

  def write_comment(self,line):
    pass

  def _writeline(self,data):
    self.sink.writeline(data)

  def _write_and_echo(self,data):
    self._writeline(data)
    if self.weaver:
      self.weaver.echotangle(self.sink.lines_written,data)

  def writeline(self,data,file,count, inhibit_sref=0):
    if not inhibit_sref and not self.inhibit_sref:
      if (file != self.sink.last_source_file or
        count != self.sink.last_source_count+1):
        self.start_section(file,count)
    self.sink.last_source_file = file
    self.sink.last_source_count = count
    self._write_and_echo(data)

  def start_section(self,file,count): pass

#---------------------------------------------------------
# builtin tanglers: null, data, C, script
#---------------------------------------------------------

#line 126 "iscrtan.pak"
#---------------------------------------------------------
# null tangler
# NOTE: a null tangler is _not_ the same as
# some other tangler with a null sink:
# null tanglers do _not_ write to the weaver!
# Use a null tangler to remove files from the
# source _and_ documentation

class null_tangler(tangler_base):
  def __init__(self,weaver=None):
    tangler_base.__init__(self,null_sink(),weaver)

  def get_comment_tangler(self):
    return self

  def writeline(self,data,file,count,inhibit_sref=0):
    pass

#line 149 "iscrtan.pak"
#---------------------------------------------------------
# document tangler: writes text as doco,
# doesn't generate a file. Not the same as 'no' tangler

class document_tangler(tangler_base):
  def __init__(self,weaver):
    tangler_base.__init__(self,null_sink(),weaver)

  def get_comment_tangler(self):
    return self

  def writeline(self,data,file,count,inhibit_sref=0):
    self.weaver.writeline(data,file,count)

#line 168 "iscrtan.pak"
#--------------------------------------------------
# data tangler: write to a file
# can not emit source line cross references

class data_tangler(tangler_base):
  pass

#line 194 "iscrtan.pak"
#---------------------------------------------------------
# C tangler: write to a file, insert source line numbers
# using '#line' pre-processor directives

class C_tangler(tangler_base):
  def __init__(self,sink,weaver):
    tangler_base.__init__(self,sink,weaver)
    self.matchid = re.compile('^[^A-Za-z_]*([A-Za-z_][A-Za-z_0-9]*)(.*)$')
    self.g = g

  def write_comment(self,line,file,count):
    self.writeline('/* '+line+'*/')

  def start_section(self, file, count):
    data = '#line '+str(count)+' '+'"'+file+'"'
    self._writeline(data)
    if self.weaver:
      self.weaver.echotangle(self.sink.lines_written,data)

  def get_comment_tangler(self):
    return C_comment_tangler(self.sink)

  def get_string_tangler(self,eol='\\n',width=0):
    return C_string_tangler(self.sink,self.weaver,eol,width)

  def writeline(self,data,file,count,inhibit_sref=0):
    tangler_base.writeline(self,data,file,count,inhibit_sref)

#line 224 "iscrtan.pak"
#---------------------------------------------------------
class C_comment_tangler(tangler_base):
  def __init__(self,sink,weaver):
    tangler_base.__init__(self,sink,weaver)

  def writeline(self,data,file,count,inhibit_sref=0):
    if self.count == 0:
      self._writeline('/* '+data)
    else:
      self._writeline(' * '+data)
    self.weaver.writeline(data)

  def __del__(self):
    self._writeline(' */')

#line 241 "iscrtan.pak"
#---------------------------------------------------------
class C_string_tangler(tangler_base):
  def __init__(self,sink,weaver,eol,width):
    print 'Initialising C string tangler, eol=',eol,'width=',width
    tangler_base.__init__(self,sink,weaver)
    self.eol=eol
    self.width=width

  def writeline(self,data,file,count,inhibit_sref=0):
    data = string.rstrip(data) # remove trailing spaces
    if self.width > 0: data = string.ljust(data, self.width)
    line = '"'
    for ch in data:
      if ch in '\\"': line = line + '\\' + ch
      else: line = line + ch
    line = line + self.eol + '"'
    self._writeline(line)
    self.weaver.writeline(data)

#line 265 "iscrtan.pak"
#---------------------------------------------------------
# C++ tangler: write to a file, insert source line numbers
# using '#line' pre-processor directives

class CPP_tangler(tangler_base):
  def __init__(self,sink,weaver):
    tangler_base.__init__(self,sink,weaver)
    self.matchid = re.compile('^[^A-Za-z_]*([A-Za-z_][A-Za-z_0-9]*)(.*)$')
    self.g = g

  def writeline(self,data,file,count,inhibit_sref=0):
    tangler_base.writeline(self,data,file,count,inhibit_sref)

  def write_comment(self,line):
    self._writeline('// '+line)

  def start_section(self, file, count):
    data = '#line '+str(count)+' '+'"'+file+'"'
    self._writeline(data)
    if self.weaver:
      self.weaver.echotangle(self.sink.lines_written,data)

  def get_comment_tangler(self):
    return CPP_comment_tangler(self.sink, weaver)

  def get_string_tangler(self,eol,width):
    return C_string_tangler(self.sink,self.weaver,eol,width)


#line 296 "iscrtan.pak"
class hash_comment_tangler(tangler_base):
  def __init__(self, writer, weaver, prefix):
    tangler_base.__init__(self,writer, weaver)
    self.prefix = prefix

  def writeline(self,data,file,count,inhibit_sref=0):
    self.weaver.writeline(data)
    self._writeline(self.prefix+line)

#line 307 "iscrtan.pak"
class CPP_comment_tangler(hash_comment_tangler):
  def __init__(self, writer,weaver):
    hash_comment_tangler.__init__(self,writer,weaver,'// ')

#line 316 "iscrtan.pak"

class Java_tangler(tangler_base):
  def __init__(self,sink,weaver):
    tangler_base.__init__(self,sink,weaver)
    self.matchid = re.compile('^[^A-Za-z_]*([A-Za-z_][A-Za-z_0-9]*)(.*)$')
    self.g = g

  def writeline(self,data,file,count,inhibit_sref=0):
    tangler_base.writeline(self,data,file,count,inhibit_sref)

  def write_comment(self,line):
    self._writeline('// '+line)

  def start_section(self, file, count):
    data = '//#line '+str(count)+' '+'"'+file+'"'
    self._writeline(data)
    if self.weaver:
      self.weaver.echotangle(self.sink.lines_written,data)

  def get_comment_tangler(self):
    return CPP_comment_tangler(self.sink)

  def get_string_tangler(self,eol,width):
    return C_string_tangler(self.sink,self.weaver,eol,width)

#line 343 "iscrtan.pak"

class Tcl_tangler(tangler_base):
  def __init__(self,sink,weaver):
    tangler_base.__init__(self,sink,weaver)
    self.g = g

  def writeline(self,data,file,count,inhibit_sref=0):
    tangler_base.writeline(self,data,file,count,inhibit_sref)

  def write_comment(self,line):
    self._writeline('# '+line)

  def start_section(self, file, count):
    data = 'line '+str(count)+' '+'"'+file+'"'
    self._writeline(data)
    if self.weaver:
      self.weaver.echotangle(self.sink.lines_written,data)

  def get_comment_tangler(self):
    return hash_comment_tangler(self.sink,weaver, '# ')

  def get_string_tangler(self,eol,width=0):
    # This is _wrong_ and needs to be fixed!
    return C_string_tangler(self.sink,self.weaver,eol,width)


#line 12 "iscrtpy.pak"
#---------------------------------------------------------
# python tangler: write to a file, insert source line numbers
# using '#line ' comments
# works for Python

class python_tangler(tangler_base):
  def __init__(self,sink,weaver):
    tangler_base.__init__(self,sink,weaver)
    self.matchPOD = re.compile('^ *#@(.*)$')
    self.matchcomment = re.compile('^([^#]*)#.*$')
    self.excludeid = []
    self.userdict = {}
    self.g = g
    if self.g.tokenise_available:
      self.tokeniser = tokenise.python_tokeniser()

  def __del__(self):
    if self.g.tokenise_available:
      tokens = self.tokeniser.close()
    #print 'trailing tokens',tokens

  def writeline(self,data,file,count,inhibit_sref=0):
    match = self.matchPOD.match(data)
    if match:
      command = match.group(1)
      py_exec(command,file,count,globals(),self.userdict)
    else:
      self.weaver.set_fc_anchor(file,count)
      # special hack to preserve leading #! line
      if self.sink.lines_written == 0 and len(data)>2:
        inhibit_sref = data[:2]=='#!'
      tangler_base.writeline(self,data,file,count, inhibit_sref)

      if g.tokenise_available:
        tokens = self.tokeniser.tokenize(data)
        #print 'Tokenising:',data
        #print 'Yields:',
        #for kind,lexeme,lstart,lend,dummy in tokens: print lexeme,
        #print

        dst_file = self.sink.name
        dst_count = self.sink.lines_written
        for kind,id,lstart,lend,dummy in tokens:
          if kind is token.NAME:
            if not keyword.iskeyword(id) or id in self.excludeid:
              if not self.g.ids.has_key(id): self.g.ids[id]=[]
              self.g.ids[id].append((file,count,dst_file,dst_count))

  def write_comment(self,line,file,count):
    self.writeline('# '+line,file,count)

  def start_section(self, file, count):
    data = '#line '+str(count)+' '+'"'+file+'"'
    self._writeline(data)
    if self.weaver:
      self.weaver.echotangle(self.sink.lines_written,data)

  def get_comment_tangler(self):
    return script_comment_tangler(self.sink)

  def get_string_tangler(self,eol,width):
    return C_string_tangler(self.sink,self.get_weaver(),eol,width)

#line 77 "iscrtpy.pak"
class script_comment_tangler(tangler_base):
  def writeline(self,data,file,count,inhibit_sref=0):
    if self.weaver:
      self.weaver.writeline(data)
    self._writeline('# '+line)

#line 21 "iscrtpl.pak"
class perl_tangler(tangler_base):
  def __init__(self,sink,weaver, heading_level_offset = 2):
    tangler_base.__init__(self,sink,weaver)
    self.g = g
    self.mode = 'code'
    self.list_type = []
    self.pod_re = re.compile('^=([A-Za-z][A-Za-z0-9_]*) *(.*)$')
    self.heading_level_offset = heading_level_offset
    self.esc_re = re.compile('^(.*?)(>|[IBSCLFXZE]<)(.*)$')
    self.digits_re = re.compile('^([0-9]+)>(.*)$')
    self.entity_re = re.compile('^([A-Za-z]+)>(.*)$')
    # this is not a full list, we should in fact call a weaver routine.
    self.html_entity = {
      'amp':'&',
      'lt':'<',
      'gt':'>',
      'quot':'"',
      'copy':'C',
      'trade':'T',
      'reg':'R'}

  def __del__(self):
    self.flow_escape()
    self.end_lists()

  def flow_escape(self):
    line = self.flow_text
    if not line: return
    self.flow_text = ''
    # process balanced text,
    # if there is an unbalanced >, the text after it is returned
    # write a >, and then try again.
    tail = self.flow_parse(line)
    while tail:
      if verbosity >=4: print 'Unbalanced > in perl POD text'
      self.weaver.write('>')
      tail = self.flow_parse(tail)

  # recursive descent parser
  def flow_parse(self,tail):
    if not tail: return ''
    weaver = self.weaver

    match = self.esc_re.match(tail)
    while match:
      pre, cmd, tail = match.group(1,2,3)
      if pre: weaver.write(pre)
      if cmd=='>': return tail

      assert len(cmd)==2 and cmd[1]=='<'
      cmd = cmd[0]
      if cmd == 'I':
        weaver.begin_italic()
        tail = self.flow_parse(tail)
        weaver.end_italic()
      elif cmd == 'B':
        weaver.begin_bold()
        tail = self.flow_parse(tail)
        weaver.end_bold()
      elif cmd == 'S':
        # should be non-breaking spaces, but interscript
        # doesn't implement that
        tail = self.flow_parse(tail)
      elif cmd == 'C':
        weaver.begin_code()
        tail = self.flow_parse(tail)
        weaver.end_code()
      elif cmd == 'L':
        # a link: we just hack it for now
        weaver.write('[')
        tail = self.flow_parse(tail)
        weaver.write(']')
      elif cmd == 'F':
        # filename
        weaver.begin_code()
        tail = self.flow_parse(tail)
        weaver.end_code()
      elif cmd == 'X':
        # index entry??  (Does this mean print it, or index it?)
        # I'll just print it as code :-)
        weaver.begin_code()
        tail = self.flow_parse(tail)
        weaver.end_code()
      elif cmd == 'Z':
        # zero width character? What's that mean?
        tail = self.flow_parse(tail)
      elif cmd == 'E':
        match = self.digits_re.match(tail)
        if match:
          digits, tail = match.group(1,2)
          n = chr(int(digits))
          weaver.write(n)
        else:
          match = self.entity_re.match(tail)
          if match:
            entity, tail = match.group(1,2)
            data = lookup_dict(self.html_entity,entity,'E<'+entity+'>')
            weaver.write(data)
          else:
            # nothing we recognize, print literally
            weaver.write('E<')
            tail = self.flow_parse(tail)
            weaver.write('>')

      match = self.esc_re.match(tail)

    # no (more) matches, so just weave the tail
    self.weaver.writeline(tail)
    return ''


  def end_list_item(self):
    kind = self.list_type[-1]
    weaver = self.weaver
    if kind == 'keyed': weaver.end_keyed_list_item()
    elif kind == 'bullet': weaver.end_bullet_list_item()
    elif kind == 'numbered': weaver.end_numbered_list_item()

  def end_list(self):
    kind = self.list_type[-1]
    weaver = self.weaver
    if kind == 'keyed': weaver.end_keyed_list()
    elif kind == 'bullet': weaver.end_bullet_list()
    elif kind == 'numbered': weaver.end_numbered_list()
    del self.list_type[-1]

  def end_lists(self):
    while self.list_type: self.end_list()

  def begin_list(self,kind):
    # print '** list type:',kind
    self.list_type.append(kind)
    weaver = self.weaver
    if kind == 'keyed': weaver.begin_keyed_list()
    elif kind == 'bullet': weaver.begin_bullet_list()
    elif kind == 'numbered': weaver.begin_numbered_list()

  def begin_list_item(self,key=None):
    kind = self.list_type[-1]
    weaver = self.weaver
    if kind == 'keyed': weaver.begin_keyed_list_item(key)
    elif kind == 'bullet': weaver.begin_bullet_list_item()
    elif kind == 'numbered': weaver.begin_numbered_list_item()

  def writeline(self,data,file,count,inhibit_sref=0):
    if not inhibit_sref and not self.inhibit_sref:
      if (file != self.sink.last_source_file or
        count != self.sink.last_source_count+1):
        self.start_section(file,count)
    self.sink.last_source_file = file
    self.sink.last_source_count = count
    tangler_base._writeline(self,data)

    # try to find a pod command
    pod = self.pod_re.match(data)

    # if we're in code mode, and we didn't
    # get a pod command, just echotangle as code
    # otherwise, switch to pod mode

    if self.mode == 'code':
      if pod: self.mode = 'pod'
      else:
        self.weaver.echotangle(self.sink.lines_written,data)
        return

    # now we're in pod mode, if we didn't get a pod command,
    # strip the line to see if it's blank.
    # if not, weave it and switching pod end of para detection on
    # otherwise, emit an end of paragraph if detection is on
    # unless we're in litpar mode, in which case we have to
    # emulate an 'end' cmd
    # pod_par means: 0 - begin of para, 1 - flowing text, 2 - literal text
    assert self.mode == 'pod'
    if not pod:
      line = string.rstrip(data)
      if line:
        if not self.pod_par:
          self.pod_par = (line[0] in ' \t')+1
          if self.pod_par == 1: self.flow_text = ''
        if self.pod_par-1:
          self.weaver.writecode(line)
        else:
          # we have to search for escapes here!
          self.flow_text = self.flow_text + line + ' '
      elif self.pod_par:
        self.flow_escape()
        self.weaver.par()
        self.pod_par = 0 # beginning of paragraph
      return

    # we've got a pod command, so turn para detection off
    assert pod
    self.pod_par = 0
    cmd = pod.group(1)

    # if we're cuttiung back to code, terminate lists and list
    # items correctly if nececcary and switch back to code mode

    if cmd == 'cut':
      self.end_lists()
      if hasattr(self,'pod_mode'):
        if self.pod_mode in ['lit','litpar']:
          self.weaver.enable() # disable rawmode
          self.weaver.translate() # disable rawmode
        del self.pod_mode
      self.mode = 'code'
      return

    # Otherwise, just process the command

    if cmd == 'head1':
      self.end_lists()
      self.weaver.head(1+self.heading_level_offset, pod.group(2))

    elif cmd == 'head2':
      self.end_lists()
      self.weaver.head(2+self.heading_level_offset, pod.group(2))

    elif cmd == 'over':
      # list of unknown type pending, wait for =item
      self.pod_mode = 'list'

    elif cmd == 'back':
      self.end_list_item()
      self.end_list()

    elif cmd == 'item':
      if not hasattr(self,'pod_mode'):
        if verbosity >=2: print 'POD: item before over'
        self.pod_mode = 'list'
      key = pod.group(2)
      key = string.strip(key)
      if self.pod_mode == 'item':
        self.end_list_item()
      else:
        self.pod_mode = 'item'
        list_type = 'keyed'
        if len(key)==1:
          if key in '*+.-':
            list_type = 'bullet'
        self.begin_list(list_type)
      if self.list_type[-1] == 'keyed':
        # interscript doesn't support formatting of any kind
        # in keyed list keys (because LaTeX doesn't)
        # we need another kind of list (LaTeX can be given one)
        # For now, we remove any X<...> stuff
        stripkey = ''
        tail = key
        match = self.esc_re.match(tail)
        while match:
          pre, cmd, tail = match.group(1,2,3)
          stripkey = stripkey + pre
          match = self.esc_re.match(tail)
        if tail: stripkey = stripkey + tail
        key = stripkey

      self.begin_list_item(key)

    elif cmd == 'for':
      self.weaver.rawif(pod.group(2))
      self.pod_mode = 'litpar'
    elif cmd == 'begin':
      self.weaver.rawif(pod.group(2))
      self.pod_mode = 'lit'
    elif cmd == 'end':
      self.weaver.enable()
      self.weaver.translate()
      self.weaver.pod_mode = ''

  def write_comment(self,line):
    self._writeline('# '+line)

  def start_section(self, file, count):
    data = '#line '+str(count)+' '+'"'+file+'"'
    self._writeline(data)
    self.weaver.echotangle(self.sink.lines_written,data)

  def get_comment_tangler(self):
    return hash_comment_tangler(self.sink,weaver, '# ')

  def get_string_tangler(self,eol,width):
    # This is _wrong_ and needs to be fixed!
    return C_string_tangler(self.sink,self.get_weaver(),eol,width)


#line 38 "iscrpht.pak"
class sgml_wrapper:
  def __init__(self, sgml):
    self.sgml = sgml

  def writeline(self,data,file,count):
    self.sgml.feed(data)

  def close():
    self.sgml.close(self)

  def reset(self):
    self.sgml.reset()

# this is a hack: sgmllib needs to be imported here
# so the class SGMLParser defined in it can be used as a base
import sgmllib

class html_filter(sgmllib.SGMLParser):
  def __init__(self):
    sgmllib.SGMLParser.__init__(self)
    self.save_data = 0
    self.script_language = ''

    # feeding <HTML> in here is a hack to get around a bug in sgmllib,
    # which fails to process unbalanced end tags correctly
    self.feed('<HTML>')

  def _save(self):
    self.save_data = 1
    self.saved_data = ''
  def _saved(self):
    self.save_data = 0
    return self.saved_data

  def handle_data(self,data):
    if self.save_data:
      self.saved_data = self.saved_data + data
    else:
      weave(data)

  def handle_comment(self,data):
    if verbosity>=5: print 'SGML comment',data
    if self.script_language != '':
      self.saved_comments = self.saved_comments + data

  def start_html(self, attributes):
    print 'START HTML'
  def start_head(self, attributes): pass
  def end_head(self): pass
  def start_body(self, attributes): pass
  def end_body(self): pass
  def end_html(self):
    print 'END HTML'
    raise eoi

# fonts
  def start_b(self,attributes): begin_bold()
  def end_b(self): end_bold()

  def start_i(self,attributes): begin_italic()
  def end_i(self): end_italic()

  def start_em(self,attributes): begin_emphasize()
  def end_em(self): end_emphasize()

  def start_strong(self,attributes): begin_strong()
  def end_strong(self): end_strong()

  def start_small(self,attributes): begin_small()
  def end_small(self): end_small()

  def start_big(self,attributes): begin_small()
  def end_big(self): end_big()

# displays
  def start_pre(self,attributes): begin_displayed_code()
  def end_pre(self): end_displayed_code()

#lists
  def start_ol(self,attributes):
    begin_numbered_list()
    self.list_kind = 'ol'
  def end_ol(self):
    end_numbered_list()

  def start_dl(self,attributes):
    begin_keyed_list()
    self.list_kind = 'dl'
  def end_dl(self):
    end_keyed_list()

  def start_ul(self,attributes):
    begin_bullet_list()
    self.list_kind = 'ul'
  def end_ul(self):
    end_bullet_list()

#list items
  def start_li(self,attributes):
    if self.list_kind == 'ol':
      begin_numbered_list_item()
    else:
      begin_bullet_list_item()

  def end_li(self):
    if self.list_kind == 'ol':
      end_numbered_list_item()
    else:
      end_bullet_list_item()

  def start_dt(self,attributes): self._save()
  def end_dt(self):
    begin_keyed_list_item(self._saved())

  def start_dd(self,attributes): pass
  def end_dd(self): end_keyed_list_item()

#headings
  def start_h1(self,attributes): self._save()
  def end_h1(self): head(1,self._saved())

  def start_h2(self,attributes): self._save()
  def end_h2(self): head(2,self._saved())

  def start_h3(self,attributes): self._save()
  def end_h3(self): head(3,self._saved())

  def start_h4(self,attributes): self._save()
  def end_h4(self): head(4,self._saved())

  def start_h5(self,attributes): self._save()
  def end_h5(self): head(5,self._saved())

  def start_h6(self,attributes): self._save()
  def end_h6(self): head(6,self._saved())

  def unknown_starttag(self,tag,attributes):
    print 'UNKNOWN START TAG',tag,attributes

  def unknown_endtag(self,tag):
    print 'UNKNOWN END TAG',tag

  def unknown_charref(self,ref):
    print 'BAD CHAR REF',ref

  def unknown_entityref(self,ref):
    print 'UNKNOWN ENTITY REF',ref

  # due to a bug in sgmllib, this routine will
  # never be called
  def report_unbalanced(self,tag):
    print 'LONELY ENDTAG',tag

  def start_script(self,attributes):
    if verbosity>=6: print 'start of script'
    for param, value in attributes:
      if string.lower(param) == 'language':
        self.script_language = string.lower(value)
        self.saved_comments = ''

  def end_script(self):
    if verbosity>=6: print 'end of script'
    if self.script_language == 'python':
      try:
        exec self.saved_comments in globals(),input.userdict
      except:
        print "Error executing python <SCRIPT>"
        traceback.print_exc()
    elif self.script_language == 'tcl':
      if pytcl:
        try:
          tk.pytcl_eval(line)
        except:
          print "Error executing tcl <SCRIPT>"
          traceback.print_exc()
      else:
        print 'Sorry, tcl not available'
    else:
      print 'Sorry',self.script_language,'not available'

#line 218 "iscr.pak"
class global_frame:
  def __init__(self):
    self.ids = {}
    self.flist = []
    self.break_on_error = 0
    self.debug_constructors = 0
    self.debug_destructors = 0

#line 228 "iscr.pak"
class input_frame:
  def __init__(self, src, reg_list, userdict):
    self.source = src
    self.userdict = userdict
    self.reg_list = reg_list

    self.tangler_stack = []
    self.tangler = None
    self.line_offset = 0
    self.original_filename = src.get_source_name()
    self.head_offset = 0

#line 250 "iscr.pak"
  def tangler_push(self,f):
    self.tangler_stack.append(self.tangler)
    self.tangler = f

  def tangler_pop(self):
    self.tangler = self.tangler_stack[-1]
    del self.tangler_stack[-1]

  def tangler_set(self,f):
    self.tangler = f

#line 8 "iscrcmd.pak"
#---------------------------------------------------------
# USER COMMANDS

#line 18 "iscrcmd.pak"
def get_weaver():
  return input.userdict['weaver']

def output(f):
  return data_tangler(named_file_sink(f),get_weaver())

def C_output(f):
  return C_tangler(named_file_sink(f),get_weaver())

def CPP_output(f):
  return CPP_tangler(named_file_sink(f),get_weaver())

def python_output(f):
  return python_tangler(named_file_sink(f),get_weaver())

def perl_output(f):
  return perl_tangler(named_file_sink(f),get_weaver())

# temporarily, we'll use a data tangler
def interscript_output(f):
  return data_tangler(named_file_sink(f),get_weaver())

#line 91 "iscrcmd.pak"
def push(f):
  weaver = get_weaver()
  if input.tangler:
    weaver.code_foot(input.tangler)
  input.tangler_push(f)
  if input.tangler:
    weaver.code_head(input.tangler)

def pop():
  weaver = get_weaver()
  if input.tangler:
    weaver.code_foot(input.tangler)
  input.tangler_pop()
  if input.tangler:
    weaver.code_head(input.tangler)

def select(f):
  weaver = get_weaver()
  if input.tangler:
    weaver.code_foot(input.tangler)
  input.tangler_set(f)
  if input.tangler:
    weaver.code_head(input.tangler)

def begin_comments():
  if input.tangler:
    input.tangler_push(input.tangler.get_comment_tangler())
  else:
    input.tangler_push(None)

def end_comments():
  input.tangler_pop()

def resume_code():
  input.tangler_pop()

def comment(v):
  get_weaver().write_comment(v)

def begin_string(eol = ' ', width = 0):
  if input.tangler:
    input.tangler_push(input.tangler.get_string_tangler(eol,width))
  else:
    input.tangler_push(None)

def end_string():
  tangler_pop()

def weave(s):
  weaver = get_weaver()
  weaver.write(s)

def weave_line(s):
  weaver = get_weaver()
  weaver.writeline(s)

def tangle(s, inhibit_sref=0):
  if input.tangler:
    line = input.original_count
    file = input.original_filename
    input.tangler.writeline(s,file,line,inhibit_sref)
  else:
    print "tangle: No tangler for",s

#line 8 "iscrcmdd.pak"
def head(level, text, atext='', anchor=''):
  level = int(level)
  level = level + input.head_offset
  input.last_head = level
  if verbosity>=3: print ('  '*(level-1))+'"'+text+'"'
  weaver = get_weaver()
  if input.tangler:
    weaver.code_foot(input.tangler)
  input.tangler_set(None)
  weaver.head(level,text,atext,anchor)

# like heading, but to be used in code as well:
# doesn't switch to document mode, doesn't do
# code headings and footings

def heading(level, text, atext='', anchor=''):
  level = int(level)
  level = level + input.head_offset
  input.last_head = level
  if verbosity>=3: print ('  '*(level-1))+'"'+text+'"'
  weaver = get_weaver()
  weaver.head(level,text,atext,anchor)

def push_head(amt=1):
  input.head_offset = input.head_offset + amt

def pop_head(amt=1):
  push_head(-amt)

def set_head(amt=None):
  if amt != None:
    input.head_offset = amt - 1
  else:
    input.head_offset = input.last_head - 1

#line 45 "iscrcmdd.pak"
def doc():
  weaver = get_weaver()
  if input.tangler:
    weaver.code_foot(input.tangler)
  input.tangler_set(None)

def p(): # end a paragraph and start a new one
  weaver = get_weaver()
  weaver.par()

def eop(): # end a paragraph without starting a new one
  weaver.eop()

#line 60 "iscrcmdd.pak"
def cite_url(url):
  weaver = get_weaver()
  weaver.cite_url(url)

#line 66 "iscrcmdd.pak"
def begin_numbered_list(start=1):
  weaver = get_weaver()
  weaver.begin_numbered_list(start)

def end_numbered_list():
  weaver = get_weaver()
  weaver.end_numbered_list()

def begin_numbered_list_item():
  weaver = get_weaver()
  weaver.begin_numbered_list_item()

def end_numbered_list_item():
  weaver = get_weaver()
  weaver.end_numbered_list_item()

def begin_bullet_list():
  weaver = get_weaver()
  weaver.begin_bullet_list()

def end_bullet_list():
  weaver = get_weaver()
  weaver.end_bullet_list()

def begin_bullet_list_item():
  weaver = get_weaver()
  weaver.begin_bullet_list_item()

def end_bullet_list_item():
  weaver = get_weaver()
  weaver.end_bullet_list_item()

def begin_keyed_list():
  weaver = get_weaver()
  weaver.begin_keyed_list()

def end_keyed_list():
  weaver = get_weaver()
  weaver.end_keyed_list()

def begin_keyed_list_item(key):
  weaver = get_weaver()
  weaver.begin_keyed_list_item(key)

def end_keyed_list_item():
  weaver = get_weaver()
  weaver.end_keyed_list_item()

#line 116 "iscrcmdd.pak"
def begin_emphasize():
  weaver = get_weaver()
  weaver.begin_emphasize()

def end_emphasize():
  weaver = get_weaver()
  weaver.end_emphasize()

def begin_strong():
  weaver = get_weaver()
  weaver.begin_strong()

def end_strong():
  weaver = get_weaver()
  weaver.end_strong()

def begin_italic():
  weaver = get_weaver()
  weaver.begin_italic()

def end_italic():
  weaver = get_weaver()
  weaver.end_italic()

def begin_bold():
  weaver = get_weaver()
  weaver.begin_bold()

def end_bold():
  weaver = get_weaver()
  weaver.end_bold()

def begin_big():
  weaver = get_weaver()
  weaver.begin_big()

def end_big():
  weaver = get_weaver()
  weaver.end_big()

def begin_small():
  weaver = get_weaver()
  weaver.begin_small()

def end_small():
  weaver = get_weaver()
  weaver.end_small()

def begin_code():
  weaver = get_weaver()
  weaver.begin_code()

def end_code():
  weaver = get_weaver()
  weaver.end_code()

#line 174 "iscrcmdd.pak"
def begin_displayed_code():
  weaver = get_weaver()
  weaver.begin_displayed_code()

def end_displayed_code():
  weaver = get_weaver()
  weaver.end_displayed_code()

#line 160 "iscrcmd.pak"
class nodefault: pass

def lookup_dict(dict,key,dflt=None):
  if dict.has_key(key): return dict[key]
  elif dflt != nodefault: return dflt
  else: raise nodefault

def lookup_attr(object,key,dflt):
  return lookup_dict(object.__dict__,key,dflt)

def print_contents():
  weaver = get_weaver()
  weaver.print_contents()

def print_file_list():
  weaver = get_weaver()
  weaver.print_file_list()

def macro(name):
  weaver = get_weaver()
  return data_tangler(memory(name),weaver)

def print_identifier_cross_reference():
  weaver = get_weaver()
  weaver.idxref()

#line 266 "iscr.pak"
def enqueue_input(file, count, line):
  read_buffer.append((file,count,line))

def dequeue_input():
  data = read_buffer[0]
  del read_buffer[0]
  return data

def line(number, filename):
  input.original_file = filename
  input.line_offset = number - input.src.get_lines_read()

def readline():
  global input
  global input_stack
  while(1):
    if read_buffer:
      return dequeue_input()
    try:
      line = input.source.readline()
      input.real_filename = input.source.get_source_name()
      input.real_count = input.source.get_lines_read()
      input.original_count = input.real_count + input.line_offset
      line = string.rstrip(line)
      input.line = string.expandtabs(line,tabwidth)
        # the tabwidth should come from the input frame!
      return (input.original_filename,input.original_count,input.line)
    except KeyboardInterrupt:
      g.update_files = 0
      raise KeyboardInterrupt
    except eof:
      if verbosity>=4: print 'readline: EOF',len(input_stack)
      input.line = None
      raise eoi
    else:
      if verbosity>=1: print 'program error in readline:',sys.exc_info()
      g.update_files = 0

def begin():
  global input
  ho = input.head_offset
  input.tangler_set(None)
  input_stack.append(input)
  input = input_frame(input.source, input.reg_list[:], input.userdict.copy())
  input.head_offset = ho

def end():
  raise eoi

def swap():
  global input
  global input_stack
  tmp = input
  input = input_stack[-1]
  input_stack[-1]=tmp

def include_file(name):
  if verbosity>=2: print 'input from',name
  include_source(named_file_source(name))

def include_source(source):
  global input
  input.tangler_set(None)
  input_stack.append(input)
  ho = input.head_offset
  input = input_frame(source, [], input.userdict.copy())
  input.head_offset = ho
  set_warning_character(python='@')

# this command includes a code file as if
# @select(tangler) had been written followed
# followed by the file contents _with commands quoted!!_
# the file consists entirely of code (no doco, no executable script)
# [Except for comments, perl POD, etc]

def include_code(name,tangler):
  global input
  input.tangler_set(None)
  input_stack.append(input)
  weaver = get_weaver()
  input = input_frame(named_file_source(name), [(any_line_re,do_web)], input.userdict.copy())
  select(tangler)

# whereas this command includes a file into
# code for the current tangler, again _with commands quoted!!_
# the file consists entirely of code (no doco, no executable script)

def insert_code(name):
  global input
  input.tangler_push(input.tangler)
  input_stack.append(input)
  input = input_frame(named_file_source(name), [(any_line_re,do_web)], input.userdict.copy())

# this command is used to print out a code file 'verbatim'
def display_code(name):
  begin_displayed_code()
  f = open(name)
  data = f.readlines()
  f.close()
  for line in data:
    l = string.rstrip(line)
    get_weaver().writeline(l)
  end_displayed_code()
#
# This command is used inside an interscript tangler to
# put an external file into a .pak archive.
# It writes out a 'select' command, and then the file,
# with leading @ characters converted to two @ characters.
#
# use it like this:
# @select(archive)
# @untangle('fred.pak')
# @untangle('joe.pak')
#
# This mechanism is required to support include files,
# since a top level document is incomplete otherwise.
#
# Note that the inserted code is not woven!
# In fact, the tangler never sees it, it simply
# supplies the sink object
#
def untangle(name):
  if not input.tangler:
    raise 'untangle without active tangler'
  f = open(name)
  data = f.readlines()
  f.close()
  input.tangler.sink.writeline('@select(output("'+name+'"))')
  for line in data:
    l = string.rstrip(line)
    if len(l):
      if l[0]=='@': l = '@'+l
    input.tangler.sink.writeline(l)
  input.tangler.sink.writeline('@select(None)')
  input.tangler.weaver.begin_small()
  input.tangler.weaver.writeline('Included '+name+', '+str(len(data))+' lines.')
  input.tangler.weaver.end_small()
  input.tangler.weaver.line_break()

def include_html(source):
  global input
  input.tangler_set(None)
  input_stack.append(input)
  r = [(any_line_re,do_html)]
  input = input_frame(source, r, input.userdict.copy())
  input.html_parser = sgml_wrapper(html_filter())

# this command reads rudimentary html, and translates it
# into calls to interscript
# For example, <B> is translated to call the bold() command
#
# Python script can be included in the html using
# the tag <SCRIPT LANGUAGE="python"> .. </SCRIPT>
# At present, the translator has even less features than interscript:
# it's only a stub for a more full scale translator
#
# see the code for details. (reference??)
#
def html():
  global input
  input.tangler_set(None)
  input_stack.append(input)
  r = [(any_line_re,do_html)]
  input = input_frame(input.source, r, input.userdict.copy())
  input.html_parser = sgml_wrapper(html_filter())


#line 435 "iscr.pak"

# utility
def normal_line(data,file,count):
  weaver = get_weaver()
  if input.tangler:
    input.tangler.writeline(data,file,count)
  else:
    weaver.writeline(data)

def tcl_exec(line,file,count,glb,user):
  try:
    print 'Calling tcl with',line
    tk.pytcl_eval(line)
  except KeyboardInterrupt:
    g.update_files = 0
    raise KeyboardInterrupt
  except:
    print 'error executing tcl:',file,count,':',line
    traceback.print_exc()
    if g.break_on_error:
      g.update_files = 0
      sys.exit()

def py_exec(py,file,count,glb,user):
  try:
    if verbosity>4: print 'Executing',py
    exec py in glb,user
  except KeyboardInterrupt:
    g.update_files = 0
    raise KeyboardInterrupt
  except eoi:
    raise eoi
  except:
    print 'error executing python:',file,count,':',py
    traceback.print_exc()
    if g.break_on_error:
      g.update_files = 0
      sys.exit()

def collect_stuff(prefix, cont_re, echo):
  saved = prefix
  try:
    file2,count2,line = readline()
    match = cont_re.match(line)
    while match:
      if echo:
        print '%s %6s: %s' % (file2,count2,line)
      body = match.group(1)
      if not body: body = ''
      saved = saved+'\n'+body
      file2,count2,line = readline()
      match = cont_re.match(line)
    enqueue_input(file2,count2,line)
  except eoi:
    pass
  saved = saved + '\n'
  return saved

# main functions
def do_exec_line(match, file,count,glb,user):
  py_exec(match.group(1),file,count,glb,user)

def do_exec_suite(match,file,count,glb,user):
  saved = collect_stuff(match.group(1), cont_re, user['echo_input'])
  py_exec(saved,file,count,glb,user)

def do_web(match,file,count,glb,user):
  normal_line(match.group(1),file,count)

def do_quote_at(match,file,count,glb,user):
  normal_line(match.group(1)+match.group(2),file,count)

def do_tclexec_line(match,file,count,glb,user):
  tcl_exec(match.group(1),file,count,glb,user)

def do_tclexec_suite(match,file,count,glb,user):
  saved = collect_stuff(match.group(1), cont_re, user['echo_input'])
  tcl_exec(saved,file,count,glb,user)

def do_html(match,file,count,glb,user):
  input.html_parser.writeline(match.group(1),file,count)

#line 530 "iscr.pak"
# regexp's for the main functions

def make_parse_tab( pywarn = None, tclwarn = None):
  res = []
  if pywarn:
    res = res + [
      ['^'+pywarn+'('+pywarn+')(.*)$',do_quote_at],
      ['^'+pywarn+'(.*[-+*/%:,\([{]) *(#.*)?$', do_exec_suite],
      ['^'+pywarn+'(.*)$',do_exec_line]
      ]


  if tclwarn:
    res = res + [
      ['^'+tclwarn+'('+tclwarn+')(.*)$', do_quote_at],
      [r"^'+tclwarn+'(.*[{\\]) *(#.*)?$", do_tclexec_suite],
      ['^'+tclwarn+'(.*)$', do_tclexec_line]
      ]

  res = res + [
    ['^(.*)$',do_web]
    ]
  return res

def compile_parse_tab(res):
  return map(lambda x: [re.compile(x[0]), x[1]], res)

# this is the user command
def set_warning_character(python=None,tcl=None):
  res = make_parse_tab(pywarn=python,tclwarn=tcl)
  res = compile_parse_tab(res)
  input.reg_list = res

#line 576 "iscr.pak"
import sys
import re
import string
import traceback
import re
import tempfile
import os
import stat
import time
import ftplib
import keyword
import user
import getopt
import token
try:
  import tokenise
  tokenise_available = 1
  print 'tokenise available'
except:
  tokenise_available = 0
try:
  import thread
  thread_available = 1
  print 'thread available'
except:
  print 'thread NOT available'
  thread_available = 0

sys.path = ['']+sys.path

#line 611 "iscr.pak"
buildno=298
version='1.0a2'
hostname='ruby'
username='root'
buildtime='Mon Jul 27, 1998 at 05:08 PM (UTC)'
generator_buildno=280
generator_hostname='ruby'
generator_username='root'
generator_version='1.0a2'

print 'Interscript version',version,'build',buildno
print 'Built by',username,'on',hostname,'at',buildtime
print 'Generated by',generator_version,'buildno',generator_buildno,'host',generator_hostname

#line 18 "iscroptg.pak"
#process frame defaults
echo_input = 0
trypytcl = 1
trygui = 0
update_files = 1
tabwidth = 8
verbosity = 2
download = 'regularly'
refresh_interval = 28
passes = 1

#option help dictionary
shortoptdict = { 'v':'verbose (verbosity=6)' }

longoptdict = {
  'echo_input=':{0:"Don't echo input (default)",1:'Echo input'},
  'verbosity=': {
    0:'no messages', # none _at all_, not even serious errors
    1:'fatal messages', # _only_ serious errors
    2:'warnings',       # all errors
    3:'brief progress', # open and close weavers, tanglers, files
    4:'progress and information', # headings, 'watch it run'
    5:'full progress and information', # full user information
    6:'user source debugging', # full debugging of _user_ script
    7:'interscript debugging', # basic control flow debugging
    8:'full interscript debugging', # enough to debug interscript itself
    9:'eveything' # for unintelligible output :-)
  },
  'weaver=': {
    'html': 'flat html',
    'tex': 'plain tex (not implemented)',
    'latex': 'latex2e',
    'text':'plain text',
    'ps': 'postscript (not implemented)',
    'eps': 'encapsulated postscript (not implemented)',
    'rtf': 'Rich Text (not implemented)',
    'word': 'microsoft word (not implemented)'
  },
  'output-prefix=':'prefix added to output filenames (not implemented)',
  'python=':'execute python script',
  'tcl=': {
    0:'disable tcl script',
    1:'try to enable tcl script (default)'},
  'gui=': {
    0:'no gui (default)',
    1:'try to build gui'},
  'update=':{
    0:'Allow buffered file write (default)',
    1:'Inhibit buffered file write'},
  'download=':{
    0:'only download by ftp or http when necessary',
    1:'force download by ftp or http'},
  'refresh_interval=':
    'download when local file is older than this number of days (default 28)',
  'tabwidth=':'column width for tab expansion (default 8)',
  'passes=':'passs on each file (default 1)',
  'logfile=':'<filename> for messages',
  'help':'this help',
  'usage':'this help' }


def print_help():
  print 'Usage: python iscr.py [options] <filename>'
  print '  options:'
  for k in shortoptdict.keys(): print_help1(k)
  for k in longoptdict.keys(): print_help1(k)

def print_help1(k):
  if longoptdict.has_key(k):
    values = longoptdict[k]
    k = '--'+k
  elif shortoptdict.has_key(k):
    values = shortoptdict[k]
    k = '-'+k
  elif longoptdict.has_key(k+'='):
    k = k + '='
    values = longoptdict[k]
  elif shortoptdict.has_key(k+'='):
    k = k + '='
    values = shortoptdict[k]
    k = '-'+k
  else:
    values = 'Unknown option'

  print '  '+k,
  if type(values) is type({}):
    print
    for value in values.keys():
      print '   '+str(value)+':',values[value]
  else:
    print values

longkeys = longoptdict.keys()
shortkeys_novalue = ''
shortkeys_value = ''
for k in shortoptdict.keys():
  if len(k)==1: shortkeys_novalue = shortkeys_novalue + k
  else: shortkeys_value = shortkeys_value + k[0]

opts, files_to_process =  getopt.getopt(
  sys.argv[1:],
  shortkeys_novalue+':'+shortkeys_value,
  longoptdict.keys())

autoweave = []

for opt,value in opts:
  try:
    if opt == '--tcl': trypytcl=int(value)
    elif opt == '--verbosity': verbosity = int(value)
    elif opt == '--echo_input': echo_input = int(value)
    elif opt == '--gui': trygui = int(value)
    elif opt == '-v': verbosity = 6
    elif opt == '--noupdate': update_files = 0
    elif opt == '--nodownload': download = 'never'
    elif opt == '--download': download = 'always'
    elif opt == '--tabwidth': tabwidth = int(value)
    elif opt == '--passes': passes = int(value)
    elif opt == '--weaver': autoweave.append(value)
    elif opt == '--python':
      try:
        if verbosity>=3:
          print 'Executing python:'
          print value
        exec value
      except:
        print 'Error in python option'
        traceback.print_exc()
    elif opt == '--logfile':
      oldsysin = sys.sysin
      sys.sysin = open(value,'w')
    elif opt in ['--help', '--usage']:
      print_help()
      print
    else:
      print 'Woops, unimplemented option'
    if verbosity>=4: print 'Option:',opt,value
  except:
    print 'Warning: Option',opt,'has bad value',value
    prefix = ''
    while opt[0]=='-': prefix = prefix + '-'; opt=opt[1:]
    print_help1(opt)

if not files_to_process: sys.exit(0)

if verbosity>=4:
  print 'Info: Files to process',files_to_process

#line 638 "iscr.pak"
gui = 0
pytcl = 0
if trypytcl:
  try:
    if verbosity>=4: print 'trying to load _pytcl'
    import _pytcl
    if verbosity>=3: print 'pytcl loaded'
    tk = _pytcl.create_tcl_interpreter()
    _pytcl.teach_tcl(tk)
    pytcl = 1
    if trygui:
      try:
        tk.pytcl_eval('package require Tk')
        tk.pytcl_eval('package require Tix')
        gui = 1
      except: pass
  except: pass

if pytcl == 0: gui = 0


#line 661 "iscr.pak"
if pytcl:
  def tclpy(interp,cmd,*args):
    if verbosity>=5: print 'unknonwn tcl cmd',cmd,'args',args
    try:
       func = None
       if globals().has_key(cmd):
         func = globals()[cmd]
       elif input.userdict.has_key(cmd):
         func = input.userdict[cmd]
       if func !=None:
         if verbosity>=5: print 'Trying Python',cmd,args
         try:
           apply(func,args)
           print 'Done, OK in Python'
         except:
           print 'Error in python function call',cmd,args
           traceback.print_exc()
       else:
         if verbosity>=4: print "Can't find a python cmd",cmd
    except:
      if verbosity>=4: print 'Ignore error in python call',cmd,args

  tk.create_string_command('unknown',tclpy)

  def pyexec(interp,s):
    if verbosity>=6: print 'To exec in python:',s
    exec s in globals(),input.userdict

  tk.create_string_command('pyexec',pyexec)

#line 696 "iscr.pak"

cont_re = re.compile('^$|^ (.*)$')
any_line_re = re.compile('^(.*)$')

if verbosity>=3: print 'Autoweave',autoweave
for file in files_to_process:
  for passno in range(passes):
    if verbosity>=2: print 'Processing',file
    g = global_frame()
    input_stack = []
    read_buffer = []
    g.tokenise_available = tokenise_available
    g.update_files = update_files
    g.tabwidth = tabwidth
    g.download = download
    g.thread_available = thread_available

#line 719 "iscr.pak"
    try:
      basename = file
      if string.find(file,'.') != -1:
        basename = string.join(string.split(file,'.')[:-1],'.')
      weavers = []
      for w in autoweave:
        if w == 'html':
          w = named_file_sink(basename+'.html')
          w = html_weaver(w,title=basename)
          weavers.append(w)
        elif w == 'web':
          w = named_file_sink(basename+'.html')
          w = html_weaver(w,title=basename)
          swprefix = basename
          w = stacking_weaver(w,swprefix,(1,2,3,4,5,6,7,8,9,10))
          del swprefix
          weavers.append(w)
        elif w == 'latex':
          w = named_file_sink(basename+'.tex')
          w = latex_weaver(w)
          weavers.append(w)
        elif w == 'text':
          w = named_file_sink(basename+'.txt')
          w = plain_text_weaver(w)
          weavers.append(w)
        else: pass
      w = multiplexor(weavers)
      userdict = {
        'weaver':w,
        'echo_input':echo_input }
      del w
      del weavers
      input_file =named_file_source(file)
      input = input_frame(input_file, [], userdict)
      set_warning_character(python='@')
    except:
      if verbosity>=1: print "Can't open",file
      traceback.print_exc()
      continue

    if verbosity>=3: print 'input from',input.source.get_source_name()

    if gui:
      input_win = gui_output(tk,'.inp')


#line 790 "iscr.pak"
    try:
      while(1):
        try:
          file,count,line = readline()
          if gui:
            input_win.writeline(line)

          echo = 0
          if input.userdict.has_key('echo_input'):
            echo = input.userdict['echo_input']
          if verbosity>=6 or echo and verbosity!=0:
            print '%s %6s: %s' % (file,count,line)
          for r in input.reg_list:
            match = r[0].match(line)
            if match:
              r[1](match,file,count,globals(), input.userdict)
              break
        except eoi:
          if verbosity>=4: print 'EOI detected'
          if input_stack:
            if verbosity>=6: print 'Poping input stack'
            input = input_stack[-1]
            del input_stack[-1]
            # KLUDGE: we throw an exception and ignore it to
            # clear out the stupid traceback
            try: raise eoi
            except: pass
          else:
            if verbosity>=6: print 'input stack empty'
            raise eoi
    except eoi:
      if verbosity>=6: print 'EOF detected'
    except:
      if verbosity>=1:
        print 'program error'
        traceback.print_exc()
      g.update_files = 0
      sys.exit(1)

#line 831 "iscr.pak"
if gui:
  run = 1
  def quit(interp,*args):
    global run
    run = 0
  tk.create_string_command('quit',quit)
  tk.pytcl_eval('wm protocol . WM_DELETE_WINDOW quit')
  while(run):
    _pytcl.dooneevent()

if len(input_stack) !=0:
  if verbosity>=1: print 'Input stack unexpectedly non-empty at termination'
del input

if verbosity>=3: print 'releasing user objects'
# user objects get released here, this should actually
# delete the weaver (which is refered to by the user tangler,
# which the user probably gave a global symbolic name :-(

