import vp, X, Xlib

from Canvas        import Canvas
from Responder     import Responder
from Sketcher      import Sketcher, RubberRectSketcher, RubberBandSketcher

from Lines         import Line
from Rectangle     import Rectangle
from Circle        import Circle
from TextPrimitive import TextPrimitive
from WidgetButton  import PushButton
from TextControls  import TextList

editmessage = 'Use leftmouse for selection and resizing, \
middlemouse for dragging, and cntrl-d to delete' 

class DrawTools:

	def __init__( self, win, canvas ):
		self.win           = win
		self.canvas        = canvas
		self.curr_sketcher = None
		self.curr_creator  = None
		self.curr_txtobj   = None
		self.fill          = vp.FALSE
		self.outline       = vp.FALSE

		ps  = Sketcher({ 'canvas': canvas, 'callback': self.EndSketchCB })
		rrs = RubberRectSketcher({ 'canvas'  : canvas, 
								   'callback': self.EndSketchCB })
		rbs = RubberBandSketcher({ 'canvas'  : canvas,
								   'callback': self.EndSketchCB })

		self.sketchers = {
			  'rect'    : rrs, 
			  'line'    : rbs, 
			  'circle'  : rrs, 
			  'text'    : ps, 
			  'button'  : rrs,
			  'textlist': rrs
			  }
		self.creators = {
			  'rect'    : self._CreateRect,
			  'circle'  : self._CreateCircle,
			  'line'    : self._CreateLine,
			  'text'    : self._CreateText,
			  'button'  : self._CreateButton,
			  'textlist': self._CreateTextList
			  }
		self.CreateToolbox()
		canvas.Subscribe( vp.MOUSE_DOWN, self.MouseDownEH, None )
		canvas.Subscribe( vp.KEYPRESS, self.KeyPressEH, None )


	def CreateToolbox( self ):
		from WidgetButton import ToggleButton
		from Box          import Glue, Box
		from RadioGroup   import RadioGroup
		from MiscGraphic  import Separator

		rg = RadioGroup()
		self.tbox = Box({ 'alignment'     : vp.VCENTER,
						  'stretchability': (vp.FIXED, vp.ELASTIC) })

		# first add the edit button, then the creator buttons, and the
		# some option buttons.

		self.tbox.AddChild( ToggleButton({ 
			  'name'          : 'edit',
			  'radio_group'   : rg,
			  'callback'      : self.SetDrawToolCB,
			  'use_indicator' : vp.FALSE,
			  'stretchability': (vp.ELASTIC, vp.FIXED)
			  }))
		self.tbox.AddChild( Separator({ 'size': (10,10) }) )

		for name in self.creators.keys():
			self.tbox.AddChild( ToggleButton({ 
			    'name'          : name,
				'radio_group'   : rg,
				'callback'      : self.SetDrawToolCB,
				'use_indicator' : vp.FALSE,
				'stretchability': (vp.ELASTIC, vp.FIXED)
				}))
		self.tbox.AddChild( Separator({ 'size': (10,10) }) )

		self.tbox.AddChild( ToggleButton({
			'name'          : 'fill',
			'callback'      : self.SetFillOnOffCB,
			'stretchability': (vp.ELASTIC, vp.FIXED)
			}))
		self.tbox.AddChild( ToggleButton({
			'name'          : 'outline',
			'callback'      : self.SetOutlineOnOffCB,
			'stretchability': (vp.ELASTIC, vp.FIXED)
			}))
		self.tbox.AddChild( Glue( 10, vp.ELASTIC ) )


		    
	# ------------------------------------------------------------------
	# Access methods

	def GetToolbox( self ): return self.tbox


	# ------------------------------------------------------------------
	# Callback methods

	def SetDrawToolCB( self, button ): 
		name = button.GetName()
		print 'DrawTools: Set sketcher', name

		self.curr_txtobj = None

		if name != 'edit':
			self.curr_creator  = self.creators[name]
			self.curr_sketcher = self.sketchers[name]
			self.win.SetMessage( '' )
		else:
			self.win.SetMessage( editmessage )
			self.curr_sketcher = None

	def SetFillOnOffCB( self, tbutton ): self.fill = tbutton.GetState()

	def SetOutlineOnOffCB( self, tbutton ): self.outline = tbutton.GetState()

	def EndSketchCB( self, sketcher ): 
		obj = self.curr_creator( sketcher.GetGeometry() )
		self.canvas.AddChild( obj )
		vp.theSelection.SetEmpty()
		obj.SetSelected( vp.TRUE )
			

	# ------------------------------------------------------------------
	# Object creation methods

	def _CreateRect( self, g ):
		return Rectangle({'pos'      : (g[0], g[1]),
						  'size'     : (g[2]-g[0], g[3]-g[1]),
						  'fill'     : self.fill,
						  'outline'  : self.outline,
						  'editmode' : vp.TRUE,
						  'draggable': vp.TRUE})
			
	def _CreateLine( self, g ):
		return Line({'begin'    : g[0],
					 'end'      : g[1], 
					 'editmode' : vp.TRUE,
					 'draggable': vp.TRUE})

	def _CreateCircle( self, g ):
		return Circle({'pos'      : (g[0], g[1]),
					   'size'     : (g[2]-g[0], g[3]-g[1]),
					   'fill'     : self.fill,
					   'outline'  : self.outline,
					   'editmode' : vp.TRUE,
					   'draggable': vp.TRUE})

	def _CreateText( self, g ):
		self.curr_txtobj = TextPrimitive({'pos'      : (g[0], g[1]),
										  'string'   : '',
										  'editmode' : vp.TRUE,
										  'draggable': vp.TRUE})
		return self.curr_txtobj

	def _CreateButton( self, g ):
		return PushButton({'pos'      : (g[0], g[1]),
						   'size'     : (g[2]-g[0], g[3]-g[1]),
						   'editmode' : vp.TRUE,
						   'draggable': vp.TRUE})

	def _CreateTextList( self, g ):
		return TextList({'pos'      : (g[0], g[1]),
						 'size'     : (g[2]-g[0], g[3]-g[1]),
						 'editmode' : vp.TRUE,
						 'draggable': vp.TRUE})

	# ------------------------------------------------------------------
	# Event notification methods:

	def MouseDownEH( self, target, client_data, xevent, e ):
		if self.curr_sketcher == None and target != self:
			target.MouseDownEH( target, client_data, xevent, e )
		else:
			self.curr_sketcher.MouseDownEH( target, client_data, xevent, e )


	def KeyPressEH( self, target, client_data, xevent, e ):
		if e == None: e = XEvent.mkevent(xevent)          

		(key, keycode) = Xlib.LookupString(xevent)

		if keycode == vp.DELETE or \
		   e.state == X.ControlMask and vp.ConvertKeycode(keycode) == 'd': 
			for obj in vp.theSelection.GetSelection(): 
				if not obj.IsA( Canvas ):
					obj.Finalize()

		elif self.curr_txtobj != None:            # add char to txtobj
			cs = self.curr_txtobj.string.Get()
			if keycode == vp.BACKSPACE:
				self.curr_txtobj.string.Set( cs[:len(cs)-1] )
			elif keycode in range(256):           # ASCII character
				self.curr_txtobj.string.Set( cs + key )
			

# -------------------------------------------------------------------------
# Test function

def test():
	from Application   import Application
	from Window        import Window
	from MiscGraphic   import ScrolledViewPort
	from Menu          import PulldownMenu
	from Box           import Box

	app = Application( 'test' )
	win = Window({ 'size': (500, 400) })
	win.SetMessage( 'This is a simple drawing editor' )

	# add a menu and a message area

	win.AddMenu( PulldownMenu({
		  'title': 'File',
		  'items': [ vp.theQuitCommand ]
		  }))

	# add a workarea with a toolbox

	canvas    = Canvas({ 'size': (1000, 1000), 'selection_rect': vp.TRUE })

	win.AddWorkArea( Box({
		  'child_list': [
		      DrawTools( win, canvas ).GetToolbox(), 
			  ScrolledViewPort({ 'view': canvas })
			  ]
		  }))
	app.Run()

test()
