import vp

from Application   import Application
from Window        import ScrolledWindow
from Canvas        import Canvas
from Box           import Box
from Lines         import Line
from Rectangle     import Rectangle
from Circle        import Circle
from TextPrimitive import TextPrimitive
from WidgetButton  import PushButton, ToggleButton
from Datum         import Tuple, Add, Divide

# -------------------------------------------------------------------------
# Process class

class Process( Box ):

	def InitWidget( self ):
		Box.InitWidget( self )

		# Add hooks for linkage

		x = self.x
		y = self.y
		w = self.width
		h = self.height
		self.AddDatum('lhook', Tuple(x, Add(y, Divide(h, 2) )))
		self.AddDatum('rhook', Tuple( Add(x, w), Add(y, Divide(h, 2))))


# -------------------------------------------------------------------------
# Test function

def test():
	app = Application( 'test' )
	win = ScrolledWindow({ 'size': (600, 500) })
	win.SetMessage( 'The objects can be dragged and edited' )

	# Add a workarea to the window

	canvas = Canvas({ 'size': (1000, 1000), 'selection_rect': vp.TRUE })
	win.AddWorkArea( canvas )

	# Create some primitives

	line1 = Line()
	canvas.AddChild( line1 )

	rect1 = Rectangle({
		  'pos'      : (10,100), 
		  'size'     : (40,40),
		  'editmode' : vp.TRUE,
		  'draggable': vp.TRUE,
		  'xres'     : {'line_width': 5, 'foreground': 'yellow'}
		  })
	canvas.AddChild( rect1 )

	line2 = Line({ 
		  'begin'    : (100,100), 
		  'end'      :(150,150),
		  'editmode' : vp.TRUE,
		  'draggable': vp.TRUE 
		  })
	canvas.AddChild( line2 )

	rect2 = Rectangle({ 
		  'pos'      : (10, 100), 
		  'size'     : (40, 40),
		  'editmode' : vp.TRUE,
		  'draggable': vp.TRUE 
		  })
	canvas.AddChild( rect2 )

	circle = Circle({ 
		  'pos'      : (100,100), 
		  'diameter' : 40, 
		  'editmode' : vp.TRUE,
		  'draggable': vp.TRUE,
		  'xres'     : {'line_width': 3}
		  })   
	canvas.AddChild( circle )

	text = TextPrimitive({ 
		  'pos'      : (175, 175), 
		  'string'   : 'Hi there!',
		  'editmode' : vp.TRUE,
		  'draggable': vp.TRUE,
		  'xres'     : {'foreground': 'deeppink'}
		  })
	canvas.AddChild( text )

	process = Process({
		  'draggable' : vp.TRUE,
		  'alignment' : vp.VCENTER, 
		  'child_list': [PushButton({ 'name': '>>' }),
		                 PushButton({ 'name': '>>' })]
	})
	canvas.AddChild( process )

	# Constrain line1 and line2

	process.lhook.LinkTo( line1.end )
	rect1.x.DoubleLink( line2.x )

	app.Run()


def MenuCB( item ):
	print 'MenuCB:', item.GetName(), 'was selected' 


test()
