import vp

from Application      import Application
from Window           import Window
from HierarchyEditor  import HierarchyEditor
from Box              import Box, Glue
from Frame            import Frame
from WidgetButton     import PushButton



class NewNodeTypes( Frame ):

	def __init__( self, hierarchy_editor ):
		self.hed        = hierarchy_editor
		self.name_count = {'StreamSet': 0, 'SeqGroup': 0, 'ParGroup': 0}

		self.hed.AddCallback( 'node_selected', self.NodeSelectedCB )

		Frame.__init__(self,{
			'label'         : 'Node types', 
			'stretchability': (vp.FIXED, vp.FIXED),
			'child'         : self.CreateBox()
			})


	def CreateBox( self ):
		self.stream_set_but = PushButton({
			'callback'      : self.CreateNewElemCB,
			'name'          : 'StreamSet',
			'enabled'       : vp.FALSE
			})
		return Box({
			'alignment'     : vp.VLEFT,
			'child_list'    : [
				PushButton({
					'name'     : 'SeqGroup',
					'callback' : self.CreateNewElemCB
					}),
				PushButton({
					'name'     : 'ParGroup',
					'callback' : self.CreateNewElemCB
					}),
				self.stream_set_but
				]
			})


	def NodeSelectedCB( self, data ):
		if data != None: print data.GetName(), 'selected'


	def CreateNewElemCB( self, button ):
		#
		# Create a new node and give it a unique name
		#
		from TreeNode import TreeNode

		type_name = button.GetName()

		if type_name == 'StreamSet':
			node = TreeNode({ 'leaf_node_only': vp.TRUE })
		else:
			node = TreeNode()

		self.name_count[type_name] = self.name_count[type_name] + 1
		node.name = type_name + `self.name_count[type_name]`
		self.hed.SetNewNode( node )

		if not self.stream_set_but.enabled: 
			self.stream_set_but.Enable()


def test():
	app = Application('test')
	win = Window({ 'name': 'Test' })

	hed = HierarchyEditor({ 
		'alignment': vp.VCENTER,
		'show_path': vp.FALSE, 
		'show_leaf': vp.FALSE 
		}) 
	nnt = NewNodeTypes( hed )

	win.AddWorkArea( Box({ 
		'alignment' : vp.HTOP,
		'child_list': [hed, Glue(10,vp.FIXED), nnt]
		}))
	app.Run()

test()
	
