import vp

from Application   import Application
from Window        import Window
from Canvas        import Canvas
from WidgetButton  import PushButton
from Circle        import Circle
from GraphicLink   import ArrowLink, LineLink

# -------------------------------------------------------------------------
		
def test():
	app = Application('GraphicLinkTest')
	win = Window({ 'size': (300, 300) })
	win.SetMessage( 'The buttons and the circle can be dragged' )

	can = Canvas()
	win.AddWorkArea( can )

	newton = PushButton({ 'name': 'Newton', 'draggable': vp.TRUE })
	can.AddChild( newton )

	circle = Circle({ 
		  'name'     : 'Circle', 
		  'show_name': vp.TRUE,
		  'diameter' : 50,
		  'pos'      : (100,100),
		  'draggable': vp.TRUE,
		  'fill'     : vp.TRUE,
		  'outline'  : vp.TRUE
		  })
	can.AddChild( circle )

	einstein = PushButton({ 'name': 'Einstein', 'draggable': vp.TRUE })
	can.AddChild( einstein )

	can.AddChild( ArrowLink({
		  'name'         :'arrow', 
		  'show_name'    : vp.TRUE,
		  'begin_graphic': newton, 
		  'end_graphic'  : circle 
		  }) )
	can.AddChild( LineLink({
		  'name'         :'line', 
		  'show_name'    : vp.TRUE,
		  'begin_graphic': circle, 
		  'end_graphic'  : einstein 
		  }) )

	app.Run()

test()
