import vp

from Application  import Application
from Window       import Window
from Canvas       import Canvas
from Box          import Box
from Lines        import Line
from WidgetButton import PushButton
from Datum        import Tuple, Add, Divide

# -------------------------------------------------------------------------
# Process class

class Process( Box ):

	def InitWidget( self ):
		Box.InitWidget( self )

		# Add hooks for linkage

		x = self.x
		y = self.y
		w = self.width
		h = self.height
		self.AddDatum('lhook', Tuple(x, Add(y, Divide(h, 2) )))
		self.AddDatum('rhook', Tuple( Add(x, w), Add(y, Divide(h, 2))))

# -------------------------------------------------------------------------
# Test function

def test():
	app = Application( 'DragBoxTest' )
	win = Window()
	win.SetMessage( 'The box can be dragged with middle-mouse button' )

	# Add a workarea to the window

	canvas = Canvas({ 'natural_size': (500, 400) })
	win.AddWorkArea( canvas )

	# Create some primitives

	line1 = Line()
	canvas.AddChild( line1 )

	process = Process({
		  'alignment' : vp.HCENTER, 
		  'draggable' : vp.TRUE,
		  'child_list': [PushButton( {'name': '>>'} ),
						 PushButton( {'name': '>>'} )]})
	canvas.AddChild( process )

	# Constrain line1

	process.lhook.LinkTo( line1.end )

	app.Run()


test()


		
		
		
		


		
		

			  
