import vp

from Application  import Application
from Dialog       import Dialog
from MiscDialogs  import PromptDialog, WorkingDialog
from Window       import Window
from WidgetButton import PushButton
from Box          import Box

# -------------------------------------------------------------------------
# DialogTestWindow class (abstract)
#
# A class for testing dialogs

class DialogTestWindow( Window ):
	
	def __init__( self ):
		Window.__init__( self )
		self.gen_dialog     = Dialog()
		self.prompt_dialog  = PromptDialog()
		self.working_dialog = WorkingDialog()
		self.CreateWorkArea()


	def CreateWorkArea( self ):
		b1 = PushButton({ 
			  'name'    : 'InfoDialog', 
			  'callback': self.PostIDialogCB 
			  })
		b2 = PushButton({ 
			  'name'    : 'QuestionDialog',
			  'callback': self.PostQDialogCB
			  })
		b3 = PushButton({ 
			  'name'    : 'FileSelectionDialog',
			  'callback': self.PostFSDialogCB
			  })
		b4 = PushButton({ 
			  'name'    : 'GenericDialog',
			  'callback': self.PostGDialogCB
			  })
		b5 = PushButton({ 
			  'name'    : 'PromptDialog',
			  'callback': self.PostPDialogCB
			  })
		b6 = PushButton({ 
			  'name'    : 'WorkingDialog',
			  'callback': self.PostWDialogCB
			  })
		cb = PushButton({ 
			  'name'    : 'Close',
			  'callback': self.CloseCB
			  })
		self.topbox = Box({
			  'alignment' : vp.VCENTER, 
			  'child_list': [b1,b2,b3,b4,b5,b6,cb]
			  })
		self.AddWorkArea( self.topbox )


	# -------------------------------------------------------------------
	# Callbacks for test class

	def PostIDialogCB( self, button ):
		vp.theInfoDialog.Post( 'Testing InfoDialog',self.CB, self.CB, self.CB )


	def PostQDialogCB( self, button ):
		vp.theQuestionDialog.Post( 'Testing QuestionDialog', 
			                       self.CB, self.CB, None )

	def PostFSDialogCB( self, button ):
		vp.theFileSelectionDialog.Post( None, self.CB, self.CB, None )


	def PostGDialogCB( self, button ):
		self.gen_dialog.Post( 'GenericDialog', self.CB, self.CB, None )


	def PostPDialogCB( self, button ):
		self.prompt_dialog.Post( 'Prompt', self.CB, self.CB, None )


	def PostWDialogCB( self, button ):
		self.working_dialog.Post( 'Working', self.CB, self.CB, None )


	def CloseCB( self, button ):
		print 'DialogTestWindow.CloseCB called'
		vp.theApplication.Quit()


	def CB( self, dialog ):
		print 'DialogTestWindow.CB called'

		from MiscDialogs import FileSelectionDialog, PromptDialog

		if dialog.IsA( FileSelectionDialog ):
			print dialog.GetFilename() 

		elif dialog.IsA( PromptDialog ):
			print dialog.GetText()

	
# -------------------------------------------------------------------------
# Test function

def test():
	app = Application('DialogTest')
	win = DialogTestWindow()
	app.Run()

test()
	
