import vp

from Application     import Application
from Window          import Window
from Canvas          import Canvas
from WidgetButton    import PushButton
from Datum           import Add

def MouseDownEH( target, client_data, xevent, e ):
	print 'MouseDownEH: target =', target.GetName()
	target.MouseDownEH( target, client_data, xevent, e )

def Mouse2DragEH( target, client_data, xevent, e ):
	print 'Mouse2DragEH: target =', target.GetName()
	target.Mouse2DragEH( target, client_data, xevent, e )


# -------------------------------------------------------------------------
# Test function

def test():
	app = Application( 'test' )
	win = Window()

	canvas = Canvas({ 'size': (400,400) })
	win.AddWorkArea( canvas )
	canvas.Subscribe( vp.MOUSE2_DRAG, Mouse2DragEH, None )

	dragbutton = PushButton()
	dragbutton['background'] = 'azure'
	dragbutton['name']       = 'DragMe'
	dragbutton['pos']        = (0,100)
	dragbutton['draggable']  = vp.TRUE

	canvas.AddChild( dragbutton )
	dragbutton.Subscribe( vp.MOUSE_DOWN, MouseDownEH, None )

	resizebutton = PushButton({ 
		  'name'     : 'ResizeMe',
		  'pos'      : (100,50),
		  'editmode' : vp.TRUE
		  })
	canvas.AddChild( resizebutton )

	button2 = PushButton({ 'name': 'I\'m constrained' })
	canvas.AddChild( button2 )

	# set the constraints

	ydelta = Add( dragbutton.y, 100 )
	ydelta.LinkTo( button2.y )
	dragbutton.x.LinkTo( button2.x )

	resizebutton.width.LinkTo( dragbutton.width )
	resizebutton.height.LinkTo( dragbutton.height )
	resizebutton.width.LinkTo( button2.width )
	resizebutton.height.LinkTo( button2.height )

	app.Run()

test()
