import vp

from Application    import Application
from Window         import Window
from Canvas         import Canvas
from Box            import Box
from Rectangle      import Rectangle
from TextPrimitive  import TextPrimitive
from Circle         import Circle
from WidgetButton   import PushButton

# -------------------------------------------------------------------------
# Test function: check that the bounding box of TextPrimitive is correct.

def test():
	app = Application( 'test' )
	win = Window()
	win.SetMessage( 'The box can be dragged and resized' )
	canvas = Canvas({ 
		'size'          : (300, 300 ),
		'selection_rect': vp.TRUE, 
		'xres'          : {'background': 'grey80'}
		})
	win.AddWorkArea( canvas )

##	c2 = Canvas({ 
##		'size'     : (100,120),
##		'editmode' : vp.TRUE, 
##		'draggable': vp.TRUE,
##		'xres'     : {'background': 'yellow'}
##		})
##	canvas.AddChild( c2 )
##
##	c2.AddChild( PushButton({
##		'name': 'EditMe',
##		'draggable': vp.TRUE,
##		'editmode': vp.TRUE
##		}))
##	c2.AddChild( Circle({
##		'pos': (30,30),
##		'diameter': 50, 
##		'fill': vp.TRUE, 
##		'outline':vp.TRUE 
##		}))
##	c2.AddChild( Rectangle({
##		'pos': (30,90),
##		'size': (30,40),
##		'fill':vp.TRUE,
##		'outline':vp.TRUE
##		}))

	# Create a draggable box with various objects inside it

	box = Box({
		'pos'       : (100,120),
		'draggable' : vp.TRUE,
		'editmode'  : vp.TRUE,
		'alignment' : vp.VCENTER, 
		'xres'      : {'background': 'LightBlue'},
		'child_list': [
			TextPrimitive({ 'string': 'Per Spilling' }), 
			PushButton({ 'name': 'Monty Python' }),
			Circle({'diameter': 50, 'fill': vp.TRUE, 'outline':vp.TRUE }),
			TextPrimitive({ 'string': 'Dirk Soede' }),
			Rectangle({'size': (30,40),'fill':vp.TRUE,'outline':vp.TRUE})
			]
		})
	canvas.AddChild( box )

	app.Run()


test()


		
		
		
		


		
		

			  
