import vp

from Application  import Application
from Window       import ScrolledWindow
from Canvas       import Canvas
from Lines        import Arrow
from Circle       import Circle
from Datum        import Subtract

# -------------------------------------------------------------------------
# Test functions

def test():
	app = Application( 'test' )
	win = ScrolledWindow({ 'size': (600, 500) })

	# Add a workarea to the window

	view = Canvas({ 'size': (1000, 1000) })
	win.AddWorkArea( view )
	win.SetMessage( 'Drag the circle with the middle-mouse-button to rotate the arrow' )

	# Create an arrow and link it to a draggable object

	arrow = Arrow({ 'begin': (200,200), 'end': (300,200) })
	view.AddChild( arrow )

	circle = Circle({ 'pos': (300,200), 'diameter': 30, 'draggable': vp.TRUE })
	view.AddChild( circle )

	circle.x.LinkTo( Subtract(arrow.ex, circle.diameter/2) )
	circle.y.LinkTo( Subtract(arrow.ey, circle.diameter/2) )
	
	app.Run()


test()
