# -------------------------------------------------------------------------
# Module:   point.py
#
# DESCRIPTION: 
#     Simple module to manipulate 2D points
#   
# AUTHOR:
#     Dirk Soede <soede@cwi.nl>, CWI, Amsterdam.

from math import *

def subtract(p1, p2):
	return (p1[0] - p2[0], p1[1] - p2[1])


def add(p1, p2):
	return (p1[0] + p2[0], p1[1] + p2[1])


def ortho(p):
	return(-p[1], p[0])


def length(p):
	return sqrt(p[0]*p[0] + p[1]*p[1])


def dotproduct(p1, p2):
	return p1[0]*p2[0] + p1[1]*p2[1]


def multiply(p, v):
	return(p[0]*v, p[1]*v)


def is_point_on_line(pnt, (begin, end), epsilon):
	#
	# Calculate whether `pnt' is within distance epsilon of line
	# segment between begin and end.
	#
	# Calculate the projected point on the line by:
	#    proj_pnt = begin + ((pnt-begin) o ub) ub where ub is the
	# direction vector of the line.

	b     = subtract(end, begin)
	len_b = length(b)

	if len_b != 0:
		ub    = multiply(b, 1.0/len_b)
		dpr   = dotproduct(subtract(pnt, begin), ub)

		# First check whether the point is within the segment. This is true 
		# when:
		#   0 <= dpr <= len_b. (below the epsilon represents the tolerance)
		# Then see if the point is close enough to the line.

		if dpr >= -epsilon and dpr <= (len_b + epsilon):
			proj_pnt = add(begin, multiply(ub, dpr))
			if abs(length(subtract(proj_pnt, pnt))) < epsilon:
				return 1
	return 0


def test():
	is_point_on_line( (1.2,2), ((0,0), (2,4)), 0.3)
