# -------------------------------------------------------------------------
# MODULE:      Xcb
#
# DESCRIPTION: 
#     Contains functions for unpacking callback data structs from X
#   
# AUTHOR:
#     Per Spilling <per@cwi.nl>, CWI, Amsterdam.


import struct 

class _CallbackStruct:
	def init( self ):
		return self

	def UnpackCBS( self, fmt, names, call_data ):
		size  = struct.calcsize( fmt )
		tuple = struct.unpack( fmt, call_data[:size] )

		for i in range(len(tuple)):
			setattr(self, names[i], tuple[i])
	

# -------------------------------------------------------------------------
# FUNCTION: mklist_cbs
#
# DESCRIPTION:
#     Can be used to unpack XmListCallbackStruct items.

LCBStuple = 'illiiliii', \
          'reason', 'event', 'item', 'item_length', \
		  'item_position', 'selected_items', \
          'selected_item_count', 'selected_item_positions', \
          'selection_type'

class _XmListCallbackStruct( _CallbackStruct ):
	def init(self, call_data):
		self = _CallbackStruct().init()

		fmt, names = LCBStuple[0], LCBStuple[1:]
		self.UnpackCBS( fmt, names, call_data )

		return self

def mklist_cbs(call_data):
	return _XmListCallbackStruct().init(call_data)


# -------------------------------------------------------------------------
# FUNCTION: mkfilesel_cbs
#
# DESCRIPTION:
#     Can be used to unpack XmFileSelectionCallbackStruct items.

FSCBStuple = 'illililili', \
	        'reason', 'event', 'value', 'length', \
			'mask', 'mask_length', 'dir', 'dir_length', \
			'pattern', 'pattern_length'

class _XmFileSelectionCallbackStruct( _CallbackStruct ):
	def init( self, call_data ):
		self = _CallbackStruct().init()

		fmt, names = FSCBStuple[0], FSCBStuple[1:]
		self.UnpackCBS( fmt, names, call_data )
		
		return self

def mkfilesel_cbs(call_data):
	return _XmFileSelectionCallbackStruct().init(call_data)


