# -------------------------------------------------------------------------
# MODULE:  TypeInfo
#
# DESCRIPTION: 
#     Contains some utility functions for accessing various types of class
#     information (methods, instance attributes, possible method name clashes,
#     etc.).
#
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, per@cwi.nl

from newdir import is_function
from vp     import TRUE, FALSE

# -------------------------------------------------------------------------
# Type-check utility funtions:

def hasclass(object, type):
	if not hasattr( object, '__class__' ):
		return FALSE
	else:
		return _hasclass(object.__class__, type)


def _hasclass(classobj, type):
	if classobj == type:
		return TRUE

	for base in classobj.__bases__:
		  res = _hasclass(base, type)
		  if res == TRUE:
			  return TRUE

	return FALSE

IsA  = hasclass
_IsA = _hasclass

def IsList( obj ):
	return type(obj) == type([])

class dummy:
	def fun( self ):
		pass

class subdummy( dummy ):
	fun = dummy.fun


def IsUnboundMethod( obj ): return type(obj) == type(subdummy.fun)

def IsMethod( obj ): return is_function(obj) or IsUnboundMethod(obj)

def IsClass( obj ): return type(obj) == type(dummy)

def IsObject( obj ): return hasattr( obj, '__class__' )

	

# -------------------------------------------------------------------------
# Public methods:

def PrintAllMethods( obj ):
	mdict = GetAllMethods( obj )
	print 'The methods of', obj.__class__.__name__, 'are:'
	
	for key in mdict.keys():
		print '    -', key, '=', mdict[key]


def PrintAmbiguousMethods( obj ):
	mdict = GetAllMethods( obj )
	keys  = mdict.keys()
	keys.sort()

	print 'Possibly ambiguous methods of', obj.__class__.__name__, 'are:'
	
	for key in keys:
		if IsList(mdict[key]):
			print '    -', key, ':'
			for item in mdict[key]:
				str = item[0].__name__ + '.' + key
				print '        ', str
	

def GetAllMethods( obj ):
	mdict = {}
	for key in obj.__dict__.keys():
		if IsMethod( obj.__dict__[key] ):
			mdict[key] = (obj.__class__,obj.__dict__[key])

	print 'GetAllMethods: obj.__class__..__dict__ ='
	for key in obj.__class__.__dict__.keys():
		print '    +', obj.__class__.__dict__[key]

	_GetMethods( obj.__class__, mdict )
	return mdict


def _GetMethods( class_obj, return_dict ): 
	for key in class_obj.__dict__.keys():
		if IsMethod( class_obj.__dict__[key] ):
			if key in return_dict.keys():

				if IsList(return_dict[key]):
					found = 0
					for item in return_dict[key]:
						if class_obj.__dict__[key] == item[1]:
							found = 1
							break
					if not found:
						return_dict[key].append( (class_obj,class_obj.__dict__[key]) )

				elif not IsList(return_dict[key]) and \
					  class_obj.__dict__[key] != return_dict[key][1]:
					return_dict[key] = [return_dict[key], 
						                (class_obj,class_obj.__dict__[key])]

			else:
				return_dict[key] = (class_obj,class_obj.__dict__[key])

	for base in class_obj.__bases__:
		_GetMethods( base, return_dict )


def GetFilenameFromClassObj( co ):  # -> fname
	fname = ''
	if co != None:
		for key in co.__dict__.keys():
			if is_function( co.__dict__[key] ):
				fname = co.__dict__[key].func_code.co_filename
				break

	return fname


rxdot = None

def GetModuleFromFilename( fname ): # -> (path, modname)
	import posixpath
	global rxdot

	(path, fname) = posixpath.split(fname)
	if rxdot == None: 
		import regex
		rxdot = regex.compile( '\.' )
	return (path, fname[:rxdot.search(fname)])

