# -------------------------------------------------------------------------
# MODULE: TreeNode
#
# DESCRIPTION: 
#     Contains the TreeNode class
#
# AUTHOR:
#     Dirk Soede & Per Spilling, CWI, Amsterdam, per@cwi.nl

import vp

from vp     import TRUE, FALSE
from Object import Object

debug       = FALSE
debug_final = FALSE

# -------------------------------------------------------------------------
# CLASS:         TreeNode
#
# INHERITS FROM: Object
#
# DESCRIPTION: 
#     Provides functionality needed for tree-datastructures.
#

class TreeNode( Object ):

	# ------------------------------------------------------------------
	# Class attributes

	visited = []

	# ------------------------------------------------------------------
	# Constructor & destructor.

	def __init__(self, argdict = {}):
		if hasattr( self, 'parent' ):        # already initialized
			return

		self.parent = None
		self.root   = self

		self.ProcessArgs( argdict )

		if hasattr( self, 'leaf_node_only' ):
			self.children = None
		else:
			self.children = []


	def Finalize( self ):
		if debug_final:
			print 'TreeNode.Finalize called for', self.GetClassName()

		if self.children != None:
			for child in self.children[:]:    # make a tmp copy of list
				child.Finalize()

		if self.parent != None:
			self.parent.RemoveChild( self )
		self.root = None
		Object.Finalize( self )


	# ------------------------------------------------------------------
	# Child management.

	def InitAddedNode(self, child):
		if debug: print 'TreeNode.InitAddedNode: child =', child

		child.parent = self
		child.SetRoot(self.root)


	def AddChild(self, child):
		if self.children != None:
			self.children.append(child)
			self.InitAddedNode(child)
		else:
			print 'TreeNode.AddChild:', \
				  self.GetName(), 'can be a leaf-node only!'


	def AddChildAfter(self, child, pred):
		if self.children != None:
			if pred != None:
				pos = self.children.index(pred) + 1
			else:
				pos = 0
			self.children.insert(pos, child)
			self.InitAddedNode(child)
		else:
			print 'TreeNode.AddChildAfter:', \
				  self.GetName(), 'can be a leaf-node only!'
		

	def AddChildBefore(self, child, succ):
		if self.children != None:
			if succ != None:
				pos = self.children.index(succ) 
			else:
				pos = 0
			self.children.insert(pos, child)
			self.InitAddedNode(child)
		else:
			print 'TreeNode.AddChildBefore:', \
				  self.GetName(), 'can be a leaf-node only!'


	def RemoveChild(self, child):
		if self.children != None:
			self.children.remove(child)
			child.SetParent(None)
			child.SetRoot(child)
		else:
			print 'TreeNode.RemoveChild:', \
				  self.GetName(), 'can be a leaf-node only!'

			
	# ------------------------------------------------------------------
	# Modify

	def SetParent(self, parent): self.parent = parent


	def SetRoot(self, root):
		if self.root != root:
			self.root = root
			if self.children != None:
				for child in self.children:
					child.SetRoot(root)


	# ------------------------------------------------------------------
	# PreOrder and PostOrder traversal.

	def CollectPreOrder(self):
		nodes = [self]
		if self.children != None:
			for child in self.children:
				nodes = nodes + child.CollectPreOrder()
		return nodes


	def CollectPostOrder(self):
		nodes = []
		if self.children != None:
			for child in self.children:
				nodes = nodes + child.CollectPostOrder()
		nodes.append(self)
		return nodes


	def CollectInOrder( self ):
		nodes = []
		if self.IsLeaf():
			nodes.append(self)
		else:
			nodes = nodes + self.children[0].CollectInOrder()
			nodes.append( self )
			if len(self.children) > 1:
				for child in self.children[1:]:
					nodes = nodes + child.CollectInOrder()
		return nodes


	# ------------------------------------------------------------------
	# Queries.

	def IsRoot(self): return self.GetRoot() is self

	def IsLeaf(self): return self.children == None or len(self.children) == 0

	def IsLeafOnly( self ): return self.children == None

	def IsAncestorOf( self, other ):
		if self.children != None:
			if other in self.children:
				return TRUE
			else:
				for child in self.children:
					if child not in self.visited:
						return child.IsAncestorOf( other )
				return FALSE
		else:
			return FALSE


	def FindNode( self, attr, val ):
		#
		# Search through the tree for a particular node with an attribute 
		# 'attr' with the value 'val'
		#
		if hasattr( self, attr ) and getattr( self, attr ) == val:
			return self
		else:
			for child in self.children:
				node = child.FindNode( attr, val )
				if node != None:
					return node
		return None


	def GetRoot(self): return self.root

	def GetParent(self): return self.parent

	def GetCommonParent( self, other ):
		if self != other:
			TreeNode.visited = [self]    # 'visited' is a class attribute
			return self.parent._GetCommonParent( other )
		else:
			return None


	def _GetCommonParent( self, other ):
		if self.IsAncestorOf( other ):
			return self
		else:
			self.visited.append( self )
			if type(self) == type(self.parent):
				return self.parent._GetCommonParent( other )
			else:
				return None
			

	def GetPrevSibling(self):
		if self.parent == None:
			return None
		i = self.parent.children.index(self)
		if i > 0:
			return self.parent.children[i - 1]
		else:
			return None


	def GetNextSibling(self):
		if self.parent == None:
			return None
		i = self.parent.children.index(self)
		if i < len(self.parent.children) - 1:
			return self.parent.children[i + 1]
		else:
			return None


	def GetIndex(self):
		if self.parent == None:
			return None
		return self.parent.children.index(self)


	def GetChildren(self):
		if self.children != None:
			return self.children[:]
		else:
			return None


	def GetChildCount(self):
		if self.children != None:
			return len(self.children)
		else:
			return 0


	def HasChildren(self):
		return self.children != None and len(self.children) > 0


	# ------------------------------------------------------------------
	# Printing
	
	def PrintTree( self, *indent ):
		if indent != ():
			indent = indent[0]
		else:
			indent = 0
		print indent * ' ',
		print self.GetName()
		if self.children != None:
			for child in self.children:
				child.PrintTree( indent + 4 )


# -------------------------------------------------------------------------
# Test function


def test():
	count = 1
	ndict = {}

	ndict[count] = TreeNode({ 'name': `count` })

	for i in range(3):
		count = count + 1
		ndict[count] = TreeNode({ 'name': `count` })
		ndict[1].AddChild( ndict[count] )

	for i in range(2):
		count = count + 1
		ndict[count] = TreeNode({ 'name': `count` })
		ndict[3].AddChild( ndict[count] )

	count = count + 1
	ndict[count] = TreeNode({ 'name': `count` })
	ndict[4].AddChild( ndict[count] )

	for i in range(2):
		count = count + 1
		ndict[count] = TreeNode({ 'name': `count` })
		ndict[5].AddChild( ndict[count] )
		
	count = count + 1
	ndict[count] = TreeNode({ 'name': `count` })
	ndict[6].AddChild( ndict[count] )

	ndict[1].PrintTree()

	print '******** preorder *********'
	for node in ndict[1].CollectPreOrder(): print node.GetName()

	print '******** postorder ********'
	for node in ndict[1].CollectPostOrder(): print node.GetName()

	print '******** inorder *********'
	for node in ndict[1].CollectInOrder(): print node.GetName()
