# -------------------------------------------------------------------------
# MODULE:      TextPrimitive
#
# DESCRIPTION: 
#     Contains the TextPrimitive class.
# 
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, <per@cwi.nl>

import vp

from Primitive import Primitive
from Datum     import Datum

debug = vp.FALSE

# -------------------------------------------------------------------------
# CLASS:         TextPrimitive
#
# INHERITS FROM: Primitive : Graphic : (TreeNode,DatumDict) : Object
#
# DESCRIPTION:
#

class TextPrimitive( Primitive ):

	# ------------------------------------------------------------------
	# Init methods

	def __init__( self, argdict = {}):
		#
		# Args can be:
		# - 'string': <string>   default=''
		# - 'font'  : <fontname> default=None, i.e. use the default font
		#
		self.fobj = vp.theDefaultFont

		argdict = self.MergeDefaults(argdict, {
			  'string': '',
			  'font'  : None
			  })
		Primitive.__init__( self, argdict )

		if self.font == None:
			self.SetXResources({ 'font': self.fobj.GetFont() })

		self.UpdateSizeCB(None)


	def AddDatums(self):
		#
		# Add a datum to contain the string and make the 'width' datum update
		# itself when the 'string' datum changes.
		#
		Primitive.AddDatums(self)

		self.AddDatum('string', Datum( self.GetName() ))
		self.AddFunctionDatum('update_size_cb', self.UpdateSizeCB)
		self.string.LinkTo( self.update_size_cb )
		

	# ------------------------------------------------------------------
	# Public methods:

	def SetFont( self, fontname ):
		import Font
		self.fobj = Font.FindFont( fontname ) 
		self.SetXResources({ 'font': self.fobj.GetFont() })
		self.UpdateSizeCB( None )


	# ------------------------------------------------------------------
	# Datum callbacks:

	def UpdateSizeCB( self, value ):
		size       = self.fobj.GetStringSize( self.string.value )
		self.ascent = self.fobj.GetAscent()
		self.SetSize( size[0], size[1] )
		self.SetNaturalSize( size[0], size[1] )
		

	# ------------------------------------------------------------------
	# Drawing methods:

	def _Redraw( self ):
		self.GetGC().DrawString( self.wc_x.value, 
			                     self.wc_y.value + self.ascent, 
								 self.string.value )


