# -------------------------------------------------------------------------
# MODULE:      Rectangle
#
# DESCRIPTION: 
#     Contains rectangle Primitive class.
#
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, <per@cwi.nl>

import vp

from Primitive import Primitive

debug = vp.FALSE


# -------------------------------------------------------------------------
# CLASS:         Rectangle
#
# INHERITS FROM: Primitive : Graphic : (TreeNode,DatumDict) : Object
#
# DESCRIPTION:
#

class Rectangle( Primitive ):

	# ------------------------------------------------------------------
	# Init methods

	def __init__( self, argdict = {}):  
		#
		# Args can be the following: 
		# - 'name'     : <string> (this will produce a labeled rectangle)
		# - 'pos'      : (<int>, <int>) (0,0)=default
		# - 'size'     : (<int>, <int>) (10,10)=default
		# - 'fill'     : <bool> (vp.FALSE=default)
		# - 'outline'  : <bool> (vp.FALSE=default)
		# - 'show_name': <bool> (vp.FALSE=default)
		#
		argdict = self.MergeDefaults(argdict, {
			  'pos'      : (0,0),
			  'size'     : (10,10),
			  'fill'     : vp.FALSE,
			  'outline'  : vp.FALSE,
			  'show_name': vp.FALSE
			  })
		Primitive.__init__( self, argdict )

		if not 'line_width' in self.xresources.keys():
			self.SetXResources({ 'line_width': 1 })


	def CreatePrimitive( self ):
		#
		# set fpointer to the real redraw method
		#
		if hasattr( self, 'name' ) and self.show_name == vp.TRUE:
			self.lsize = vp.theDefaultFont.GetStringSize( self.name )
			if self.fill and self.outline:
				self._Redraw = self._RedrawFOL
			elif self.fill:
				self._Redraw = self._RedrawFL
			else:
				self._Redraw = self._RedrawL
		else:
			if self.fill and self.outline:
				self._Redraw = self._RedrawFO
			elif self.fill:
				self._Redraw = self._RedrawF

		self.Redraw = self._Redraw     

		if self.fill and not self.xresources.has_key('foreground'):
			self.SetXResources({ 'foreground': 'bisque' }) # default fill color

		self.canvas = self.GetCanvas()
		self.canvas.AddToDisplayList( self )    

		self.realized = vp.TRUE


	# ------------------------------------------------------------------
	# Drawing methods:

	def _Redraw( self ):
		#
		# The rectangle should be drawn so that it stays inside the bbox.
		#
		lw = self.xresources['line_width']
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		if lw > w: lw = w
		if lw > h: lw = h
		self.GetGC().DrawRectangle(x + lw/2, y + lw/2, w - lw, h - lw )

	def _RedrawF( self ):
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		self.GetGC().FillRectangle( x,  y, w, h )


	def _RedrawFO( self ):
		lw = self.xresources['line_width'] 
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		if lw > w: lw = w
		if lw > h: lw = h
		self.GetGC().FillRectangle( x,  y, w, h )
		self.GetOLGC().DrawRectangle( x + lw/2, y + lw/2,
					      w - lw, h - lw )


	def _RedrawL( self ):
		lw = self.xresources['line_width'] 
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		if lw > w: lw = w
		if lw > h: lw = h
		self.GetGC().DrawRectangle(x + lw/2, y + lw/2, w - lw, h - lw)
		self.GetOLGC().DrawString( 
			  x + w/2 - self.lsize[0]/2, 
			  y + h/2 + self.lsize[1]/2, 
			  self.name )


	def _RedrawFL( self ):
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		self.GetGC().FillRectangle( x,  y, w, h )
		self.GetOLGC().DrawString( 
			  x + w/2 - self.lsize[0]/2, 
			  y + h/2 + self.lsize[1]/2, 
			  self.name )



	def _RedrawFOL( self ):
		lw = self.xresources['line_width']
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		if lw > w: lw = w
		if lw > h: lw = h
		self.GetGC().FillRectangle( x, y, w, h )
		self.GetOLGC().DrawRectangle( x + lw/2, y + lw/2,
					      w - lw, h - lw )
		self.GetOLGC().DrawString( 
			  x + w/2 - self.lsize[0]/2, 
			  y + h/2 + self.lsize[1]/2, 
			  self.name )
