# -------------------------------------------------------------------------
# MODULE: Object
#
# DESCRIPTION: 
#     Contains the root class (Object) of the vpApp/vpGen framework. In
#     addition, it contains some utilities used in the framework.
#
# AUTHOR:
#     Per Spilling <per@cwi.nl>, CWI, Amsterdam.

from vp       import TRUE, FALSE
from TypeInfo import _hasclass

debug       = FALSE
debug_final = FALSE

# -------------------------------------------------------------------------
# CLASS:         Object
#
# INHERITS FROM: None
#
# DESCRIPTION: 
#     The root class of the vpGen/vpApp framework.
#

class Object:

	# ------------------------------------------------------------------
	# Constructor, argument handling methods, & finalization:

	def __init__( self, argdict = {} ):
		self.ProcessArgs( argdict )


	def ProcessArgs( self, argdict ):
		if debug:
			print 'Object.ProcessArgs: argdict =', argdict

		for key in argdict.keys():
			if key == 'name':
				self.SetName( argdict[key] )
			else:
				setattr( self, key, argdict[key] )


	def MergeDefaults(self, argdict, defaults):
		#
		# A dict of defaults is added to the argdict dict. The defaults will 
		# be removed when argdict defines a value for an attribute.
		# 
		for key in argdict.keys():
			defaults[key] = argdict[key]

		return defaults


	def __del__( self ):
		if debug_final:
			print self.GetName(), 'deleted'


	def Finalize( self ):
		#
		# Method which should be used in subclasses to do cleanup 
		#
		if debug_final: print 'Object.Finalize called for', self.GetName()

		self.ExecuteCallback('deleted', self) # warn dependents about deletion
		del self


	# ------------------------------------------------------------------
	# Callback support:

	def AddCallback( self, cb_type, cb_handler ):
		#
		# This method can be used to install a callback-method or a
		# callback-function. The signature of the callback-method/function
		# should be:
		#
		# <callback>( <self>, <cb_data> )  - callback-method
		# <callback>( <cb_data> )          - callback-function
		#
		if not hasattr( self, 'cb_dict' ): self.cb_dict = {}

		if self.cb_dict.has_key( cb_type ) and \
			  cb_handler not in self.cb_dict[cb_type]:
			self.cb_dict[cb_type].append( cb_handler )
		else:
			self.cb_dict[cb_type] = [cb_handler]


	def RemoveCallback( self, cb_type, cb_handler ):
		if self.cb_dict.has_key( cb_type ) and \
			  cb_handler in self.cb_dict[cb_type]:
			self.cb_dict[cb_type].remove( cb_handler )


	def ExecuteCallback( self, cb_type, cb_data ):
		if hasattr( self, 'cb_dict' ) and \
			  cb_type in self.cb_dict.keys() and self.cb_dict[cb_type] != None:
			for cb in self.cb_dict[cb_type]:
				cb( cb_data )


	# ------------------------------------------------------------------
	# Modifying methods:

	def SetName( self, name ): self.name = name


	# ------------------------------------------------------------------
	# Access methods:

	def GetClassAttrs( self ): return self.__class__.__dict__.keys()

		
	def GetInstanceAttrs( self ): return self.__dict__.keys()

		
	def GetClassName( self ): return self.__class__.__name__


	def GetName( self ):
		if hasattr( self, 'name' ):
			return self.name
		else:
			return self.__class__.__name__


	# ------------------------------------------------------------------
	# Query methods:

	def IsA( self, type ): return _hasclass( self.__class__, type )

	
	# ------------------------------------------------------------------
	# Misc public methods:

	def PrintInstanceAttrs( self ):
		print 'Attributes of', self.GetName()

		for attr in self.GetInstanceAttrs():
			print '    -', attr, '=', getattr( self, attr )

