# -------------------------------------------------------------------------
# MODULE:      NewControl
#
# DESCRIPTION: 
#     Contains the Control and WidgetControl classes.
#
# USAGE:
#

import Xm, Xmd, X

import vp

from WidgetObject import WidgetObject

debug       = vp.FALSE
debug_final = vp.FALSE

# -------------------------------------------------------------------------
# CLASS:         Control
#
# INHERITS FROM: None
#
# DESCRIPTION: 
#     A mixin class for all Control classes.
#

class Control:

	super = WidgetObject   # default 'super' class

	# ------------------------------------------------------------------
	# Initialization methods

	def __init__( self, argdict = {} ):    
		#
		# Args can be the following: 
		# - 'name'          : <string>
		# - 'callback'      : <activate-callback function/method instance>
		# - 'command'       : <command instance>
		#
		self.enabled  = vp.TRUE
		self.callback = None
		self.command  = None

		self.super.__init__( self, argdict )

		if self.command != None:
			self.command.Register( self )
			self.name = self.command.GetName()

		elif self.callback != None:
			self.super.AddCallback( self, 'activate', self.callback )
		

	def InitWidget( self ):
		if not self.IsRealized():
			self.super.InitWidget( self )

		if self.enabled:
			self.Enable()
		else:
			self.Disable()


	def Finalize( self ):
		if debug_final:
			print 'Control.Finalize called for', self.GetClassName()

		if self.command != None:
			self.command.UnRegister( self )

		self.command  = None
		self.callback = None

		self.super.Finalize( self )


	def ProcessArgs( self, argdict ):
		for key in argdict.keys():
			if key in ['callback', 'command']:
				setattr( self, key, argdict[key] )
				del argdict[key]

		self.super.ProcessArgs( self, argdict )

		
	# ------------------------------------------------------------------
	# Command related methods

	def Enable( self ):
		if debug:
			print self.GetName(), 'enabled'

		if hasattr( self, 'w'): self.w.SetSensitive( X.TRUE )
		self.enabled = vp.TRUE
		

	def Disable( self ):
		if debug:
			print self.GetName(), 'disabled'

		if hasattr( self, 'w'): self.w.SetSensitive( X.FALSE )
		self.enabled = vp.FALSE

		
	# ------------------------------------------------------------------
	# Misc. 'protected' methods, i.e. methods which should only be used
	# by subclasses.

	def Execute( self ):
		#
		# Execute a command or call a callback method/function
		#
		if debug:
			print 'Control', self.GetName(), 'activated'
			
		if self.command != None:
			self.command.Execute()
		else:
			self.ExecuteCallback( 'activate', self )


	# ------------------------------------------------------------------
	# Access methods

	def GetCommand( self ): return self.command

	

