# -------------------------------------------------------------------------
# MODULE:      Inspector
#
# DESCRIPTION: 
#     Contains the Inspector class.
# 
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, per@cwi.nl
#

import vp

from Object       import Object
from Window       import Window
from Box          import Box, EqualSizeBox, Glue, HVGlue
from WidgetButton import PushButton
from MiscGraphic  import Label
from TextControls import TextField
from Menu         import OptionMenu
from Frame        import Frame

class Inspector( Window ):

	def __init__( self ):
		Window.__init__( self, {
			  'name'  : 'Inspector', 
			  'layout': vp.MWC
			  })
		self.attrs  = ['name', 'pos', 'size', 'xres', 'draggable', 'editmode']
		self.fields = {}

		self.AddWorkArea( Box({ 
		    'child_list': [
				self._CreateLabelBox(),
			    self._CreateTextFieldBox()
				]
			}))
		self.AddCommandArea( self._CreateCommandArea() )
		self.SetMessage( 'Class type:' )
		self.Show()


	def _CreateTextFieldBox( self ):
		fbox = Box({ 
			  'alignment'     : vp.VCENTER,
			  'stretchability': (vp.ELASTIC, vp.FIXED)
			  })
		for name in self.attrs:
			tf = TextField({ 'characters': 25 })
			self.fields[name] = tf
			fbox.AddChild( tf )
		return fbox


	def _CreateLabelBox( self ):
		lbox = Box({
			  'alignment'     : vp.VRIGHT,
			  'stretchability': (vp.FIXED, vp.ELASTIC)
			  })
		for name in self.attrs:
			lbox.AddChild( Label({ 
				  'name'          : name+':',
				  'stretchability':(vp.FIXED, vp.ELASTIC)
				  }))
		return lbox

						
	def _CreateCommandArea( self ):
		self.abut = PushButton({ 
			  'name'          : 'Apply',    
			  'callback'      : self.ApplyCB,
			  'enabled'       : vp.FALSE,
			  'stretchability': (vp.ELASTIC, vp.FIXED)
			  })
		self.dbut = PushButton({ 
			  'name'          : 'Dismiss',    
			  'callback'      : self.DismissCB,
			  'stretchability': (vp.ELASTIC, vp.FIXED)
			  })
		return Box({
		    'alignment' : vp.VCENTER,
			'child_list': [
			    Glue( 5, vp.FIXED ),
				EqualSizeBox({
				    'child_list': [
					    Glue( 5, vp.ELASTIC ),
						self.abut,
						Glue( 5, vp.ELASTIC ),
						self.dbut,
						Glue( 5, vp.ELASTIC )
						] 
					}),
				Glue( 5, vp.FIXED )
				]
			})


	def Show( self ):
		vp.theSelection.AddSelectionCallback( self.ObjectSelectedCB )
		Window.Show( self )


	def Hide( self ):
		vp.theSelection.RemoveSelectionCallback( self.ObjectSelectedCB )
		Window.Hide( self )
		

	# ------------------------------------------------------------------
	# Callbacks for user input.

	def MenuCB( self, menu_item ): pass


	def ApplyCB( self, menu_item ): 
		for attr in self.attrs:
			self._Apply( attr, self.fields[attr].GetText() )


	def _Apply( self, attr, val ): 
		print 'Apply:', attr, val

		if attr == 'name' and type(val) == type(''):
			self.curr_graphic.SetName( val )

		elif attr == 'size':
			s = eval(val)
			if type(s) == type(()): 
				self.curr_graphic.SetSize( s[0], s[1] )

		elif attr == 'pos':
			p = eval(val)
			if type(p) == type(()):
				self.curr_graphic.SetPosition( p[0], p[1] )

		elif attr == 'xres':
			xr = eval(val)
			if type(xr) == type({}):
				self.curr_graphic.SetXResources( xr ) 

		elif attr == 'draggable':
			b = eval(val)
			if b in [0,1]:
				self.curr_graphic.SetDraggable( b )

		elif attr == 'editmode':
			b = eval(val)
			if b in [0,1]:
				self.curr_graphic.SetEditMode( b )


	def DismissCB( self, menu_item ): self.Hide()


	# ------------------------------------------------------------------
	# Public methods

	def ObjectSelectedCB( self, graphic ):
		self.curr_graphic = graphic
		self.curr_name    = graphic.GetName()

		self.SetMessage( 'Class type: ' + graphic.GetClassName() )
		self.fields['name'].SetText( graphic.GetName() )
		self.fields['pos'].SetText( `graphic.GetPosition()` )
		self.fields['size'].SetText( `graphic.GetSize()` ) 
		self.fields['xres'].SetText( `graphic.xresources` )
		self.fields['draggable'].SetText( `graphic.draggable` )
		self.fields['editmode'].SetText( `graphic.editmode` )

		self.abut.Enable()

		
