# -------------------------------------------------------------------------
# MODULE:      Composite
#
# DESCRIPTION: 
#     Contains the Composite class.
#
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, per@cwi.nl
#  

import X, EventNotifier, vp

from EventNotifier import debugswitch
from Object        import Object
from Mixin         import Mixin

ds = debugswitch
debug = vp.FALSE

# -------------------------------------------------------------------------
# CLASS:         Composite  {mixin}
#
# INHERITS FROM: Mixin
#
# DESCRIPTION: 
#     A mixin class which adds support for display-lists and event-dispatch
#     to Primitive (non-widget-based) children. The class assumes that the
#     subclass also inherits from the Responder class.
#

class Composite( Mixin ):

	# ------------------------------------------------------------------
	# Init methods 

	def __init__( self, argdict = {} ):
		self.display_list     = []      # used by Primitives
		self.prim_events      = {}      # ----- ,, -----
		self.own_events       = []
		self.do_redraw        = 0        
		self.Redraw           = self._NoRedraw
		self.did_first_expose = vp.FALSE

		apply(self.GetSuperAttr(Composite, '__init__'), (self, argdict))


	def Realize( self ):
		#
		# Only WidgetObjects, i.e. Canvas, need to subscribe to EXPOSE events.
		#
		if hasattr( self, 'w' ) and not self.DidSubscribe( vp.EXPOSE ): 
			self.Subscribe( vp.EXPOSE, self.ExposeEH, None ) 

		# the following is needed to get SubscribePrimitive to work properly

		if not self.DidSubscribe( vp.MOUSE_DOWN ): 		
			self.SetEH( vp.MOUSE_DOWN, self.MouseDownEH, None )

		if not self.DidSubscribe( vp.MOUSE1_DRAG ): 
			self.SetEH( vp.MOUSE1_DRAG, self.Mouse1DragEH, None )

		if not self.DidSubscribe( vp.MOUSE2_DRAG ): 
			self.SetEH( vp.MOUSE2_DRAG, self.Mouse2DragEH, None )

		if not self.DidSubscribe( vp.MOUSE_UP ): 
			self.SetEH( vp.MOUSE_UP, self.MouseUpEH, None )

		self.GetSuperAttr( Composite, 'Realize' )( self )


	# ------------------------------------------------------------------
	# Private methods:

##	def GetPixmap( self ):
##		if not hasattr( self, '_pixmap' ):
##			#
##			# Create an off-screen pixmap
##			#
##			self._pixmap = self.GetWidget().CreatePixmap( self.width.value,
##														  self.height.value )
##		return self._pixmap


	def GetGC( self ):
		if not hasattr(self, 'gc'):
			if debug: print 'Composite creating GC'

			self.gc = self.GetWidget().CreateGC({
				  'foreground': self.w.background
				  })

##			self.gc = self.GetPixmap().CreateGC({
##				'foreground': self.w.background 
##				})


		return self.gc


	def _Subscribe( self, etype ):
		if debug: 
			print 'Composite._Subscribe:', ds[etype], 'for', self.GetName()
		EventNotifier.SubscribeComposite( self, self.w, etype )


	def _UnSubscribe( self, etype ):
		EventNotifier.UnSubscribeComposite( self, self.w, etype)


	# ------------------------------------------------------------------
	# Methods for Primitives:

	def SubscribePrimitive( self, prim, etype ):
		#
		# increase the count and subscribe if count == 1
		#
		if debug:
			print 'Composite.SubscribePrimitive: prim =', \
				  prim.GetClassName(), 'etype =', ds[etype]
				  

		if self.eh_dict.has_key(etype):
			(eh, cd, count) = self.eh_dict[etype]
			count = count + 1
		else:
			(eh, cd, count) = (self.DummyEH, None, 1)

		self.eh_dict[etype] = (eh, cd, count)

		if count == 1 and self.IsRealized(): self._Subscribe( etype )
			

	def UnSubscribePrimitive( self, prim, etype ):
		#
		# decrease the count and unsubscribe if count == 0
		#
		if debug:
			print 'Composite.UnSubscribePrimitive: prim =', \
				  prim.GetClassName(), 'etype =', ds[etype]

		if self.eh_dict.has_key(etype):
			(eh,cd,count) = self.eh_dict[etype]
			count = count - 1
			self.eh_dict[etype] = (eh, cd, count)

			if count == 0 and self.IsRealized(): self._UnSubscribe( etype )

		
	def AddToDisplayList( self, prim ):
		if debug: print 'Composite.AddToDisplayList', prim.GetName()

		self.display_list.append( prim )

		if len(self.display_list) == 1 and self.did_first_expose:
			self.RedrawOn()
		else:
			self.Redraw()
			

	def RemoveFromDisplayList( self, prim ):
		self.display_list.remove( prim )
		self.Redraw()
		if len(self.display_list) == 0: self.RedrawOff()


	def InitAddedNode( self, node ):
		self.GetSuperAttr( Composite, 'InitAddedNode' )( self, node )
		node.AddCallback( 'size_changed', self.ChildSizeChangedCB )


	# ------------------------------------------------------------------
	# Callback methods:

	def ChildSizeChangedCB( self, child ):
		#
		# Called when the size of a child changed; must check own size 
		#
		(oxmin,oymin,oxmax,oymax) = self.GetBBox()
		(cxmin,cymin,cxmax,cymax) = child.GetBBox()

		must_change_size = vp.FALSE

		if oxmin >= cxmin: 
			oxmin = cxmin - 1
			must_change_size = vp.TRUE
		if oymin >= cymin: 
			oymin = cymin - 1
			must_change_size = vp.TRUE
		if oxmax <= cxmax: 
			oxmax = cxmax + 1
			must_change_size = vp.TRUE
		if oymax <= cymax: 
			oymax = cymax + 1
			must_change_size = vp.TRUE
			
		if must_change_size:
			self.SetBBox( oxmin, oymin, oxmax, oymax )
			self.natural_size = (oxmax - oxmin, oymax - oymin)
			self.ExecuteCallback( 'size_changed', self )


	# ------------------------------------------------------------------
	# Event handler  methods:

	def ExposeEH( self, target, void, xevent, e ):
		if debug: print 'Composite.Expose called for', self.GetName()

		if not self.did_first_expose:
			self.did_first_expose = vp.TRUE
			if len(self.display_list) != 0: self.RedrawOn()
		else:
			self.Redraw()


	# ------------------------------------------------------------------
	# Draw  methods:

##	def SwapBuffers( self ):
##		self.GetPixmap().CopyArea( self.GetWidget(), 
##								   None, 0, 0, 
##								   self.width.value, 
##								   self.height.value, 
##								   0, 0)
		
	def RedrawOff( self ):
		self.do_redraw = self.do_redraw - 1
		self.Redraw    = self._NoRedraw
		if debug:
			print self.GetClassName() + '.RedrawOff:', \
				  'do_redraw =', self.do_redraw 


	def RedrawOn( self ):
		self.do_redraw = self.do_redraw + 1
		if debug:
			print self.GetClassName() + '.RedrawOn:', \
				  'do_redraw =', self.do_redraw 

		if self.did_first_expose and self.do_redraw == 1:
			if self.show_cntrl_pnts:
				self.Redraw = self._RedrawWithControlPoints
			else:
				self.Redraw = self._Redraw
			self.Redraw()
			

	def _NoRedraw( self ): pass

	def _Redraw( self ):
		#
		# This is the real-redraw method which will be installed when the
		# following is true: 
		# >> self.did_first_expose and len(self.dislay_list) != 0
		#
		if debug: print 'Composite.Redraw called for', self.GetName()

		# Erase the drawing area and redraw the Primitives in the display-list

		self.GetGC().FillRectangle(0, 0, self.width.value, self.height.value)
		for prim in self.display_list:
			if prim.IsVisible():
				prim.Redraw()


