# -------------------------------------------------------------------------
# MODULE:      Circles
#
# DESCRIPTION: 
#     Contains circle primitives: Circle, LabeledCircle
#
# AUTHOR:
#     Per Spilling, CWI, Amsterdam, <per@cwi.nl>

import vp

from vp        import TRUE, FALSE
from Primitive import Primitive

debug       = FALSE


# -------------------------------------------------------------------------
# CLASS:         Circle
#
# INHERITS FROM: Primitive : Graphic : (TreeNode,DatumDict) : Object
#
# DESCRIPTION:
#

class Circle( Primitive ):

	# ------------------------------------------------------------------
	# Init methods

	def __init__( self, argdict = {} ):	  
		#
		# Args can be the following: 
		# - 'name'     : <string> (this will produce a labeled circle)
		# - 'pos'      : (<int>, <int>) (0,0)=default
		# - 'size'     : (<int>, <int>) (10,10)=default
		# - 'diameter' : <int>
		# - 'fill'     : <bool> (FALSE=default)
		# - 'outline'  : <bool> (FALSE=default)
		# - 'show_name': <bool> (FALSE=default)
		#
		argdict = self.MergeDefaults(argdict, {
			  'pos'      : (0,0),
			  'size'     : (10, 10),
			  'fill'     : FALSE,
			  'outline'  : FALSE,
			  'show_name': FALSE
			  })
		Primitive.__init__( self, argdict )

		if hasattr( self, 'diameter' ):
			self.SetSize( self.diameter, self.diameter )

		if not 'line_width' in self.xresources.keys():
			self.SetXResources({ 'line_width': 1 })


	def CreatePrimitive( self ):
		#
		# set fpointer to the real redraw method
		#
		if hasattr( self, 'name' ) and self.show_name == TRUE:
			self.lsize = vp.theDefaultFont.GetStringSize( self.name )
			if self.fill and self.outline:
				self._Redraw = self._RedrawFOL
			elif self.fill:
				self._Redraw = self._RedrawFL
			else:
				self._Redraw = self._RedrawL
		else:
			if self.fill and self.outline:
				self._Redraw = self._RedrawFO
			elif self.fill:
				self._Redraw = self._RedrawF

		self.Redraw = self._Redraw     

		if self.fill and not self.xresources.has_key('foreground'):
			self.SetXResources({ 'foreground': 'bisque' }) # default fill color

		self.canvas = self.GetCanvas()
		self.canvas.AddToDisplayList( self )    

		self.realized = TRUE


	# ------------------------------------------------------------------
	# Drawing methods:

	def _Redraw( self ):
		#
		# The circle should be drawn so that it stays inside its bbox
		#
		lw = self.xresources['line_width']
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		if lw > w: lw = w
		if lw > h: lw = h
		self.GetGC().DrawArc( x + lw/2, y + lw/2, w - lw, h - lw, 
				      0, 360 * 64  )


	def _RedrawF( self ):
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		self.GetGC().FillArc( x, y, w, h, 0, 360 * 64  )


	def _RedrawFO( self ):
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		lw = self.xresources['line_width'] 
		if lw > w: lw = w
		if lw > h: lw = h
		self.GetGC().FillArc( x, y, w, h, 0, 360 * 64  )
		self.GetOLGC().DrawArc( x + lw/2, y + lw/2, w - lw, h - lw, 
					0, 360 * 64  )


	def _RedrawL( self ):
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		lw = self.xresources['line_width'] 
		if lw > w: lw = w
		if lw > h: lw = h
		self.GetGC().DrawArc( x + lw/2, y + lw/2, w - lw, h - lw, 
				      0, 360 * 64  )
		self.GetOLGC().DrawString( 
			  x + w/2 - self.lsize[0]/2, 
			  y + h/2 + self.lsize[1]/2, 
			  self.name )


	def _RedrawFL( self ):
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		self.GetGC().FillArc( x, y, w, h, 0, 360 * 64  )
		self.GetOLGC().DrawString( 
			  x + w/2 - self.lsize[0]/2, 
			  y + h/2 + self.lsize[1]/2, 
			  self.name )


	def _RedrawFOL( self ):
		x = self.wc_x.value
		y = self.wc_y.value
		w = self.width.value
		h = self.height.value
		if w < 0: x, w = x + w, -w
		if h < 0: y, h = y + h, -h
		lw = self.xresources['line_width'] 
		if lw > w: lw = w
		if lw > h: lw = h
		self.GetGC().FillArc( x, y, w, h, 0, 360 * 64  )
		self.GetOLGC().DrawArc( x + lw/2, y + lw/2, w - lw, h - lw, 
					0, 360 * 64  )
		self.GetOLGC().DrawString( 
			  x + w/2 - self.lsize[0]/2, 
			  y + h/2 + self.lsize[1]/2, 
			  self.name )


