#!/usr/bin/python


from XMLClient import *

from window import *
from button import *
from label  import *
from dialog import *
from textbox import *
from connection import *
from notebook import *
from tab import *
from combobox import *

import strop

InvalidTag = "qtXMLClient.InvalidTag"
UnhandledTag = "qtXMLClient.UnhandledTag"

"""
	Creates a tree structure of Qt widgets that represent
	a form created by the xml file. 
"""
class pluginTree:
	def __init__(self):
		self.t = []
		self.curr = 0
		
	def getRoot(self):
		try:
			return self.t[0][0]
		except:
			return None		
		
	def newEntry(self, w):
		if self.curr == len(self.t):
			# if it doesn't exist
			self.t.append( [w] )
		else:
			self.t[ self.curr ].append( w )	
			
	def onNonEmptyTag(self, w):
		self.newEntry( w )
		self.curr = self.curr + 1

	def onEndTag(self):
		self.curr = self.curr - 1
		
	def onEmptyTag(self, w):
		self.newEntry( w )
		
	def getParent(self):
		if self.curr > 0:
			list = self.t[ self.curr-1 ]		
			return list[ len(list) - 1 ]
		else:
			return None	
	
	def push(self, w):
		self.onNonEmptyTag(w)			
			


"""
	xml client that parses an xml file with qt tags.
"""
class qtXMLClient(ClientBase):
	def __init__(self, topwidget=None):
		ClientBase.__init__(self)
		#self.widgetStack = []
		self.table = {}
		#self.wlist = []
		self.pt = pluginTree()

		if topwidget != None:
			#self.widgetStack.append( topwidget ) 
			self.pt.push( topwidget )

		for i in (select(), combobox(), connection(),\
			textbox(),window(),button(),\
			dialog(),label(), notebook(), tab()):
			# hard coded registering
			self.register(i)
			

	# Register a new tag 		
	def register(self, np):
		n = strop.upper(np.nameOf())
		self.table[ n ] = np
		
	# get the parent widget
	def getParent(self):
		return self.pt.getParent()

	# try to match widget
	def match(self, obj):
		n = strop.upper(obj.nameOf())
		if self.table.has_key(n):
			x = self.table[n].clone()
			p = self.getParent()

			# if p is none then we 			
			if p == None:
				#x.setTopLevel( self.widgetStack[ 0 ] )
				x.setTopLevel( self.pt.getRoot() )
			else:	
				w = p.getWidget()
				x.setParent( w )
				
			if x.isValid( obj ) == false:
				msg = "Invalid attributes for tag %s" % (obj.nameOf())	 	 				
				raise InvalidTag, msg

			# call plugin 
			x.call( obj )

			if x.useText() == true:
				self.textH = x
			return x
			
		return None

	# text handler
	def text(self, obj):
		if hasattr(self, "textH"):
			self.textH.texthandler( obj )
			delattr(self,"textH")
			
		# call whatever text handlers there are
		#ClientBase.text(self, obj)	
			
	# tag handlers 	
	def nonEmptyTag(self, obj):
		ClientBase.nonEmptyTag(self, obj)
		x = self.match(obj)
		if x != None:
			#self.widgetStack.append( x )
			self.pt.onNonEmptyTag( x )
			return
			
		msg = "Unknown tag %s" % (obj.nameOf())
		raise UnhandledTag, msg
				
	def emptyTag(self, obj):
		ClientBase.emptyTag(self, obj)
		x = self.match(obj)
		if x == None:
			msg = "Unknown tag %s" % (obj.nameOf())
			raise UnhandledTag, msg
		self.pt.onEmptyTag( x )
				
	def endTag(self, obj):
		ClientBase.endTag(self, obj)
		#del self.widgetStack[ len(self.widgetStack) - 1 ]
		self.pt.onEndTag()

	def endfile(self):
		global QtApp
		QtApp.execLoop()
	

def ParseQtXMLFile(xmlfile, topwidget = None):
	from XMLProcessor import *

	c = qtXMLClient(topwidget)
	x = XMLProcessor( c )
	x.run( xmlfile )
		
				

if __name__ == '__main__':
	import sys
	ParseQtXMLFile( sys.argv[1] )
