/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char xyplot_set_return__doc__[] =
"Makes the XyPlot return always or when released"
 ;

static PyObject *
xyplot_set_return (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{
  long o;
  int i;

  if (!PyArg_ParseTuple (args, "li", &o, &i))
    return NULL;
  fl_set_xyplot_return ((FL_OBJECT *) o, i);
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_xtics__doc__[] =
"Changes the number of xtics (major and minor) in a xyplot"
 ;

static PyObject *
xyplot_set_xtics (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{
  long o;
  int i, j;

  if (!PyArg_ParseTuple (args, "lii", &o, &i, &j))
    return NULL;
  fl_set_xyplot_xtics ((FL_OBJECT *) o, i, j);
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_ytics__doc__[] =
"Changes the number of ytics (major and minor) in a xyplot"
 ;

static PyObject *
xyplot_set_ytics (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{
  long o;
  int i, j;

  if (!PyArg_ParseTuple (args, "lii", &o, &i, &j))
    return NULL;
  fl_set_xyplot_ytics ((FL_OBJECT *) o, i, j);
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_xbounds__doc__[] =
"Sets the xmin and xmax in a xyplot"
 ;

static PyObject *
xyplot_set_xbounds (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{
  long o;
  double u, v;

  if (!PyArg_ParseTuple (args, "ldd", &o, &u, &v))
    return NULL;
  fl_set_xyplot_xbounds ((FL_OBJECT *) o, u, v);
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_ybounds__doc__[] =
"Sets the xmin and xmax in a xyplot"
 ;

static PyObject *
xyplot_set_ybounds (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{
  long o;
  double u, v;

  if (!PyArg_ParseTuple (args, "ldd", &o, &u, &v))
    return NULL;
  fl_set_xyplot_ybounds ((FL_OBJECT *) o, u, v);
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_get__doc__[] =
"Gets the current value of the point that changed"
 ;

static PyObject *
xyplot_get (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{
  long o;
  float x, y;
  int i;

  if (!PyArg_ParseTuple (args, "l", &o))
    return NULL;
  r = fl_get_xyplot ((FL_OBJECT *) o, &x, &y, &i);
  return Py_BuildValue ("d", r);
}

static char xyplot_get_data__doc__[] =
""
 ;

static PyObject *
xyplot_get_data (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_create__doc__[] =
""
 ;

static PyObject *
xyplot_create (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_data__doc__[] =
""
 ;

static PyObject *
xyplot_set_data (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_file__doc__[] =
""
 ;

static PyObject *
xyplot_set_file (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_add_text__doc__[] =
""
 ;

static PyObject *
xyplot_add_text (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_delete_text__doc__[] =
""
 ;

static PyObject *
xyplot_delete_text (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_add_overlay__doc__[] =
""
 ;

static PyObject *
xyplot_add_overlay (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_overlay_type__doc__[] =
""
 ;

static PyObject *
xyplot_set_overlay_type (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_delete_overlay__doc__[] =
""
 ;

static PyObject *
xyplot_delete_overlay (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_interpolate__doc__[] =
""
 ;

static PyObject *
xyplot_set_interpolate (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_fontsize__doc__[] =
""
 ;

static PyObject *
xyplot_set_fontsize (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_fontstyle__doc__[] =
""
 ;

static PyObject *
xyplot_set_fontstyle (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_inspect__doc__[] =
""
 ;

static PyObject *
xyplot_set_inspect (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_set_symbolsize__doc__[] =
""
 ;

static PyObject *
xyplot_set_symbolsize (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

static char xyplot_replace_point__doc__[] =
""
 ;

static PyObject *
xyplot_replace_point (self, args)
     PyObject *self;		/* Not used */
     PyObject *args;
{

  if (!PyArg_ParseTuple (args, ""))
    return NULL;
  Py_INCREF (Py_None);
  return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef xyplot_methods[] =
{
  {"set_return", xyplot_set_return, 1, xyplot_set_return__doc__},
  {"set_xtics", xyplot_set_xtics, 1, xyplot_set_xtics__doc__},
  {"set_ytics", xyplot_set_ytics, 1, xyplot_set_ytics__doc__},
  {"set_xbounds", xyplot_set_xbounds, 1, xyplot_set_xbounds__doc__},
  {"set_ybounds", xyplot_set_ybounds, 1, xyplot_set_ybounds__doc__},
  {"get", xyplot_get, 1, xyplot_get__doc__},
  {"get_data", xyplot_get_data, 1, xyplot_get_data__doc__},
  {"create", xyplot_create, 1, xyplot_create__doc__},
  {"set_data", xyplot_set_data, 1, xyplot_set_data__doc__},
  {"set_file", xyplot_set_file, 1, xyplot_set_file__doc__},
  {"add_text", xyplot_add_text, 1, xyplot_add_text__doc__},
  {"delete_text", xyplot_delete_text, 1, xyplot_delete_text__doc__},
  {"add_overlay", xyplot_add_overlay, 1, xyplot_add_overlay__doc__},
  {"set_overlay_type", xyplot_set_overlay_type, 1, xyplot_set_overlay_type__doc__},
  {"delete_overlay", xyplot_delete_overlay, 1, xyplot_delete_overlay__doc__},
  {"set_interpolate", xyplot_set_interpolate, 1, xyplot_set_interpolate__doc__},
  {"set_fontsize", xyplot_set_fontsize, 1, xyplot_set_fontsize__doc__},
  {"set_fontstyle", xyplot_set_fontstyle, 1, xyplot_set_fontstyle__doc__},
  {"set_inspect", xyplot_set_inspect, 1, xyplot_set_inspect__doc__},
  {"set_symbolsize", xyplot_set_symbolsize, 1, xyplot_set_symbolsize__doc__},
  {"replace_point", xyplot_replace_point, 1, xyplot_replace_point__doc__},

  {NULL, NULL}			/* sentinel */
};


/* Initialization function for the module (*must* be called initxyplot) */

static char xyplot_module_documentation[] =
""
 ;

void 
initxyplot ()
{
  PyObject *m, *d;

  /* Create the module and add the functions */
  m = Py_InitModule4 ("xyplot", xyplot_methods,
		      xyplot_module_documentation,
		      (PyObject *) NULL, PYTHON_API_VERSION);

  /* Add some symbolic constants to the module */
  d = PyModule_GetDict (m);
  ErrorObject = PyString_FromString ("xyplot.error");
  PyDict_SetItemString (d, "error", ErrorObject);

  /* XXXX Add constants here */

  /* Check for errors */
  if (PyErr_Occurred ())
    Py_FatalError ("can't initialize module xyplot");
}
