/***********************************************************
Copyright 1996 Roberto Alsina


			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char slider_create__doc__[] =
""
;

static PyObject *
slider_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int	t,x,y,w,h;
	char	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_slider(t,x,y,w,h,l);
	return Py_BuildValue ("l",o);
}

static char slider_create_val__doc__[] =
"Creates a val_slider"
;

static PyObject *
slider_create_val(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int	t,x,y,w,h;
	char	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_valslider(t,x,y,w,h,l);
	return Py_BuildValue ("l",o);
}

static char slider_set_value__doc__[] =
"Sets the slider's value"
;


static PyObject *
slider_set_value(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	v;

	if (!PyArg_ParseTuple(args, "ld",&o,&v))
		return NULL;
	fl_set_slider_value ((FL_OBJECT *)o,v);
	Py_INCREF(Py_None);
	return Py_None;
}

static char slider_get_value__doc__[] =
"Gets the slider value"
;

static PyObject *
slider_get_value(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	v;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	v=fl_get_slider_value ((FL_OBJECT *)o);
	return Py_BuildValue ("d",v);
}

static char slider_set_bounds__doc__[] =
"Sets the slider's min/max"
;

static PyObject *
slider_set_bounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	min,max;

	if (!PyArg_ParseTuple(args, "ldd",&o,&min,&max))
		return NULL;
	fl_set_slider_bounds((FL_OBJECT *)o,min,max);
	Py_INCREF(Py_None);
	return Py_None;
}

static char slider_get_bounds__doc__[] =
""
;

static PyObject *
slider_get_bounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	min,max;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_get_slider_bounds((FL_OBJECT *)o,&min,&max);
	return Py_BuildValue ("dd",min,max);
}

static char slider_set_return__doc__[] =
"Makes the slider return always or when released"
;

static PyObject *
slider_set_return(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_slider_return ((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char slider_set_step__doc__[] =
"Sets the slider's step"
;

static PyObject *
slider_set_step(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	s;

	if (!PyArg_ParseTuple(args, "ld",&o,&s))
		return NULL;
	fl_set_slider_step ((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char slider_set_size__doc__[] =
"Sets the slider's thingy size"
;

static PyObject *
slider_set_size(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	s;

	if (!PyArg_ParseTuple(args, "ld",&o,&s))
		return NULL;
	fl_set_slider_size ((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char slider_set_precision__doc__[] =
"Sets the valslider's precision"
;

static PyObject *
slider_set_precision(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_slider_precision ((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef slider_methods[] = {
	{"create",	slider_create,	1,	slider_create__doc__},
 {"create_val",	slider_create_val,	1,	slider_create_val__doc__},
 {"set_value",	slider_set_value,	1,	slider_set_value__doc__},
 {"get_value",	slider_get_value,	1,	slider_get_value__doc__},
 {"set_bounds",	slider_set_bounds,	1,	slider_set_bounds__doc__},
 {"get_bounds",	slider_get_bounds,	1,	slider_get_bounds__doc__},
 {"set_return",	slider_set_return,	1,	slider_set_return__doc__},
 {"set_step",	slider_set_step,	1,	slider_set_step__doc__},
 {"set_size",	slider_set_size,	1,	slider_set_size__doc__},
 {"set_precision",	slider_set_precision,	1,	slider_set_precision__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initslider) */

static char slider_module_documentation[] = 
""
;

void
initslider()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("slider", slider_methods,
		slider_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("slider.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module slider");
}

