/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char posit_create__doc__[] =
"Creates a positioner"
;

static PyObject *
posit_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long    o;
	int     t,x,y,w,h;
	char    *l;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_positioner(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char posit_set_xvalue__doc__[] =
"Sets the x-value of the positioner"
;

static PyObject *
posit_set_xvalue(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	v;

	if (!PyArg_ParseTuple(args, "ld",&o,&v))
		return NULL;
	fl_set_positioner_xvalue((FL_OBJECT *)o,v);
	Py_INCREF(Py_None);
	return Py_None;
}

static char posit_get_xvalue__doc__[] =
"Gets the x-value of the positioner"
;

static PyObject *
posit_get_xvalue(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_positioner_xvalue((FL_OBJECT *)o);
	return Py_BuildValue ("d",r);
}

static char posit_set_xbounds__doc__[] =
"Sets the positioner's x min/max"
;

static PyObject *
posit_set_xbounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double 	min,max;

	if (!PyArg_ParseTuple(args, "ldd",&o,&min,&max))
		return NULL;
	fl_set_positioner_xbounds ((FL_OBJECT *)o,min,max);
	Py_INCREF(Py_None);
	return Py_None;
}

static char posit_get_xbounds__doc__[] =
"Gets the positioner's x min/max"
;

static PyObject *
posit_get_xbounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double 	min,max;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_get_positioner_xbounds ((FL_OBJECT *)o,&min,&max);
	return Py_BuildValue ("dd",min,max);
}


static char posit_set_yvalue__doc__[] =
"Sets the y-value of the positioner"
;

static PyObject *
posit_set_yvalue(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	v;

	if (!PyArg_ParseTuple(args, "ld",&o,&v))
		return NULL;
	fl_set_positioner_yvalue((FL_OBJECT *)o,v);
	Py_INCREF(Py_None);
	return Py_None;
}

static char posit_get_yvalue__doc__[] =
"Gets the y-value of the positioner"
;

static PyObject *
posit_get_yvalue(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_positioner_yvalue((FL_OBJECT *)o);
	return Py_BuildValue ("d",r);
}

static char posit_set_ybounds__doc__[] =
"Sets the positioner's y min/max"
;

static PyObject *
posit_set_ybounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double 	min,max;

	if (!PyArg_ParseTuple(args, "ldd",&o,&min,&max))
		return NULL;
	fl_set_positioner_ybounds ((FL_OBJECT *)o,min,max);
	Py_INCREF(Py_None);
	return Py_None;
}

static char posit_get_ybounds__doc__[] =
"Gets the positioner's y min/max"
;

static PyObject *
posit_get_ybounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double 	min,max;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_get_positioner_ybounds ((FL_OBJECT *)o,&min,&max);
	return Py_BuildValue ("dd",min,max);
}


static char posit_set_xstep__doc__[] =
"Sets the positioner x-step"
;

static PyObject *
posit_set_xstep(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	s;

	if (!PyArg_ParseTuple(args, "ld",&o,&s))
		return NULL;
	fl_set_positioner_xstep ((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}


static char posit_set_ystep__doc__[] =
"Sets the positioner y-step"
;

static PyObject *
posit_set_ystep(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	s;

	if (!PyArg_ParseTuple(args, "ld",&o,&s))
		return NULL;
	fl_set_positioner_ystep ((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char posit_set_return__doc__[] =
"Makes the positioner return always or when released"
;

static PyObject *
posit_set_return(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_positioner_return ((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef posit_methods[] = {
	{"create",	posit_create,	1,	posit_create__doc__},
 {"set_xvalue",	posit_set_xvalue,	1,	posit_set_xvalue__doc__},
 {"get_xvalue",	posit_get_xvalue,	1,	posit_get_xvalue__doc__},
 {"set_xbounds",	posit_set_xbounds,	1,	posit_set_xbounds__doc__},
 {"get_xbounds",	posit_get_xbounds,	1,	posit_get_xbounds__doc__},
 {"set_yvalue",	posit_set_yvalue,	1,	posit_set_yvalue__doc__},
 {"get_yvalue",	posit_get_yvalue,	1,	posit_get_yvalue__doc__},
 {"set_ybounds",	posit_set_ybounds,	1,	posit_set_ybounds__doc__},
 {"get_ybounds",	posit_get_ybounds,	1,	posit_get_ybounds__doc__},
 {"set_xstep",	posit_set_xstep,	1,	posit_set_xstep__doc__},
 {"set_ystep",	posit_set_ystep,	1,	posit_set_ystep__doc__},
 {"set_return",	posit_set_return,	1,	posit_set_return__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initpositioner) */

static char positioner_module_documentation[] = 
""
;

void
initpositioner()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("positioner", posit_methods,
		positioner_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("positioner.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module positioner");
}

