#include <Python.h>
#include <forms.h>
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char obj_set_boxtype__doc__[] =
"Sets the objects Boxtype"
;

static PyObject *
obj_set_boxtype(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long 	object;
	int	type;

	if (!PyArg_ParseTuple(args, "li",&object,&type))
		return NULL;
	fl_set_object_boxtype ((FL_OBJECT *)object,type);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_bw__doc__[] =
"Sets the object's Border Width"
;

static PyObject *
obj_set_bw(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	object;
	int	bw;

	if (!PyArg_ParseTuple(args, "li",&object,&bw))
		return NULL;
	fl_set_object_bw ((FL_OBJECT *)object,bw);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_resize__doc__[] =
"Sets the objects \"Resize policy\""
;

static PyObject *
obj_set_resize(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long            object;
	unsigned        a;

	if (!PyArg_ParseTuple(args, "ll",&object,&a))
		return NULL;
	fl_set_object_resize ((FL_OBJECT *)object,a);
	Py_INCREF(Py_None);
	return Py_None;
}


static char obj_set_gravity__doc__[] =
"Sets the objects gravity"
;

static PyObject *
obj_set_gravity(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long            object;
	unsigned        a,b,c;

	if (!PyArg_ParseTuple(args, "lll",&object,&a,&b))
		return NULL;
	fl_set_object_gravity ((FL_OBJECT *)object,a,b);
	Py_INCREF(Py_None);
	return Py_None;
}


static char obj_set_lsize__doc__[] =
"Sets the object's label size"
;

static PyObject *
obj_set_lsize(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    object;
	int     size;

	if (!PyArg_ParseTuple(args, "li",&object,&size))
		return NULL;
	fl_set_object_lsize((FL_OBJECT *)object,size);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_lstyle__doc__[] =
"Sets the object's label style"
;

static PyObject *
obj_set_lstyle(self, args)
	PyObject *self; /* Not used */
	PyObject *args;
{
	long    object;
	int     style;

	if (!PyArg_ParseTuple(args, "li",&object,&style))
		return NULL;
	fl_set_object_lstyle((FL_OBJECT *)object,style);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_lcol__doc__[] =
"Sets the object's label color"
;

static PyObject *
obj_set_lcol(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long 	o;
	int	c;
	if (!PyArg_ParseTuple(args, "li",&o,&c))
		return NULL;
	fl_set_object_lcol((FL_OBJECT *)o,c);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_dragndrop__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
obj_set_dragndrop(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_focus__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
obj_set_focus(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_redraw__doc__[] =
"Redraws the object"
;

static PyObject *
obj_redraw(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_redraw_object((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_lalign__doc__[] =
"Sets the label alignment"
;

static PyObject *
obj_set_lalign(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	a;
	if (!PyArg_ParseTuple(args, "li",&o,&a))
		return NULL;
	fl_set_object_lalign((FL_OBJECT *)o,a);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_scale__doc__[] =
"Scales the object"
;

static PyObject *
obj_scale(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	x,y;
	if (!PyArg_ParseTuple(args, "ldd",&o,&x,&y))
		return NULL;
	fl_scale_object((FL_OBJECT *)o,x,y);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_callback__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
obj_set_callback(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_show__doc__[] =
"Shows the object"
;

static PyObject *
obj_show(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_show_object((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_hide__doc__[] =
"Hides the object"
;

static PyObject *
obj_hide(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_hide_object((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_free__doc__[] =
"Releases the object's memory"
;

static PyObject *
obj_free(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_free_object((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_delete__doc__[] =
"Deletes the object from it's form"
;

static PyObject *
obj_delete(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_delete_object((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_color__doc__[] =
"Sets the object color"
;

static PyObject *
obj_set_color(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	float	a,b;
	if (!PyArg_ParseTuple(args, "lff",&o,&a,&b))
		return NULL;
	fl_set_object_color((FL_OBJECT *)o,(int)a,(int)b);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_label__doc__[] =
"Sets the label"
;

static PyObject *
obj_set_label(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*s;

	if (!PyArg_ParseTuple(args, "ls",&o,&s))
		return NULL;
	fl_set_object_label((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_activate__doc__[] =
"Activates the object"
;

static PyObject *
obj_activate(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_activate_object((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}


static char obj_deactivate__doc__[] =
"Activates the object"
;

static PyObject *
obj_deactivate(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_deactivate_object((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_shortcut__doc__[] =
"Sets the shortcut to the object"
;

static PyObject *
obj_set_shortcut(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*s;
	int	i;

	if (!PyArg_ParseTuple(args, "lsi",&o,&s,&i))
		return NULL;
	fl_set_object_shortcut ((FL_OBJECT *)o,s,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char obj_set_dblbuffer__doc__[] =
"Sets the object as double buffered"
;

static PyObject *
obj_set_dblbuffer(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	c;

	if (!PyArg_ParseTuple(args, "li",&o,&c))
		return NULL;
	fl_set_object_dblbuffer((FL_OBJECT *)o,c);
	Py_INCREF(Py_None);
	return Py_None;
}


static char obj_set_geometry__doc__[] =
"Sets the object's geometry"
;

static PyObject *
obj_set_geometry(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	x,y,w,h;

	if (!PyArg_ParseTuple(args, "liiii",&o,&x,&y,&w,&h))
		return NULL;
	fl_set_object_geometry ((FL_OBJECT *)o,x,y,w,h);
	fl_redraw_object ((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}



static char obj_get_geometry__doc__[] =
"Sets the object's geometry"
;

static PyObject *
obj_get_geometry(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	x,y,w,h;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	x=((FL_OBJECT *)o)->x;
	y=((FL_OBJECT *)o)->y;
	w=((FL_OBJECT *)o)->w;
	h=((FL_OBJECT *)o)->h;
	fl_redraw_object ((FL_OBJECT *)o);
	return Py_BuildValue ("iiii",x,y,w,h);
}

/* List of methods defined in the module */

static struct PyMethodDef obj_methods[] = {
	{"set_boxtype",	obj_set_boxtype,	1,	obj_set_boxtype__doc__},
 {"set_bw",	obj_set_bw,	1,	obj_set_bw__doc__},
 {"set_resize",	obj_set_resize,	1,	obj_set_resize__doc__},
 {"set_gravity",	obj_set_gravity,	1,	obj_set_gravity__doc__},
 {"set_lsize",	obj_set_lsize,	1,	obj_set_lsize__doc__},
 {"set_lstyle",	obj_set_lstyle,	1,	obj_set_lstyle__doc__},
 {"set_lcol",	obj_set_lcol,	1,	obj_set_lcol__doc__},
 {"set_dragndrop",	obj_set_dragndrop,	1,	obj_set_dragndrop__doc__},
 {"set_focus",	obj_set_focus,	1,	obj_set_focus__doc__},
 {"redraw",	obj_redraw,	1,	obj_redraw__doc__},
 {"set_lalign",	obj_set_lalign,	1,	obj_set_lalign__doc__},
 {"scale",	obj_scale,	1,	obj_scale__doc__},
 {"set_callback",	obj_set_callback,	1,	obj_set_callback__doc__},
 {"show",	obj_show,	1,	obj_show__doc__},
 {"hide",	obj_hide,	1,	obj_hide__doc__},
 {"free",	obj_free,	1,	obj_free__doc__},
 {"delete",	obj_delete,	1,	obj_delete__doc__},
 {"set_color",	obj_set_color,	1,	obj_set_color__doc__},
 {"set_label",	obj_set_label,	1,	obj_set_label__doc__},
 {"activate",	obj_activate,	1,	obj_activate__doc__},
 {"deactivate",	obj_deactivate,	1,	obj_deactivate__doc__},
 {"set_shortcut",	obj_set_shortcut,	1,	obj_set_shortcut__doc__},
 {"set_dblbuffer",	obj_set_dblbuffer,	1,	obj_set_dblbuffer__doc__},
 {"set_geometry",	obj_set_geometry,	1,	obj_set_geometry__doc__},
 {"get_geometry",	obj_get_geometry,	1,	obj_get_geometry__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initobjects) */

static char objects_module_documentation[] = 
""
;

void
initobjects()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("objects", obj_methods,
		objects_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("objects.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module objects");
}

