/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char input_create__doc__[] =
"Creates an Input object"
;

static PyObject *
input_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int	t,x,y,w,h;
	char	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_input (t,x,y,w,h,l);
	return Py_BuildValue ("l",o);
}

static char input_set__doc__[] =
"Sets the contents of an input object"
;

static PyObject *
input_set(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*s;

	if (!PyArg_ParseTuple(args, "ls",&o,&s))
		return NULL;
	fl_set_input((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char input_set_color__doc__[] =
"Sets the color of the input object's text"
;

static PyObject *
input_set_color(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	c1,c2;

	if (!PyArg_ParseTuple(args, "lii",&o,&c1,&c2))
		return NULL;
	fl_set_input_color ((FL_OBJECT *)o,c1,c2);
	Py_INCREF(Py_None);
	return Py_None;
}

static char input_get__doc__[] =
"Gets the input's value"
;

static PyObject *
input_get(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	r[2048];

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	strcpy (r,fl_get_input((FL_OBJECT *)o));
	return Py_BuildValue ("s",r);
}

static char input_set_return__doc__[] =
"Makes the input return always or when released"
;

static PyObject *
input_set_return(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_input_return ((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char input_set_scroll__doc__[] =
"Makes the input scrollable"
;

static PyObject *
input_set_scroll(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_input_scroll((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char input_set_cursorpos__doc__[] =
"Sets the input's cursor position"
;

static PyObject *
input_set_cursorpos(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i,j;

	if (!PyArg_ParseTuple(args, "lii",&o,&i,&j))
		return NULL;
	fl_set_input_cursorpos ((FL_OBJECT *)o,i,j);
	Py_INCREF(Py_None);
	return Py_None;
}

static char input_set_selected__doc__[] =
"Sets the input as selected"
;

static PyObject *
input_set_selected(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_input_selected((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char input_set_selected_range__doc__[] =
"Sets a range of the input object as selected"
;

static PyObject *
input_set_selected_range(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i,j;

	if (!PyArg_ParseTuple(args, "lii",&o,&i,&j))
		return NULL;
	fl_set_input_selected_range((FL_OBJECT *)o,i,j);
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef input_methods[] = {
	{"create",	input_create,	1,	input_create__doc__},
 {"set",	input_set,	1,	input_set__doc__},
 {"set_color",	input_set_color,	1,	input_set_color__doc__},
 {"get",	input_get,	1,	input_get__doc__},
 {"set_return",	input_set_return,	1,	input_set_return__doc__},
 {"set_scroll",	input_set_scroll,	1,	input_set_scroll__doc__},
 {"set_cursorpos",	input_set_cursorpos,	1,	input_set_cursorpos__doc__},
 {"set_selected",	input_set_selected,	1,	input_set_selected__doc__},
 {"set_selected_range",	input_set_selected_range,	1,	input_set_selected_range__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initinput) */

static char input_module_documentation[] = 
""
;

void
initinput()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("input", input_methods,
		input_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("input.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module input");
}

