/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char counter_create__doc__[] =
"Creates a counter"
;

static PyObject *
counter_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int	t,x,y,w,h;
	char	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_counter(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char counter_set_value__doc__[] =
"Sets the value of the counter (Use only on visible counters!)"
;

static PyObject *
counter_set_value(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	v;	

	if (!PyArg_ParseTuple(args, "ld",&o,&v))
		return NULL;
	fl_set_counter_value((FL_OBJECT *)o,v);
	Py_INCREF(Py_None);
	return Py_None;
}

static char counter_set_bounds__doc__[] =
"Sets the counter's max & min"
;

static PyObject *
counter_set_bounds(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	min,max;

	if (!PyArg_ParseTuple(args, "ldd",&o,&min,&max))
		return NULL;
	fl_set_counter_bounds((FL_OBJECT *)o,min,max);
	Py_INCREF(Py_None);
	return Py_None;
}

static char counter_set_step__doc__[] =
"Set the counter's step size (small & large)"
;

static PyObject *
counter_set_step(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	s,l;

	if (!PyArg_ParseTuple(args, "ldd",&o,&s,&l))
		return NULL;
	fl_set_counter_step((FL_OBJECT *)o,s,l);
	Py_INCREF(Py_None);
	return Py_None;
}

static char counter_set_precision__doc__[] =
"Sets the counter's precision"
;

static PyObject *
counter_set_precision(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	p;

	if (!PyArg_ParseTuple(args, "li",&o,&p))
		return NULL;
	fl_set_counter_precision ((FL_OBJECT *)o,p);
	Py_INCREF(Py_None);
	return Py_None;
}

static char counter_get_value__doc__[] =
"Returns the counter's value"
;

static PyObject *
counter_get_value(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	double	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_counter_value((FL_OBJECT *)o);
	return Py_BuildValue ("d",r);
}

static char counter_set_return__doc__[] =
"Makes the counter return always or when released"
;

static PyObject *
counter_set_return(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_counter_return ((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef counter_methods[] = {
	{"create",	counter_create,	1,	counter_create__doc__},
 {"set_value",	counter_set_value,	1,	counter_set_value__doc__},
 {"set_bounds",	counter_set_bounds,	1,	counter_set_bounds__doc__},
 {"set_step",	counter_set_step,	1,	counter_set_step__doc__},
 {"set_precision",	counter_set_precision,	1,	counter_set_precision__doc__},
 {"get_value",	counter_get_value,	1,	counter_get_value__doc__},
 {"set_return",	counter_set_return,	1,	counter_set_return__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initcounter) */

static char counter_module_documentation[] = 
""
;

void
initcounter()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("counter", counter_methods,
		counter_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("counter.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module counter");
}

