/***********************************************************
Copyright 1996 Roberto Alsina

			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char clock_create__doc__[] =
"Creates a clock"
;

static PyObject *
clock_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int	t,x,y,w,h;
	char	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_clock(t,x,y,w,h,l);
	return Py_BuildValue ("l",o);
}

static char clock_get__doc__[] =
"Gets the current time"
;

static PyObject *
clock_get(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	h,m,s;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_get_clock ((FL_OBJECT *)o,&h,&m,&s);
	return Py_BuildValue ("iii",h,m,s);
}

/* List of methods defined in the module */

static struct PyMethodDef clock_methods[] = {
	{"create",	clock_create,	1,	clock_create__doc__},
 {"get",	clock_get,	1,	clock_get__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initclock) */

static char clock_module_documentation[] = 
""
;

void
initclock()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("clock", clock_methods,
		clock_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("clock.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module clock");
}

