/***********************************************************
Copyright 1996 Roberto Alsina


			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */


static char choice_create__doc__[] =
"Creates a choice object"
;

static PyObject *
choice_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int	t,x,y,w,h;
	char 	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_choice(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}


static char choice_clear__doc__[] =
"Clears the list of choices"
;

static PyObject *
choice_clear(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_clear_choice((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_addto__doc__[] =
"Adds a line to a choice object"
;

static PyObject *
choice_addto(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*t;

	if (!PyArg_ParseTuple(args, "ls",&o,&t))
		return NULL;
	fl_addto_choice((FL_OBJECT *)o,t);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_replace__doc__[] =
"Replaces a line in a choice"
;

static PyObject *
choice_replace(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	l;
	char	*t;

	if (!PyArg_ParseTuple(args, "lis",&o,&l,&t))
		return NULL;
	fl_replace_choice((FL_OBJECT *)o,l,t);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_delete__doc__[] =
"Deletes a line in a choice"
;

static PyObject *
choice_delete(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	l;

	if (!PyArg_ParseTuple(args, "li",&o,&l))
		return NULL;
	fl_delete_choice((FL_OBJECT *)o,l);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_set__doc__[] =
"Sets the choice"
;

static PyObject *
choice_set(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	l;

	if (!PyArg_ParseTuple(args, "li",&o,&l))
		return NULL;
	fl_set_choice ((FL_OBJECT *)o,l);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_set_text__doc__[] =
"Sets the choice at the item with the given text"
;

static PyObject *
choice_set_text(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*t;

	if (!PyArg_ParseTuple(args, "ls",&o,&t))
		return NULL;
	fl_set_choice_text((FL_OBJECT *)o,t);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_get__doc__[] =
"Gets the choice's selected option number"
;

static PyObject *
choice_get(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_choice((FL_OBJECT *)o);
	return Py_BuildValue("i",r);
}

static char choice_get_maxitems__doc__[] =
"Gets the total number of items in the choice"
;

static PyObject *
choice_get_maxitems(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_choice_maxitems((FL_OBJECT *)o);
	return Py_BuildValue("i",r);
}

static char choice_get_text__doc__[] =
"Gets the text of the current choice"
;

static PyObject *
choice_get_text(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	t[2048];

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	strcpy (t,fl_get_choice_text((FL_OBJECT *)o));
	return Py_BuildValue("s",t);
}

static char choice_set_fontsize__doc__[] =
"Sets the choice's fontsize"
;

static PyObject *
choice_set_fontsize(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_choice_fontsize((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_set_align__doc__[] =
"Sets the alignment of the choice"
;

static PyObject *
choice_set_align(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	i;

	if (!PyArg_ParseTuple(args, "li",&o,&i))
		return NULL;
	fl_set_choice_align((FL_OBJECT *)o,i);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_set_item_mode__doc__[] =
"Sets an item's mode ?"
;

static PyObject *
choice_set_item_mode(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long		o;
	int		n;
	unsigned	m;

	if (!PyArg_ParseTuple(args, "lil",&o,&n,&m))
		return NULL;
	fl_set_choice_item_mode((FL_OBJECT *)o,n,m);
	Py_INCREF(Py_None);
	return Py_None;
}

static char choice_set_item_shortcut__doc__[] =
"XXXXXXNot implemented"
;

static PyObject *
choice_set_item_shortcut(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef choice_methods[] = {
	{"create",	choice_create,	1,	choice_create__doc__},
	{"clear",	choice_clear,	1,	choice_clear__doc__},
 {"addto",	choice_addto,	1,	choice_addto__doc__},
 {"replace",	choice_replace,	1,	choice_replace__doc__},
 {"delete",	choice_delete,	1,	choice_delete__doc__},
 {"set",	choice_set,	1,	choice_set__doc__},
 {"set_text",	choice_set_text,	1,	choice_set_text__doc__},
 {"get",	choice_get,	1,	choice_get__doc__},
 {"get_maxitems",	choice_get_maxitems,	1,	choice_get_maxitems__doc__},
 {"get_text",	choice_get_text,	1,	choice_get_text__doc__},
 {"set_fontsize",	choice_set_fontsize,	1,	choice_set_fontsize__doc__},
 {"set_align",	choice_set_align,	1,	choice_set_align__doc__},
 {"set_item_mode",	choice_set_item_mode,	1,	choice_set_item_mode__doc__},
 {"set_item_shortcut",	choice_set_item_shortcut,	1,	choice_set_item_shortcut__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initchoice) */

static char choice_module_documentation[] = 
""
;

void
initchoice()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("choice", choice_methods,
		choice_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("choice.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module choice");
}

