/***********************************************************
Copyright 1996 Roberto Alsina


			All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "forms.h"
static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char browser_create__doc__[] =
"Creates a Browser"
;

static PyObject *
browser_create(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	int 	t,x,y,w,h;
	char	*l;
	long	o;

	if (!PyArg_ParseTuple(args, "iiiiis",&t,&x,&y,&w,&h,&l))
		return NULL;
	o=(long)fl_create_browser(t,x,y,w,h,l);
	return Py_BuildValue("l",o);
}

static char browser_add_line__doc__[] =
"Adds a line to a browser"
;

static PyObject *
browser_add_line(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*l;

	if (!PyArg_ParseTuple(args, "ls",&o,&l))
		return NULL;
	fl_add_browser_line ((FL_OBJECT *)o,l);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_addto__doc__[] =
"Adds a line to a browser, and shifts it there"
;

static PyObject *
browser_addto(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*l;

	if (!PyArg_ParseTuple(args, "ls",&o,&l))
		return NULL;
	fl_addto_browser ((FL_OBJECT *)o,l);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_insert_line__doc__[] =
""
;

static PyObject *
browser_insert_line(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	n;
	char	*l;

	if (!PyArg_ParseTuple(args, "lis",&o,&n,&l))
		return NULL;
	fl_insert_browser_line ((FL_OBJECT *)o,n,l);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_delete_line__doc__[] =
"Deletes a line from a browser"
;

static PyObject *
browser_delete_line(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	n;

	if (!PyArg_ParseTuple(args, "li",&o,&n))
		return NULL;
	fl_delete_browser_line ((FL_OBJECT *)o,n);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_replace_line__doc__[] =
"Replaces a line of abrowser"
;

static PyObject *
browser_replace_line(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	n;
	char	*l;

	if (!PyArg_ParseTuple(args, "lis",&o,&n,&l))
		return NULL;
	fl_replace_browser_line ((FL_OBJECT *)o,n,l);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_get_line__doc__[] =
"Gets a browser's line"
;

static PyObject *
browser_get_line(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	n;
	char	s[1024];

	if (!PyArg_ParseTuple(args, "li",&o,&n))
		return NULL;
	strcpy(s,fl_get_browser_line ((FL_OBJECT *)o,n));
	return Py_BuildValue ("s",s);
}

static char browser_load__doc__[] =
"Loads a file into a browser"
;

static PyObject *
browser_load(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	char	*s;
	int	r;

	if (!PyArg_ParseTuple(args, "ls",&o,&s))
		return NULL;
	r=fl_load_browser((FL_OBJECT *)o,s);
	return Py_BuildValue ("i",r);
}

static char browser_select_line__doc__[] =
"Selects a browser line"
;

static PyObject *
browser_select_line(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	n;

	if (!PyArg_ParseTuple(args, "li",&o,&n))
		return NULL;
	fl_select_browser_line ((FL_OBJECT *)o,n);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_deselect_line__doc__[] =
"Deselects a browser's line"
;

static PyObject *
browser_deselect_line(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	n;

	if (!PyArg_ParseTuple(args, "li",&o,&n))
		return NULL;
	fl_deselect_browser_line ((FL_OBJECT *)o,n);
	Py_INCREF(Py_None);
	return Py_None;
}


static char browser_deselect__doc__[] =
"Deselects all lines in a browser"
;

static PyObject *
browser_deselect(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	fl_deselect_browser ((FL_OBJECT *)o);
	Py_INCREF(Py_None);
	return Py_None;
}


static char browser_isselected_line__doc__[] =
"Is that line selected in the browser?"
;

static PyObject *
browser_isselected_line(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	n,r;

	if (!PyArg_ParseTuple(args, "li",&o,&n))
		return NULL;
	r=fl_isselected_browser_line((FL_OBJECT *)o,n);
	return Py_BuildValue ("i",r);
}

static char browser_get_topline__doc__[] =
"The number of the 1st visible line in the browser"
;

static PyObject *
browser_get_topline(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long 	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_browser_topline((FL_OBJECT *)o);
	return Py_BuildValue("i",r);
}

static char browser_get__doc__[] =
"You better read the xforms manual on fl_get_browser for this one..."
;

static PyObject *
browser_get(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_browser((FL_OBJECT *)o);
	return Py_BuildValue("i",r);
}

static char browser_get_maxline__doc__[] =
"Returns the number of lines in the browser"
;

static PyObject *
browser_get_maxline(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_browser_maxline((FL_OBJECT *)o);
	return Py_BuildValue("i",r);
}

static char browser_get_screenlines__doc__[] =
"Returns the number of visible lines in the browser"
;

static PyObject *
browser_get_screenlines(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	r;

	if (!PyArg_ParseTuple(args, "l",&o))
		return NULL;
	r=fl_get_browser_screenlines((FL_OBJECT *)o);
	return Py_BuildValue ("i",r);
}

static char browser_set_topline__doc__[] =
"Sets the browser's first visible line"
;

static PyObject *
browser_set_topline(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;	
	int	n;

	if (!PyArg_ParseTuple(args, "li",&o,&n))
		return NULL;
	fl_set_browser_topline((FL_OBJECT *)o,n);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_set_fontsize__doc__[] =
"Set the browser's font size"
;

static PyObject *
browser_set_fontsize(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	s;

	if (!PyArg_ParseTuple(args, "li",&o,&s))
		return NULL;
	fl_set_browser_fontsize((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_set_fontstyle__doc__[] =
"Set the browser's font style"
;

static PyObject *
browser_set_fontstyle(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	s;

	if (!PyArg_ParseTuple(args, "li",&o,&s))
		return NULL;
	fl_set_browser_fontstyle((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_set_specialkey__doc__[] =
"Set the character used to change text formatting in the browser"
;

static PyObject *
browser_set_specialkey(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	s;

	if (!PyArg_ParseTuple(args, "li",&o,&s))
		return NULL;
	fl_set_browser_specialkey((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

static char browser_set_leftslider__doc__[] =
"Set the browser's slider to the left"
;

static PyObject *
browser_set_leftslider(self, args)
	PyObject *self;	/* Not used */
	PyObject *args;
{
	long	o;
	int	s;

	if (!PyArg_ParseTuple(args, "li",&o,&s))
		return NULL;
	fl_set_browser_leftslider((FL_OBJECT *)o,s);
	Py_INCREF(Py_None);
	return Py_None;
}

/* List of methods defined in the module */

static struct PyMethodDef browser_methods[] = {
	{"create",	browser_create,	1,	browser_create__doc__},
 {"add_line",	browser_add_line,	1,	browser_add_line__doc__},
 {"addto",	browser_addto,	1,	browser_addto__doc__},
 {"insert_line",	browser_insert_line,	1,	browser_insert_line__doc__},
 {"delete_line",	browser_delete_line,	1,	browser_delete_line__doc__},
 {"replace_line",	browser_replace_line,	1,	browser_replace_line__doc__},
 {"get_line",	browser_get_line,	1,	browser_get_line__doc__},
 {"load",	browser_load,	1,	browser_load__doc__},
 {"select_line",	browser_select_line,	1,	browser_select_line__doc__},
 {"deselect_line",	browser_deselect_line,	1,	browser_deselect_line__doc__},
 {"deselect",	browser_deselect,	1,	browser_deselect__doc__},
 {"isselected_line",	browser_isselected_line,	1,	browser_isselected_line__doc__},
 {"get_topline",	browser_get_topline,	1,	browser_get_topline__doc__},
 {"get",	browser_get,	1,	browser_get__doc__},
 {"get_maxline",	browser_get_maxline,	1,	browser_get_maxline__doc__},
 {"get_screenlines",	browser_get_screenlines,	1,	browser_get_screenlines__doc__},
 {"set_topline",	browser_set_topline,	1,	browser_set_topline__doc__},
 {"set_fontsize",	browser_set_fontsize,	1,	browser_set_fontsize__doc__},
 {"set_fontstyle",	browser_set_fontstyle,	1,	browser_set_fontstyle__doc__},
 {"set_specialkey",	browser_set_specialkey,	1,	browser_set_specialkey__doc__},
 {"set_leftslider",	browser_set_leftslider,	1,	browser_set_leftslider__doc__},
 
	{NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initbrowser) */

static char browser_module_documentation[] = 
""
;

void
initbrowser()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("browser", browser_methods,
		browser_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("browser.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module browser");
}

