#ifndef TREEVIEW_H
#define TREEVIEW_H

#include "etreelist.h"
#include "Widget.h"

/*
	A wrapper for the etreelist widget.
 */

class treeview : public Widget
{
Q_OBJECT;

public:

	treeview(Widget *parent=0, const char *name=0, WFlags f=0);

	virtual ~treeview();

	void create(char *path = "/", bool openFolders = FALSE);

	// override default paths ...
	void setRootIconPath(char *);
	void setParentIconPath(char *);
	void setChildIconPath(char *);
	void setParentOpenIcon(char *);

	

	void insertParent ( const char* path, const char* text,
				char *iconPath = 0, bool expand=FALSE );
	void insertChild ( const char* path, const char* text, 
		char *iconPath = 0, bool expand=FALSE );
	void updateTree ( const char* path="/" );
	void removePath ( const char* path="/" );
	void setCurrentPath ( const char* path="/" );
	
	void setGeometry(int,int,int,int);

	// return all paths in the tree
	PyObject *paths();
	

private slots:
	void selectedItem ( const char * );
	void highlightedItem ( const char * );
	void expandedItem ( const char * );
	void collapsedItem ( const char * );


private:
	ETreeList *self;
	WFlags _flags;
	Widget *_parent;
		
	QString rootIconPath,
		parentIconPath,
		childIconPath,
		parentOpenIcon,
		_name;	
};




#endif
