#include "treeview.h"
#include <Python.h>


treeview::~treeview()
{
	if (self) {
                self->clear();
		self = 0;
		}
};

treeview::treeview(Widget *parent, const char *name, WFlags f):
Widget("")
{
	_parent = parent;
	_flags = f;
	_name = name;
	self=0;
	widget = 0;
};
	

void treeview::setGeometry(int l,int t,int w,int h)
{
	if (self)
		self->setGeometry(l,t,w,h);
}


void treeview::create(char *path, bool openFolders)
{
	QWidget *owner = 0;
	if (_parent)
		owner = _parent->widget;

	QPixmap p1( rootIconPath.data()   ),
		p2( parentIconPath.data() ),
		p3( childIconPath.data()  ),
		p4( parentOpenIcon.data() );

	self = new ETreeList(path, 
		p1,
		p2, 
		p3,
		p4,
		openFolders,
		owner, 
		_name.data(), 
		_flags);

	  
	self->adjustSize();		
		
	// connect signals to slots that generate python 
	// signals	
	QObject::connect(
		self, 
		SIGNAL(selectedItem ( const char * )),
		this,
		SLOT(selectedItem ( const char * ))
		);
		
		
	QObject::connect(
		self,
		SIGNAL(highlightedItem ( const char * )),
		this,
		SLOT(  highlightedItem ( const char * ))
		);
			
			
	QObject::connect(
		self,
		SIGNAL(expandedItem ( const char * )),
		this,
		SLOT(expandedItem ( const char * ))
		);

	QObject::connect(
		self,
		SIGNAL(collapsedItem ( const char * )),
		this,
		SLOT(collapsedItem ( const char * ))
		);

	setWidget( self );		
};

// override default paths ...
void treeview::setRootIconPath(char *p)
{
	rootIconPath = p;
};

void treeview::setParentIconPath(char *p)
{
	parentIconPath = p;
};

void treeview::setChildIconPath(char *p)
{
	childIconPath = p;
};

void treeview::setParentOpenIcon(char *p)
{
	parentOpenIcon = p;
};


void treeview::insertParent ( const char* path, const char* text,
				char *iconPath, bool expand )
{
	if (self == 0) return;



	if (iconPath) {
		QPixmap p(iconPath);
		
		self->insertParent(
		path,
		text,
		p,
		expand );	
	 } else {
	 	QPixmap p;
	 
		self->insertParent(
		path,
		text,
		p,
		expand );	
	}
	
};

void treeview::insertChild ( const char* path, const char* text, 
		char *iconPath, bool expand )
{
	if (self == 0) return;

	if (iconPath) {
		QPixmap p(iconPath);

		self->insertChild(
		path,
		text,
		p,
		expand );	
	} else {
		QPixmap p;
	
		self->insertChild(
		path,
		text,
		p,
		expand );	
	}
	

};


#include <iostream.h>

PyObject *treeview::paths()
{
	if (self == 0) return Py_None;

	cout << "treeview::paths()" << endl;

	PyObject *list = PyList_New(0);
	ETreeListItem *n;
	int level;
	
	cout << "create list " << endl;

	for (n = self->first(); n; n = self->next())
	{
		PyObject *tuple = PyList_New(0);

		cout << "Calling getAttr" << n->level <<  endl;
		level = n->level;
		//level = 0;

		cout << "1" << endl;
		// fill the tuple
		PyList_Append( tuple, PyString_FromString( n->itemPath.data() ) );
		cout << "2" << endl;

		PyList_Append( tuple, PyInt_FromLong( (long) level) );
		
		cout << "Created tuples " << endl;
		// create a list of tuples
		PyList_Append( list, tuple );
	}
	
	// return the list
	// [( path, level ), ... ]
	cout << "Leaving paths()" << endl; 

	return list;
}

void treeview::updateTree ( const char* path )
{
	if (self == 0) return;
	self->updateTree( path );
};

void treeview::removePath ( const char* path )
{
	if (self == 0) return;
	self->removePath( path );
};
	
void treeview::setCurrentPath ( const char* path )
{
	if (self == 0) return;
	self->setCurrentPath( path );
};


// slots that emit python signals
void treeview::selectedItem ( const char *p )
{
	Object::emit("selectedItem", 
		Py_BuildValue("(s)",p), 1
		);
};

void treeview::highlightedItem ( const char *p )
{
	Object::emit("highlightedItem", 
		Py_BuildValue("(s)",p), 1
		);
};

void treeview::expandedItem ( const char *p )
{
	Object::emit("expandedItem", 
		Py_BuildValue("(s)",p), 1
		);
};

void treeview::collapsedItem ( const char *p )
{
	Object::emit("collapsedItem", 
		Py_BuildValue("(s)",p),1 
		);
};
