#include "toolbutton.h"
#include "toolbar.h"

ToolButton::ToolButton(const char *pixmapPath, 
		const char * textLabel, 
		const char * grouptext, 
		ToolBar * parent, 
		const char * name):Widget("")
{
	QPixmap *pm = new QPixmap( pixmapPath );
	self = new QToolButton( *pm, textLabel, grouptext,
		this, SLOT( Clicked() ), (QToolBar *) parent->widget, name );
	
	delete pm;
	setWidget( self );
	bName = name;
};


ToolButton::~ToolButton()
{
	delete self;
};


void ToolButton::Clicked()
{
// printf("Inside ToolButton::Clicked\n");
	char *p = bName.data();
	emit( "clicked", Py_BuildValue("(s)",p), 1 ); 
};

