#include "mainwindow.h"
#include "toolbar.h"



ToolBar::ToolBar(Widget *parent, const char *name):
Widget("")
{
	if (parent)
		self = new QToolBar((QMainWindow *) parent->widget,name);
	else
		self = new QToolBar();

	setWidget( self );
};

ToolBar::~ToolBar()
{
	delete self;
};

void ToolBar::addSeparator()
{
	self->addSeparator();
};

void ToolBar::setOrientation(char *orientation)
{
	if (stricmp(orientation,"VERTICAL") == 0)
		self->setOrientation( QToolBar::Vertical );
	else
		self->setOrientation( QToolBar::Horizontal );
};

void ToolBar::show()
{
	self->show();
};

void ToolBar::setStretchableWidget(Widget *w)
{
	self->setStretchableWidget(w->widget);
};

