/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#include "qdbtutil.h"

QString truncateString(QPainter *p,const char *text,int width,int align)
{
  //printf("truncateString(%p,%s,%d,%d)\n",p,text,width,align);
  QFontMetrics fm = p->fontMetrics();

  // the empty string is easy to truncate
  if (strlen(text)==0) return(text);
  
  QString truncTxt;
  QString txt=text;
  int txtWidth=fm.width(txt);

  // if the string fits, we are done
  if (txtWidth<=width)
  {
    truncTxt=txt;
  }
  else // we have to compute how many characters fit
  {
    QString tmpString(16);
    int l=txt.length();
    if (align==AlignLeft)
    {
      int i=1;
      char c=txt[0];
      truncTxt+=c;
      while (i<l)
      {
        c=txt[i++];
        //tmpString=truncTxt.copy();
        tmpString=truncTxt.copy();
        tmpString+=c;
        tmpString+="..";
        if (fm.width(tmpString)<=width)
          truncTxt+=c;
        else
          break;
      }
      truncTxt+="..";
    }
    else
    {
      int i=l-1;
      char c=txt[i];
      truncTxt+=c;
      while (i>0)
      {
        c=txt[--i];
        tmpString="..";
        tmpString+=c;
        tmpString+=truncTxt;
        if (fm.width(tmpString)<=width)
          truncTxt.insert(0,c);
        else
          break;
      }
      truncTxt.prepend("..");
    }
  }
  return truncTxt;
}

