/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _QDBTLINED_H
#define _QDBTLINED_H

#include <qwidget.h>
#include <qlined.h>
#include <qcolor.h>

class QComboBox;

class QdbtLineEdit : public QLineEdit
{
  public:
    QdbtLineEdit(QWidget *parent=0, const char *name=0 );
   ~QdbtLineEdit();
    void setColor(const QColor &foreground,const QColor &background);
    void setSelected(bool b,bool f=FALSE);

  protected:
    void paintEvent( QPaintEvent * );
    void paletteChange( const QPalette &pal);
    void focusInEvent( QFocusEvent * );
    void focusOutEvent( QFocusEvent * );    
    void keyPressEvent( QKeyEvent * );
    
  protected:  
    QColor fg,bg;
    bool   selected;
};

#endif // QDBTLINED_H
