/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _QDBTCELLMATRIX_H
#define _QDBTCELLMATRIX_H

#include "qdbttabcell.h"
#include <qvector.h>

typedef QVector<QdbtTableCell> Row;
typedef QVector<Row> Matrix;

// This class represents a 2D array (matrix) where the cells of the table
// are stored. It is implemented as a QVector of cells rows.
// Each cell row is a QVector of cells (one for each column).
// I have chosen this order, because I assume the number of rows changes 
// more frequently than the number of columns. 

class QdbtCellMatrix
{
  public:
    QdbtCellMatrix(int r=0,int c=0);
   ~QdbtCellMatrix(); 
    void resize(int r,int c);
    void insertCol(int c);
    void insertRow(int r);
    void removeCol(int c);
    void removeRow(int r);
    int  cols() const { return col; }
    int  rows() const { return row; }
    QdbtTableCell *at(int r,int c) const;
    QdbtTableCell *&operator()(int r,int c);
  
  private:
    int row,col;
    Matrix m; 
};

#endif
