#ifndef QDBT_TABULAR_H
#define QDBT_TABULAR_H

#include "Widget.h"
#include "qdbttabular.h"




class qdbt_tabular : public Widget
{
Q_OBJECT;

public:
	qdbt_tabular(
		Widget *parent,
		const char *name
		);
		
	virtual ~qdbt_tabular();

	void setDimensions(int r, int c);
	void setGeometry(int,int,int,int);
    void setColumnWidth(int col,int width); 
	
	    void insertRow(int row=-1,bool selectable=TRUE);
    void removeRow(int row);
    void insertCol(int col=-1);
    void removeCol(int col);
    void clear();
    int  numRows() const;
    int  numCols() const;
		
		
    void cellTextAndPixmap(const char *text,const char *pixmapPath,int row,int col,
                    const char *color="black",
                    int align=AlignLeft,bool editable=FALSE);
		    
    void cellText(const char *text,int row,int col,
                    const char *color = "black",
                    int align=AlignLeft,bool editable=FALSE);
		    
    void cellPixmap(const char *pixmapPath,int row,int col,
                    int align=AlignLeft);		


   void section(int col, char *text, int align=AlignLeft); 	

private slots:



		
 	void _sectionClicked(int col);
     	void _selected(int row,bool state);
         void _activated(int row);
        void _cellEdited(int row,int col);
         void _cellSelected(int row,int col,bool state);
          void _cellActivated(int row,int col);
 
		
private:
	QdbtTabular *self;
	
	// current column, row text ect .
	int cRow, cCol; 
	QString cText;
	QPixmap cPix;
	bool cEditable;
	int cAlign;
};








#endif
